/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGRuntimeException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneResource;

public class PhoneResourceDao
extends AbstractIdDao<PhoneResource> {
    public PhoneResourceDao(Connection con, int moduleId) {
        super(con, moduleId, "inv_phone_resource");
    }

    protected PhoneResource getFromRS(ResultSet rs) throws SQLException {
        return new PhoneResource(rs.getInt("id")).setPhoneFrom(rs.getLong("phoneFrom")).setPhoneTo(rs.getLong("phoneTo")).setDateFrom((Date)rs.getDate("dateFrom")).setDateTo((Date)rs.getDate("dateTo")).setComment(rs.getString("comment")).setCategoryId(rs.getInt("categoryId"));
    }

    protected void updateImpl(PhoneResource phoneResource) throws SQLException {
        if (phoneResource.getPhoneTo() < 0L || phoneResource.getPhoneFrom() < 0L || phoneResource.getPhoneTo() < phoneResource.getPhoneFrom()) {
            throw new BGRuntimeException();
        }
        String querySet = "phoneFrom=?, phoneTo=?, dateFrom=?, dateTo=?, comment=?, categoryId=?";
        try (PreparedStatement ps = this.prepareStatement((Id)phoneResource, querySet);){
            int index = 1;
            ps.setLong(index++, phoneResource.getPhoneFrom());
            ps.setLong(index++, phoneResource.getPhoneTo());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)phoneResource.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)phoneResource.getDateTo()));
            ps.setString(index++, phoneResource.getComment());
            ps.setInt(index++, phoneResource.getCategoryId());
            this.executeUpdate((Id)phoneResource, index, ps);
        }
    }

    public List<PhoneResource> list() throws SQLException {
        return this.list(null, "id", new Object[0]);
    }

    public List<PhoneResource> list(int categoryId) throws SQLException {
        return this.list("categoryId=?", "phoneFrom", new Object[]{categoryId});
    }

    public List<PhoneResource> list(int categoryId, Date date) throws SQLException {
        return this.list("categoryId=? and (dateFrom IS NULL OR dateFrom <= ?) and ( dateTo IS NULL OR dateTo >= ? ) ", "id", new Object[]{categoryId, date, date});
    }

    public List<PhoneResource> list(Date dateFrom, Date dateTo) throws SQLException {
        return this.list("(dateFrom IS NULL OR dateFrom <= ?) and ( dateTo IS NULL OR dateTo >= ? ) ", "id", new Object[]{dateFrom, dateTo});
    }

    public List<PhoneResource> list(Set<Integer> categoryIds) throws SQLException {
        if (categoryIds == null || categoryIds.size() == 0) {
            return new ArrayList<PhoneResource>();
        }
        return this.list("categoryId IN (" + Utils.toString(categoryIds) + ")", "id", new Object[0]);
    }

    public void importData(int categoryId, String importData) throws SQLException {
        if (importData == null) {
            throw new BGRuntimeException("importData is null!!!");
        }
        if (categoryId < 1) {
            throw new BGRuntimeException("categoryId not set!!!");
        }
        for (String line : importData.split("\n")) {
            String[] resourceData = line.split("\t");
            PhoneResource phoneResource = new PhoneResource().setCategoryId(categoryId).setPhoneFrom(resourceData.length > 0 ? Utils.parseLong((String)resourceData[0]) : 0L).setPhoneTo(resourceData.length > 1 ? Utils.parseLong((String)resourceData[1]) : 0L).setDateFrom(resourceData.length > 2 ? TimeUtils.parseDate((String)resourceData[2], (String)"dd.MM.yyyy") : null).setDateTo(resourceData.length > 3 ? TimeUtils.parseDate((String)resourceData[3], (String)"dd.MM.yyyy") : null).setComment(resourceData.length > 4 ? resourceData[4] : "");
            this.update(phoneResource);
        }
    }
}

