/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.math.BigInteger;
import java.util.List;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpRange;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceInstance;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceUtils;

public class IpResourceRange
extends IpRange
implements IpResourceInstance {
    private int ipResourceId;

    public IpResourceRange() {
    }

    public IpResourceRange(int ipResourceId, byte[] addressFrom, byte[] addressTo) {
        super(addressFrom, addressTo);
        this.ipResourceId = ipResourceId;
    }

    @Override
    @XmlAttribute(name="resId")
    public int getIpResourceId() {
        return this.ipResourceId;
    }

    @Override
    public void setIpResourceId(int ipResourceId) {
        this.ipResourceId = ipResourceId;
    }

    public static void newIpRangeList(IpResource resource, List<IpResourceSubscription> subscriptionList, String filter, final int range, int max, final List<IpResourceRange> result) {
        boolean ipv6 = resource.getAddressFrom() != null && resource.getAddressFrom().length == 16;
        new IpResourceRangeExtractor(max, IpResourceUtils.getFilterIpRange(filter, ipv6)){
            final BigInteger bigIntegerRange;
            {
                super(size, filter);
                this.bigIntegerRange = BigInteger.valueOf(range);
            }

            @Override
            protected boolean next(int resourceId, IpRange ipRange) {
                BigInteger bigIntegerTo;
                BigInteger bigIntegerFrom;
                if (this.bigIntegerRange.compareTo(BigInteger.ZERO) <= 0) {
                    return false;
                }
                BigInteger filterFrom = null;
                BigInteger filterTo = null;
                if (ipRange.getAddressFrom().length == 4) {
                    bigIntegerFrom = IpAddress.convertIp4AddresToBigInt(ipRange.getAddressFrom());
                    bigIntegerTo = IpAddress.convertIp4AddresToBigInt(ipRange.getAddressTo());
                    if (this.filter != null) {
                        filterFrom = IpAddress.convertIp4AddresToBigInt(this.filter.getAddressFrom());
                        filterTo = IpAddress.convertIp4AddresToBigInt(this.filter.getAddressTo());
                    }
                } else {
                    bigIntegerFrom = IpAddress.convertIp6AddresToBigInt(ipRange.getAddressFrom());
                    bigIntegerTo = IpAddress.convertIp6AddresToBigInt(ipRange.getAddressTo());
                    if (this.filter != null) {
                        filterFrom = IpAddress.convertIp6AddresToBigInt(this.filter.getAddressFrom());
                        filterTo = IpAddress.convertIp6AddresToBigInt(this.filter.getAddressTo());
                    }
                }
                BigInteger next = bigIntegerFrom.add(this.bigIntegerRange).add(BigInteger.ONE.negate());
                while (next.compareTo(bigIntegerTo) <= 0) {
                    if (this.filter == null || filterFrom.compareTo(bigIntegerFrom) < 1 && filterTo.compareTo(next) > -1) {
                        boolean ipv4 = ipRange.getAddressFrom().length == 4;
                        result.add(new IpResourceRange(resourceId, ipv4 ? IpAddress.convertBigIntToIp4Address(bigIntegerFrom) : IpAddress.convertBigIntToIp6Address(bigIntegerFrom), ipv4 ? IpAddress.convertBigIntToIp4Address(next) : IpAddress.convertBigIntToIp6Address(next)));
                    }
                    bigIntegerFrom = next.add(BigInteger.ONE);
                    next = next.add(this.bigIntegerRange);
                    if (--this.size > 0) continue;
                    return false;
                }
                return true;
            }
        }.process(resource, subscriptionList);
    }

    @Override
    public String getGuiTitle() {
        return this.toString();
    }

    static abstract class IpResourceRangeExtractor {
        protected int size;
        protected IpRange filter;

        IpResourceRangeExtractor(int size, IpRange filter) {
            this.size = size;
            this.filter = filter;
        }

        protected abstract boolean next(int var1, IpRange var2);

        public void process(IpResource resource, List<IpResourceSubscription> subscriptionList) {
            IpResourceRange current = new IpResourceRange(resource.getId(), resource.getAddressFrom(), resource.getAddressTo());
            for (IpResourceSubscription subscription : subscriptionList) {
                boolean ok2;
                boolean ok4;
                byte[] addressFrom1 = current.addressFrom;
                byte[] addressTo1 = subscription.getAddressFrom();
                byte[] addressFrom2 = subscription.getAddressTo();
                byte[] addressTo2 = current.addressTo;
                boolean ok3 = IpAddress.compare(addressTo1, 0, addressTo1.length, addressTo2, 0, addressTo2.length) <= 0;
                boolean bl = ok4 = IpAddress.compare(addressFrom2, 0, addressFrom2.length, addressFrom1, 0, addressFrom1.length) >= 0;
                if (!ok3 || !ok4) continue;
                boolean ok1 = IpAddress.compare(addressFrom1, 0, addressFrom1.length, addressTo1, 0, addressTo1.length) < 0;
                boolean bl2 = ok2 = IpAddress.compare(addressFrom2, 0, addressFrom2.length, addressTo2, 0, addressTo2.length) < 0;
                if (ok1) {
                    addressTo1 = IpAddress.newAndDecrement(addressTo1);
                    if (!this.next(resource.getId(), new IpRange(addressFrom1, addressTo1))) {
                        return;
                    }
                }
                if (ok2) {
                    addressFrom2 = IpAddress.newAndIncrement(addressFrom2);
                    current = new IpResourceRange(resource.getId(), addressFrom2, addressTo2);
                    continue;
                }
                return;
            }
            this.next(current.getIpResourceId(), new IpRange(current.getAddressFrom(), current.getAddressTo()));
        }
    }
}

