<%@ page contentType="text/html; charset=UTF-8"%><%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>

<c:set var="currency"><span class="CUR"></span></c:set>

<div class="tile">
	<div class="flexRow">
		<div class="titleFont3">Остаток на <fmt:formatDate value="${balanceDatetime}" type="BOTH" dateStyle="SHORT" timeStyle="SHORT" /></div>
		<div class="titleFont3" style="text-align: right;"><fmt:formatNumber value="${balanceSum}" groupingUsed="true" maxFractionDigits="2" minFractionDigits="2" currencyCode="" />${currency}</div>
	</div>
	<div class="flexRow">
		<div style="font-size: 90%;">
			<span class="paramColor" style="display: inline-block; padding-right: 3em;">Лимит: <fmt:formatNumber type="number" pattern="###,###,##0.00" value="${webBalanceData.contract.balanceLimit}"/><span class="CUR"></span></span>
			<c:if test="${webBalanceData.reserve > 0}"><span class="paramColor" style="display: inline-block; padding-right: 3em;">Резерв: <fmt:formatNumber type="number" pattern="###,###,##0.00" value="${webBalanceData.reserve}"/><span class="CUR"></span></span></c:if>
			<span class="paramColor" style="display: inline-block; padding-right: 2em;">Статус: ${contractStatusMap[contractRuntime.status]}</span> 
		</div>
		<c:if test="${has_independent_subs == 1}"><div><button class="btn btn-primary" onclick="showBlock( 'balanceRoot', 'distributeBalance', balanceQuery ); return false;">Перенос средств</button></div></c:if>
	</div>
</div>

<c:if test="${not empty dataMap['messages']}">
<div class="tile">
	<c:forEach var="message" varStatus="status" items="${dataMap['messages']}">
		<div>${message}</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>
</div>	
</c:if>

<c:if test="${not empty webBalanceData.paymentList}">
<div class="tile">
	<div class="flexRow titleBottomLine" style="margin-bottom: 10px;">
		<div class="titleFont3">Платежи</div>
		<div style="text-align: right; cursor: pointer;" onclick="showBlock( 'balanceRoot', 'payments', balanceQuery ); return false;"><img src="${pageContext.request.contextPath}/img/right.png" height="24"></div>
	</div>
	<c:forEach var="item" varStatus="status" items="${webBalanceData.paymentList}">
		<div class="flexRow" style="margin: 10px 5px 5px 10px; color: #555;">
			<div>
				<div style="overflow: auto;">
					<span style="float: left; margin-right: 15px;"><fmt:formatDate value="${item.date}" dateStyle="SHORT" /></span>
					<span style="float: left; font-weight: bold;">${webBalanceData.paymentTypeMap[item.typeId].guiTitle}</span>
				</div>
				<div style="margin-top: 5px;" class="paramColor">${item.comment}</div>
			</div>
			<div class="sum3">
			    
                <jsp:include page="../include/payment_receipt_link.jsp">
                    <jsp:param name="type" value="payment"/>
                    <jsp:param name="id" value="${item.id}"/>
                </jsp:include>
                
			    <fmt:formatNumber value="${item.sum}" groupingUsed="true" maxFractionDigits="2" minFractionDigits="2"/><span class="CUR"></span>
			</div>
		</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>
</div>
</c:if>

<c:if test="${not empty webBalanceData.chargeList}">
<div class="tile">
	<div class="flexRow titleBottomLine">
		<div class="titleFont3">Списания</div>
		<div style="text-align: right;"><a href="" onclick="showBlock( 'balanceRoot', 'charges', balanceQuery ); return false;"><img src="${pageContext.request.contextPath}/img/right.png" height="24"></a></div>
	</div>
	<c:forEach var="item" varStatus="status" items="${webBalanceData.chargeList}">
		<div class="flexRow" style="margin: 10px 5px 5px 10px; color: #555;">
			<div>
				<div style="overflow: auto;">
					<span style="float: left; margin-right: 15px;"><fmt:formatDate value="${item.date}" dateStyle="SHORT" /></span>
					<span style="float: left; font-weight: bold;">${webBalanceData.chargeTypeMap[item.typeId].guiTitle}</span>
				</div>
				<div style="margin-top: 5px;" class="paramColor">${item.comment}</div>
			</div>
			<div class="sum3">

			    <jsp:include page="../include/payment_receipt_link.jsp">
                    <jsp:param name="type" value="charge"/>
                    <jsp:param name="id" value="${item.id}"/>
                </jsp:include>
                
			    <fmt:formatNumber value="${item.sum}" groupingUsed="true" maxFractionDigits="2" minFractionDigits="2"/><span class="CUR"/>
			</div>
		</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>
</div>
</c:if>

<div class="tile">
	<div class="flexRow titleBottomLine">
		<div class="titleFont3">Наработка</div>
		<div style="text-align: right;"><a href="" onclick="showBlock( 'balanceRoot', 'accounts', balanceQuery ); return false;"><img src="${pageContext.request.contextPath}/img/right.png" height="24"></a></div>
	</div>
	<c:forEach var="item" varStatus="status" items="${balanceAccounts}">
		<div class="flexRow" style="margin: 10px 5px 5px 10px; color: #555;">
			<div>
				<div style="overflow: auto;">
					<span style="float: left; margin-right: 15px; width: 7em;"><fmt:formatDate value="${item[0]}" pattern="LLLL yyyy" /></span>
					<span style="float: left; font-weight: bold;">${item[1]}</span>
				</div>
				<div style="margin-top: 5px;" class="paramColor"></div>
			</div>
			<div class="sum3"><fmt:formatNumber value="${item[2]}" groupingUsed="true" maxFractionDigits="2" minFractionDigits="2"/><span class="CUR"></span></div>
		</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>
</div>

<c:if test="${not empty webBalanceData.reserveList}">
<div class="tile">
	<div class="flexRow">
		<div class="titleFont3">Резервы</div>
		<div style="text-align: right;"><a href="" onclick="showBlock( 'balanceRoot', 'reserves', balanceQuery ); return false;"><img src="${pageContext.request.contextPath}/img/right.png" height="24"></a></div>
	</div>
	<c:forEach var="item" varStatus="status" items="${webBalanceData.reserveList}">
		<div class="flexRow" style="margin: 10px 5px 5px 10px; color: #555;">
			<div>
				<div><span style="font-weight: bold;">${webBalanceData.reserveTypeMap[item.typeId].guiTitle}</span></div>
				<div style="margin-top: 5px;" class="paramColor">Период: <span>${item.period}</span></div>
				<c:if test="${not empty item.dateClose}"><div style="margin-top: 5px;" class="paramColor">Дата закрытия: <span><fmt:formatDate value="${item.dateClose}" dateStyle="SHORT" /></span></div></c:if>
				<c:if test="${not empty item.comment}"><div style="margin-top: 5px;" class="paramColor">${item.comment}</div></c:if>
			</div>
			<div class="sum3"><fmt:formatNumber value="${item.sum}" groupingUsed="true" maxFractionDigits="2" minFractionDigits="2"/><span class="CUR"/></div>
		</div>
		<c:if test="${not status.last}"><div class="line"></div></c:if>
	</c:forEach>
</div>
</c:if>
