/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.server.bean;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.modules.hd.server.bean.CPStatus;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class CPStatusManager {
    private Connection con;
    private String tableName;

    public CPStatusManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "hd_cp_status_" + mid;
    }

    public CPStatus getServiceStatus(int id) {
        CPStatus result = null;
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE id=?");
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getHdContractServiceStatusFromRS(rs);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<CPStatus> getServiceStatusList() {
        ArrayList<CPStatus> result = new ArrayList<CPStatus>();
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.tableName);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result.add(this.getHdContractServiceStatusFromRS(rs));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private CPStatus getHdContractServiceStatusFromRS(ResultSet rs) throws SQLException {
        CPStatus result = new CPStatus();
        result.setId(rs.getInt("id"));
        result.setContractPackageId(rs.getInt("cpid"));
        result.setDate(TimeUtils.convertSqlDateToCalendar((Date)rs.getDate("date")));
        result.setStatus(rs.getInt("status"));
        result.setSumma(rs.getFloat("summa"));
        return result;
    }

    public void updateServiceStatus(CPStatus serviceStatus) {
        try {
            PreparedStatement ps;
            String query = null;
            if (serviceStatus.getId() > 0) {
                query = "UPDATE " + this.tableName + " SET cpid=?, date=?, status=?, summa=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(5, serviceStatus.getId());
            } else {
                query = "INSERT INTO " + this.tableName + " (cpid, date, status, summa) VALUES (?,?,?,?)";
                ps = this.con.prepareStatement(query, 1);
            }
            ps.setInt(1, serviceStatus.getContractPackageId());
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)serviceStatus.getDate()));
            ps.setInt(3, serviceStatus.getStatus());
            ps.setFloat(4, serviceStatus.getSumma());
            ps.executeUpdate();
            if (serviceStatus.getId() <= 0) {
                serviceStatus.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteServiceStatus(int id) {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE id=?");
            ps.setInt(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

