/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.client.admin;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginClient;
import ru.bitel.bgbilling.kernel.plugin.client.BGPluginManagerClient;
import ru.bitel.bgbilling.plugins.crm.client.admin.ProblemEditor;
import ru.bitel.common.Utils;

public class ProblemHistoryViewer
extends BGPanel {
    private BGTable table = new BGTable();
    private JButton clearHistory = new JButton("\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e");
    private JButton okButton = new JButton("\u0417\u0430\u043a\u0440\u044b\u0442\u044c");
    private JButton backToList = new JButton("\u041d\u0430\u0437\u0430\u0434 \u043a \u0441\u043f\u0438\u0441\u043a\u0443");
    private JButton prevButton = new JButton("<< \u041f\u0440\u0435\u0434.");
    private JButton nextButton = new JButton("\u0421\u043b\u0435\u0434. >>");
    private JLabel entryInfo = new JLabel("");
    private ProblemEditor detailedView = new ProblemEditor(true);
    private JScrollPane tablePane;
    private int selectedRow;

    public ProblemHistoryViewer() {
        try {
            BGPluginClient plugin = BGPluginManagerClient.getManager().getPlugin("ru.bitel.bgbilling.plugins.crm");
            this.table.setHeader(plugin.getResourceBundle(), plugin.getTable("history"), "history");
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void init(String module, int mid) {
        super.init(module, mid);
        this.detailedView.init(module, mid);
    }

    private void jbInit() throws Exception {
        this.setButtonsVisibility(false);
        JPanel mainPanel = new JPanel(new GridBagLayout());
        mainPanel.setBorder((Border)new BGTitleBorder("\u0418\u0441\u0442\u043e\u0440\u0438\u044f"));
        this.detailedView.setVisible(false);
        this.detailedView.setBorder((Border)new BGTitleBorder("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0438\u0441\u0438"));
        this.tablePane = new JScrollPane((Component)this.table);
        this.tablePane.setMinimumSize(new Dimension(100, 200));
        this.tablePane.setPreferredSize(new Dimension(100, 200));
        mainPanel.add((Component)this.tablePane, new GridBagConstraints(0, 0, 8, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        mainPanel.add((Component)((Object)this.detailedView), new GridBagConstraints(0, 1, 8, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.clearHistory, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        mainPanel.add((Component)new JLabel(), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.prevButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.entryInfo, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.nextButton, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        mainPanel.add((Component)new JLabel(), new GridBagConstraints(5, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.backToList, new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.okButton, new GridBagConstraints(7, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.clearHistory.addActionListener(e -> this.selectClear());
        this.prevButton.addActionListener(e -> this.selectPrev());
        this.nextButton.addActionListener(e -> this.selectNext());
        this.backToList.addActionListener(e -> {
            this.tablePane.setVisible(true);
            this.detailedView.setVisible(false);
            this.setButtonsVisibility(false);
        });
        this.okButton.addActionListener(e -> this.okPressed(e));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ProblemHistoryViewer.this.tablePane.setVisible(false);
                    ProblemHistoryViewer.this.setButtonsVisibility(true);
                    ProblemHistoryViewer.this.selectedRow = ProblemHistoryViewer.this.table.getSelectedRow();
                    if (ProblemHistoryViewer.this.selectedRow == 0) {
                        ProblemHistoryViewer.this.prevButton.setEnabled(false);
                    } else if (ProblemHistoryViewer.this.selectedRow == ProblemHistoryViewer.this.table.getRowCount() - 1) {
                        ProblemHistoryViewer.this.nextButton.setEnabled(false);
                    }
                    ProblemHistoryViewer.this.showRow();
                }
            }
        });
        this.setLayout(new GridBagLayout());
        this.add(mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private void setButtonsVisibility(boolean vis) {
        this.backToList.setVisible(vis);
        this.prevButton.setVisible(vis);
        this.prevButton.setEnabled(true);
        this.nextButton.setVisible(vis);
        this.nextButton.setEnabled(true);
        this.entryInfo.setVisible(vis);
    }

    private void selectClear() {
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0441\u0442\u043e\u0440\u0438\u044e?") == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("RegisterProblemHistoryClear");
            request.setAttribute("id", this.getId());
            Document doc = TransferManager.getDocument((Request)request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.table.removeRows();
            }
        }
    }

    private void selectPrev() {
        if (this.selectedRow == 0) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u042d\u0442\u043e \u043f\u0435\u0440\u0432\u0430\u044f \u0437\u0430\u043f\u0438\u0441\u044c!");
            return;
        }
        --this.selectedRow;
        this.nextButton.setEnabled(true);
        if (this.selectedRow == 0) {
            this.prevButton.setEnabled(false);
        }
        this.showRow();
    }

    private void selectNext() {
        if (this.selectedRow == this.table.getRowCount() - 1) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u042d\u0442\u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0437\u0430\u043f\u0438\u0441\u044c!");
            return;
        }
        ++this.selectedRow;
        this.prevButton.setEnabled(true);
        if (this.selectedRow == this.table.getRowCount() - 1) {
            this.nextButton.setEnabled(false);
        }
        this.showRow();
    }

    private void showRow() {
        int id;
        if ((this.selectedRow >= 0 || this.selectedRow < this.table.getRowCount()) && (id = Utils.parseInt((String)((String)this.table.getValueAt(this.selectedRow, 0)))) != 0) {
            this.detailedView.setId(id);
            this.detailedView.trySetData();
            this.detailedView.setVisible(true);
            this.entryInfo.setText((String)this.table.getValueAt(this.selectedRow, 2) + ", " + (String)this.table.getValueAt(this.selectedRow, 1));
        }
    }

    private void okPressed(ActionEvent e) {
        this.tablePane.setVisible(true);
        this.detailedView.setVisible(false);
        this.setButtonsVisibility(false);
        this.setVisible(false);
    }

    public void setData() throws Exception {
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("RegisterProblemHistoryTable");
        request.setAttribute("id", this.getId());
        Document doc = TransferManager.getDocument((Request)request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(doc);
            this.clearHistory.setEnabled(this.table.getRowCount() > 0);
        }
    }
}

