/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGSelectFilePanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class ServiceConfigAutoBillManager
extends ServiceConfigTabbedPanel {
    private BGSelectFilePanel selectFilePanel = new BGSelectFilePanel(false);
    private BGButton process = new BGButton();
    private BGButton payed = new BGButton();
    private JTabbedPane tabbed = new JTabbedPane();
    private BGTable table = new BGTable();
    private JTextArea memo = new JTextArea();

    public ServiceConfigAutoBillManager() {
        this.initialize();
        this.table.setHeader(this.rb_name, this.moduleDoc, "bill_man");
    }

    private void initialize() {
        this.process.setText("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c");
        this.process.setActionCommand("process");
        this.payed.setText("\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043e");
        JPanel toppanel = new JPanel();
        toppanel.setLayout(new GridBagLayout());
        toppanel.setBorder(new TitledBorder(" \u041e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 "));
        toppanel.add((Component)new JLabel("\u0424\u0430\u0439\u043b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        toppanel.add((Component)this.selectFilePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        toppanel.add((Component)this.process, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        JPanel pan = new JPanel(new GridBagLayout());
        pan.add((Component)this.payed, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 13, 3, new Insets(0, 5, 5, 5), 0, 0));
        BGPanel tab1 = new BGPanel((LayoutManager)new GridBagLayout());
        tab1.add((Component)new JScrollPane((Component)this.table), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        tab1.add((Component)pan, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 3, new Insets(0, 5, 5, 5), 0, 0));
        BGPanel tab2 = new BGPanel((LayoutManager)new GridBagLayout());
        tab2.add((Component)new JScrollPane(this.memo), (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.tabbed.setBorder(new TitledBorder(" \u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 "));
        this.tabbed.addTab("\u0421\u0447\u0435\u0442\u0430", (Component)tab1);
        this.tabbed.addTab("\u041b\u043e\u0433", (Component)tab2);
        this.setLayout(new GridBagLayout());
        this.add(toppanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this.tabbed, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 5, 5, 5), 0, 0));
        ActionListener actionMapper = e -> this.actionMapper(e);
        this.process.addActionListener(actionMapper);
        this.payed.setActionCommand("setPayed");
        this.payed.addActionListener(actionMapper);
    }

    private void actionMapper(String action) {
        if (action.equals("process")) {
            this.processFile();
        } else if (action.equals("setPayed")) {
            this.setPayed();
        }
    }

    private void actionMapper(ActionEvent e) {
        this.actionMapper(e.getActionCommand());
    }

    private void processFile() {
        File file = this.selectFilePanel.getSelectedFile();
        if (file == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0444\u0430\u0439\u043b!");
            return;
        }
        String fileString = null;
        try {
            fileString = new String(Utils.readByBlock((InputStream)new FileInputStream(file)), "UTF-8");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
            return;
        }
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("ProcessExtraction");
        req.setModuleId(this.getModuleId());
        req.setAttribute("file", fileString);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
            this.setMemoText(XMLUtils.getNode((Document)doc, (String)"log"));
        }
    }

    private void setPayed() {
        Object ids = "";
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            ids = (String)ids + String.valueOf(this.table.getValueAt(i, 0)) + ":" + String.valueOf(this.table.getValueAt(i, 1)) + ";";
        }
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("SetPayed");
        req.setModuleId(this.getModuleId());
        req.setAttribute("ids", (String)ids);
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.table.updateData(XMLUtils.getNode((Document)doc, (String)"table"));
        }
    }

    private void setMemoText(Node blockText) {
        this.memo.setText("");
        NodeList nodeList = blockText.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeName().equals("p")) {
                this.memo.append(nodeList.item(i).getTextContent() + "\r\n\r\n");
                continue;
            }
            this.memo.append(nodeList.item(i).getTextContent() + "\r\n");
        }
    }
}

