/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory.attributes;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttribute;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeKit;
import ru.bitel.bgbilling.plugins.shop.common.service.WarehouseService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public abstract class AttributesCommonPanel<T extends IdTitle>
extends BGUPanel {
    private WarehouseService warehouseService;
    protected BGUList<T> list = new BGUList();

    protected AttributesCommonPanel(String titlePanel) {
        BGSwingUtilites.wrapBorder((JPanel)((Object)this), (String)titlePanel);
    }

    protected WarehouseService getWarehouseService() {
        if (this.warehouseService == null) {
            this.warehouseService = (WarehouseService)((ClientContext)this.getContext()).getPort(WarehouseService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.warehouseService;
    }

    protected void jbInit() throws Exception {
        final BGDialogToolBar toolBar = new BGDialogToolBar();
        toolBar.setDefaultButtons(e -> {
            switch (e.getActionCommand()) {
                case "newItem": {
                    try {
                        this.toolbarNewItem();
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                    break;
                }
                case "editItem": {
                    IdTitle selected = (IdTitle)this.list.getSelectedValue();
                    if (selected == null) {
                        BGToolTip.showErrorMessage(this.list, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                        return;
                    }
                    try {
                        this.toolbarEditItem(selected);
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                    break;
                }
                case "deleteItem": {
                    IdTitle selected = (IdTitle)this.list.getSelectedValue();
                    if (selected == null) {
                        BGToolTip.showErrorMessage(this.list, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f");
                        return;
                    }
                    try {
                        this.toolbarDeleteItem(selected);
                        break;
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }
        });
        toolBar.setFloatable(false);
        toolBar.setOrientation(0);
        toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        this.list.setCellRenderer((ListCellRenderer)new AttributesListRenderer());
        this.list.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    toolBar.actionPerformed(new ActionEvent(AttributesCommonPanel.this.list, 0, "editItem"));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0);
        this.add((Component)toolBar, constraints);
        constraints.fill = 1;
        constraints.weighty = 1.0;
        this.add(new JScrollPane((Component)this.list), constraints);
        this.jbInit0();
    }

    protected abstract void jbInit0() throws Exception;

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.refreshImpl());
    }

    protected abstract void refreshImpl() throws Exception;

    protected abstract void toolbarNewItem() throws Exception;

    protected abstract void toolbarEditItem(T var1) throws Exception;

    protected abstract void toolbarDeleteItem(T var1) throws Exception;

    private final class AttributesListRenderer
    extends DefaultListCellRenderer {
        private AttributesListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String title;
            if (value instanceof StockItemAttribute) {
                StockItemAttribute attribute = (StockItemAttribute)value;
                title = attribute.getTitle() + " (" + attribute.getAttributeType().getName() + ")";
            } else {
                StockItemAttributeKit kit = (StockItemAttributeKit)value;
                title = kit.getTitle() + " (\u0410\u0442\u0440\u0438\u0431\u0443\u0442\u043e\u0432: " + kit.getAttributes().size() + ")";
            }
            JPanel p = new JPanel(new GridBagLayout());
            p.add((Component)new JLabel(title), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
            p.setBackground(isSelected ? list.getSelectionBackground() : Color.WHITE);
            return p;
        }
    }
}

