<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">
	<xsl:choose>
		<xsl:when test="data/@action = 'Paylinks' and data/@operation = 'pay'">Пополнение счёта — <xsl:value-of select="/data/method/@title"/>.</xsl:when>
		<xsl:when test="data/@action = 'Paylinks' and data/@operation = 'confirm'">Подтверждение оплаты — <xsl:value-of select="/data/method/@title"/>.</xsl:when>
		<xsl:when test="data/@action = 'Paylinks' and data/@operation = 'result'">Операция завершена</xsl:when>
		<xsl:otherwise>Пополнение счёта</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="/data">
	<xsl:choose>
		<xsl:when test="@operation = 'pay'">
			<xsl:call-template name="Pay"/>
		</xsl:when>
		<xsl:when test="@operation = 'confirm'">
			<xsl:call-template name="Confirm"/>
		</xsl:when>
		<xsl:when test="@operation = 'result'">
			<xsl:call-template name="Result"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="MethodList"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>
	
<!-- основная страница с выбором методов оплаты -->
<xsl:template name="MethodList">
	<xsl:for-each select="methods/data/item">
		<ul>
			<li><a href="{$WEBEXECUTER}?module={/data/@module}&amp;mid={/data/@mid}&amp;action={/data/@action}&amp;operation=pay&amp;methodId={@id}"><xsl:value-of select="@title"/></a></li>
		</ul>
	</xsl:for-each>
</xsl:template>

<!-- страница с вводом суммы -->
<xsl:template name="Pay">
	<form action="{$WEBEXECUTER}" method="POST">
		<xsl:call-template name="action"/>
		<input type="hidden" name="operation" value="confirm"/>
		<input type="hidden" name="methodId" value="{/data/method/@id}"/>
			
		<table class="layout">
			<tr>
				<td nowrap="nowrap">Метод оплаты:</td>
				<td><xsl:value-of select="/data/method/@title"/></td>
			</tr>
			<tr>
				<td nowrap="nowrap">Описание:</td>
				<td><xsl:value-of select="/data/method/description/text()"/></td>
			</tr>	
			<tr>
				<td nowrap="nowrap">Введите сумму:</td>
				<td><input type="text" name="sum" size="13"/></td>
			</tr>
			<tr class="foot">
				<td colspan="2">
					<xsl:call-template name="okCancel">
						<xsl:with-param name="title1" select="'Далее'"/>
						<xsl:with-param name="onclick2">window.location.replace( "<xsl:value-of select="$WEBEXECUTER"/>?action=Paylinks&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>");</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</form>	
</xsl:template>

<!-- страница с подтверждением -->
<xsl:template name="Confirm">
	<form action="{$WEBEXECUTER}" method="POST">
		<xsl:call-template name="action"/>
		<input type="hidden" name="operation" value="redirect"/>
		<input type="hidden" name="methodId" value="{/data/method/@id}"/>
		<input type="hidden" name="sum" value="{/data/sum/text()}"/>

		<table class="layout">
			<tr>
				<td nowrap="nowrap">Метод оплаты:</td>
				<td><xsl:value-of select="/data/method/@title"/></td>
			</tr>
			<tr>
				<td nowrap="nowrap">Подтверждение:</td>
				<td><xsl:value-of select="/data/method/confirm/text()"/></td>
			</tr>	
			<tr class="foot">
				<td colspan="2">
					<xsl:call-template name="okCancel">
						<xsl:with-param name="title1" select="'Далее'"/>
						<xsl:with-param name="onclick2">window.location.replace( "<xsl:value-of select="$WEBEXECUTER"/>?action=Paylinks&#38;mid=<xsl:value-of select="/data/@mid"/>&#38;module=<xsl:value-of select="/data/@module"/>");</xsl:with-param>
					</xsl:call-template>
				</td>
			</tr>
		</table>
	</form>
</xsl:template>

<!-- страница, по которой происходит возврат удалённый -->
<xsl:template name="Result">
	<xsl:value-of select="/data/resultmessage/text()"/>
</xsl:template>

</xsl:stylesheet>