/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.ElecsnetAbstractTransactionManager;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ElecsnetMskTransactionManager
extends ElecsnetAbstractTransactionManager {
    protected static final Pattern patternLine = Pattern.compile("^(\\d+)\\t(\\d+)\\t(\\d+)\\t(\\d+)\\t(\\d+)\\t(\\d+)$", 8);

    public ElecsnetMskTransactionManager() {
        super("amount", "date");
    }

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(ElecsnetAbstractTransactionManager.AnswerCode.ACCEPT_PAYMENT.getCode());
        try {
            if (system == null || !system.mode) {
                throw new MPSException(1000, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u043f\u043e \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u043c \u043f\u0440\u0438\u0447\u0438\u043d\u0430\u043c: \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d \u0438\u043b\u0438 null");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            this.checkValid(system, mpsRequest, con);
            mpsResponse.setAction(mpsRequest.getAction());
            switch (mpsRequest.getAction()) {
                case 1: {
                    Contract contract = this.actionCheck(mpsRequest);
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d");
                    mpsResponse.setContract(contract);
                    break;
                }
                case 2: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction != null && !transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setLocalTime(new Date());
                        throw new MPSException(4, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0432 \u0431\u0430\u0437\u0435 \u0435\u0441\u0442\u044c, \u043d\u043e \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                    }
                    if (transaction != null && transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setLocalTime(new Date());
                        throw new MPSException(4, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0432 \u0431\u0430\u0437\u0435 \u0435\u0441\u0442\u044c");
                    }
                    Contract contract = this.actionCheck(mpsRequest);
                    this.checkTime(mpsRequest);
                    transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    break;
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
            this.logError((Throwable)((Object)ex));
        }
        catch (Exception ex) {
            this.processError(new MPSException(-1, ex.getMessage()), mpsResponse);
            this.logError(ex);
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        MPSRequest mpsRequest = super.parseRequest(con, moduleId, mpsId, system, request);
        StringBuilder sb = new StringBuilder();
        try {
            switch (mpsRequest.getAction()) {
                case 1: {
                    sb.append("type=");
                    sb.append(mpsRequest.getAction());
                    sb.append("&reqid=");
                    sb.append(mpsRequest.getNumber());
                    break;
                }
                case 2: {
                    int currency = Integer.valueOf(request.getParameter("currency"));
                    if (currency != 810) {
                        throw new NumberFormatException();
                    }
                    sb.append("type=");
                    sb.append(mpsRequest.getAction());
                    sb.append("&reqid=");
                    sb.append(mpsRequest.getNumber());
                    sb.append("&currency=");
                    sb.append(currency);
                    sb.append("&auth_code=");
                    sb.append(mpsRequest.getTransId());
                    sb.append("&amount=");
                    sb.append(mpsRequest.getSum().multiply(MULTIPLICAND).intValue());
                    sb.append("&date=");
                    sb.append(mpsRequest.getTimeString());
                    break;
                }
            }
        }
        catch (NumberFormatException ex) {
            this.logError(ex);
            throw new MPSException(21, "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u043d\u043d\u044b\u0445");
        }
        if (system.certificateNeed && system.publicKey != null) {
            try {
                Signature sign = Signature.getInstance("MD5withRSA");
                sign.initVerify(system.publicKey);
                sign.update(sb.toString().getBytes("cp1251"));
                byte[] b = Utils.stringToBytes((String)request.getParameter("signature"), null);
                if (!sign.verify(b)) {
                    throw new MPSException(10, "\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0438");
                }
            }
            catch (GeneralSecurityException e) {
                throw new MPSException(10, "\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0438");
            }
            catch (UnsupportedEncodingException e) {
                throw new MPSException(10, "\u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043f\u043e\u0434\u043f\u0438\u0441\u0438");
            }
        }
        return mpsRequest;
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        ArrayList<Transaction> result = new ArrayList<Transaction>();
        Matcher match = patternLine.matcher(file);
        while (match.find()) {
            BigDecimal summ = new BigDecimal(match.group(4));
            result.add((Transaction)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setTransId(match.group(1)).setTime(TimeUtils.parseDate((String)match.group(2), (String)"yyyyMMddhhmmss")).setNumber(match.group(3)).setRawNumber(match.group(3)).setSum(summ.divide(MULTIPLICAND))).setStatus(TransactionStatus.PAYMENT_PAYED.getCode())).build());
        }
        return result;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        PrivateKey privateKey;
        String code = String.valueOf(response.getResult());
        Contract contract = response.getContract();
        StringBuilder sb = new StringBuilder(150);
        sb.append("ans_code=");
        sb.append(code);
        sb.append('&');
        if (response.getAction() == 1 && code.equals("0")) {
            StringBuilder ansidSB = new StringBuilder();
            ParameterMap map = system.responseAttributes;
            boolean date = map.getBoolean("date", false);
            String summ = map.get("summ", null);
            String fio = map.get("fio", null);
            String fioReg = map.get("fio_regexp", null);
            String comment = map.get("comment", null);
            if (date) {
                ansidSB.append(TimeUtils.format((Date)new Date(), (String)"yyyyMMdd"));
                ansidSB.append("[b]");
            }
            if (summ != null) {
                ansidSB.append(summ);
                ansidSB.append("[b]");
            }
            if (fio != null) {
                String fioRes = "";
                if (fio.equals("$comment")) {
                    fioRes = contract.getComment();
                } else if (fio.equals("$title")) {
                    fioRes = contract.getTitle();
                } else {
                    Pattern pattern = Pattern.compile("(\\$pid)=(\\d+)");
                    Matcher m = pattern.matcher(fio);
                    if (m.find()) {
                        int pid = Integer.valueOf(m.group(2));
                        try (ContractDao contractDao = new ContractDao(con, 0);){
                            fioRes = contractDao.getContractParameterTextAsString(contract.getId(), pid).orElse(null);
                        }
                        catch (BGException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                if (fioReg != null) {
                    String[] pair;
                    for (String p : pair = fioReg.split(";;;")) {
                        String[] reg = p.split(":::");
                        fioRes = fioRes.replaceAll(reg[0], reg[1]);
                    }
                }
                ansidSB.append(fioRes);
                ansidSB.append("[b]");
            }
            if (comment != null) {
                ansidSB.append(comment);
                ansidSB.append("[b]");
            }
            String ansid = ansidSB.toString().replaceAll("-", "=").replaceAll(" ", "_").replaceAll("\n", "[b]");
            sb.append("ansid=");
            sb.append(ansid.toString());
            sb.append("&");
        }
        if (response.getMessage() != null) {
            sb.append("message=");
            sb.append(response.getMessage());
        }
        if ((privateKey = system.getPrivateKey()) == null) {
            this.getLogger().error("MPS: Server private key is null!");
        } else {
            try {
                Signature sign = Signature.getInstance("MD5withRSA");
                sign.initSign(privateKey);
                sign.update(sb.toString().getBytes("cp1251"));
                sb.append("&signature=");
                sb.append(Utils.bytesToHexString((byte[])sign.sign()));
            }
            catch (GeneralSecurityException ex) {
                this.logError(ex);
            }
            catch (UnsupportedEncodingException ex) {
                this.logError(ex);
            }
        }
        byte[] res = null;
        try {
            res = sb.toString().getBytes("cp1251");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return res;
    }
}

