/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.email.common.bean.AttributeValue;

public class AttributeValueManager {
    private Connection con;
    private String tableName;

    public AttributeValueManager(Connection con, int mid) {
        this.con = con;
        this.tableName = this.getTableName(mid);
    }

    protected String getTableName(int mid) {
        return "email_attribute_" + mid;
    }

    public List<AttributeValue> getValueList(int accountId) {
        ArrayList<AttributeValue> result = new ArrayList<AttributeValue>();
        try {
            String query = "SELECT * FROM " + this.tableName + " WHERE aid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, accountId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getValueFromRs(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateValues(int accountId, List<AttributeValue> valueList) {
        try {
            String query = null;
            PreparedStatement ps = null;
            query = "DELETE FROM " + this.tableName + " WHERE aid=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, accountId);
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO " + this.tableName + " (aid, attr_id, value) VALUES (?, ?, ?)";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, accountId);
            for (AttributeValue value : valueList) {
                ps.setInt(2, value.getAttributeId());
                ps.setString(3, value.getAttributeValue());
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private AttributeValue getValueFromRs(ResultSet rs) throws Exception {
        AttributeValue result = new AttributeValue();
        result.setAttributeId(rs.getInt("attr_id"));
        result.setAttributeValue(rs.getString("value"));
        return result;
    }
}

