/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class TvAccountDao
extends AbstractIdDao<TvAccount> {
    private final String deviceTable;
    private final String specTable;

    public TvAccountDao(Connection con, int moduleId) {
        super(con, moduleId, "tv_account");
        this.deviceTable = "tv_device_" + moduleId;
        this.specTable = "tv_account_spec_" + moduleId;
    }

    public static TvAccount getFromRS(ResultSet rs, boolean contractLoad, boolean specAndDeviceLoad) throws SQLException {
        TvAccount result = new TvAccount();
        result.setId(rs.getInt("id"));
        result.setParentId(rs.getInt("parentId"));
        result.setContractId(rs.getInt("contractId"));
        if (contractLoad) {
            result.setContractTitle(rs.getString("contract.title"));
            result.setContractComment(rs.getString("contract.comment"));
        }
        result.setSpecId(rs.getInt("specId"));
        result.setDeviceId(rs.getInt("deviceId"));
        result.setIdentifier(rs.getString("identifier"));
        result.setMacAddressListBytes(rs.getBytes("macAddress"));
        result.setLogin(rs.getString("login"));
        result.setPassword(rs.getString("password"));
        result.setPin(rs.getString("pin"));
        result.setDateFrom((Date)rs.getDate("dateFrom"));
        result.setDateTo((Date)rs.getDate("dateTo"));
        result.setStatus(rs.getInt("status"));
        result.setComment(rs.getString("comment"));
        result.setTitle(rs.getString("title"));
        if (specAndDeviceLoad) {
            result.setSpecTitle(rs.getString("specTitle"));
            result.setDeviceTitle(rs.getString("deviceTitle"));
        }
        result.setDeviceAccountId(rs.getString("deviceAccountId"));
        result.setDeviceState(rs.getShort("deviceState"));
        result.setDeviceOptionIds(Utils.toIntegerSet((String)rs.getString("deviceOptions")));
        result.setAccessCode(rs.getInt("accessCode"));
        result.setConfig(rs.getString("config"));
        return result;
    }

    public TvAccount getFromRS(ResultSet rs) throws SQLException {
        return TvAccountDao.getFromRS(rs, false, false);
    }

    protected void updateImpl(TvAccount tvAccount) throws SQLException {
        Objects.requireNonNull(tvAccount);
        boolean update = tvAccount.getId() > 0;
        String sql = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET parentId=?, contractId=?, specId=?, deviceId=?, login=?, password=?, pin=?, identifier=?, macAddress=?, dateFrom=?, dateTo=?, comment=?, status=?, title=?, config=?" + (update ? " WHERE id=?" : ", deviceState=?, deviceAccountId=?");
        try (PreparedStatement ps = this.con.prepareStatement(sql, 1);){
            int index = 1;
            ps.setInt(index++, tvAccount.getParentId());
            ps.setInt(index++, tvAccount.getContractId());
            ps.setInt(index++, tvAccount.getSpecId());
            ps.setInt(index++, tvAccount.getDeviceId());
            ps.setString(index++, tvAccount.getLogin());
            ps.setString(index++, tvAccount.getPassword());
            ps.setString(index++, tvAccount.getPin());
            ps.setString(index++, tvAccount.getIdentifier());
            ps.setBytes(index++, tvAccount.getMacAddressListBytes());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)tvAccount.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)tvAccount.getDateTo()));
            ps.setString(index++, Utils.maskNull((String)tvAccount.getComment()));
            ps.setInt(index++, tvAccount.getStatus());
            ps.setString(index++, tvAccount.getTitle());
            ps.setString(index++, Utils.isBlankString((String)tvAccount.getConfig()) ? null : tvAccount.getConfig());
            if (!update) {
                ps.setInt(index++, -1);
                ps.setString(index++, Utils.maskBlank((String)tvAccount.getDeviceAccountId(), null));
            }
            this.executeUpdate((Id)tvAccount, index, ps);
        }
    }

    public List<TvAccount> list(int contractId) throws SQLException {
        return this.list(contractId, true);
    }

    public List<TvAccount> list(int contractId, boolean specAndDeviceLoad) throws SQLException {
        ArrayList<TvAccount> result = new ArrayList<TvAccount>(50);
        StringBuilder sb = new StringBuilder(100).append("SELECT account.*");
        if (specAndDeviceLoad) {
            sb.append(", spec.title AS specTitle, device.title AS deviceTitle");
        }
        sb.append(" FROM ").append(this.tableName).append(" AS account ");
        if (specAndDeviceLoad) {
            sb.append(" LEFT JOIN " + this.specTable + " AS spec ON account.specId=spec.id ");
            sb.append(" LEFT JOIN " + this.deviceTable + " AS device ON account.deviceId=device.id ");
        }
        sb.append(" WHERE account.contractId=?");
        try (PreparedStatement ps = this.con.prepareStatement(sb.toString());){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(TvAccountDao.getFromRS(rs, false, specAndDeviceLoad));
                }
            }
        }
        return result;
    }

    public List<TvAccount> listRuntime(int deviceId, Set<Integer> tvAccountSpecIds) throws SQLException {
        ArrayList<TvAccount> result = new ArrayList<TvAccount>(50);
        String query = "SELECT account.* FROM tv_account_" + this.moduleId + " AS account LEFT JOIN " + this.specTable + " AS spec ON spec.id=account.specId LEFT JOIN contract ON account.contractId=contract.id WHERE account.deviceId=? ORDER BY parentId ASC";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, deviceId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    TvAccount tvAccount = TvAccountDao.getFromRS(rs, false, false);
                    tvAccount.setComment(null);
                    result.add(tvAccount);
                }
            }
        }
        return result;
    }

    public TvAccount get(String login, Date time) throws SQLException {
        java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)time);
        return (TvAccount)this.get("login=? AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR dateTo>=?)", new Object[]{login, sqlDate, sqlDate});
    }

    public TvAccount getByIdentifier(String identifier, LocalDate date) throws SQLException {
        java.sql.Date sqlDate = TimeUtils.convertLocalDateToSqlDate((LocalDate)date);
        return (TvAccount)this.get("identifier=? AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR dateTo>=?)", new Object[]{identifier, sqlDate, sqlDate});
    }

    public TvAccount getByDeviceAccountId(String deviceAccountId, Date time) throws SQLException {
        java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)time);
        return (TvAccount)this.get("deviceAccountId=? AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR dateTo>=?)", new Object[]{deviceAccountId, sqlDate, sqlDate});
    }

    public Optional<TvAccount> optByDeviceAccountId(String deviceAccountId, Date time) throws SQLException {
        return Optional.ofNullable(this.getByDeviceAccountId(deviceAccountId, time));
    }

    public List<TvAccount> listChildren(int parentId) throws SQLException {
        return super.list("parentId=?", "id", new Object[]{parentId});
    }

    public List<TvAccount> list(int deviceId, String login, Date dateFrom, Date dateTo) throws SQLException {
        java.sql.Date sqlDateFrom = TimeUtils.convertDateToSqlDate((Date)dateFrom);
        java.sql.Date sqlDateTo = TimeUtils.convertDateToSqlDate((Date)dateTo);
        return super.list("(? OR deviceId=?) AND (? OR login=?) AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?)", "id", new Object[]{deviceId <= 0, deviceId, login == null, login, sqlDateFrom, sqlDateFrom, sqlDateTo, sqlDateTo});
    }

    public List<TvAccount> list(int deviceId, String login, Date dateFrom, Date dateTo, boolean onlyRoot, String orderBy) throws SQLException {
        java.sql.Date sqlDateFrom = TimeUtils.convertDateToSqlDate((Date)dateFrom);
        java.sql.Date sqlDateTo = TimeUtils.convertDateToSqlDate((Date)dateTo);
        return super.list("(? OR deviceId=?) AND (? OR login=?) AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?) AND(? OR parentId<=0) ", orderBy, new Object[]{deviceId <= 0, deviceId, login == null, login, sqlDateFrom, sqlDateFrom, sqlDateTo, sqlDateTo, !onlyRoot});
    }

    public void updateDeviceStateAndOptions(int tvAccountId, String deviceAccountId, short state, Set<Integer> deviceOptions, int accessCode) throws SQLException {
        if (state != -1000) {
            if (deviceOptions != null) {
                String query = "UPDATE " + this.tableName + " SET deviceState=?, deviceOptions=?, deviceAccountId=?, accessCode=? WHERE id=?";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    ArrayList<Integer> options = new ArrayList<Integer>(deviceOptions);
                    Collections.sort(options);
                    ps.setShort(1, state);
                    ps.setString(2, Utils.toString(options));
                    ps.setString(3, deviceAccountId);
                    ps.setInt(4, accessCode);
                    ps.setInt(5, tvAccountId);
                    ps.executeUpdate();
                }
            } else {
                String query = "UPDATE " + this.tableName + " SET deviceState=?, deviceAccountId=?, accessCode=? WHERE id=?";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    ps.setShort(1, state);
                    ps.setString(2, deviceAccountId);
                    ps.setInt(3, accessCode);
                    ps.setInt(4, tvAccountId);
                    ps.executeUpdate();
                }
            }
        } else {
            String query = "UPDATE " + this.tableName + " SET deviceOptions=?, deviceAccountId=? WHERE id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ArrayList<Integer> options = new ArrayList<Integer>(deviceOptions);
                Collections.sort(options);
                ps.setString(1, Utils.toString(options));
                ps.setString(2, deviceAccountId);
                ps.setInt(3, tvAccountId);
                ps.executeUpdate();
            }
        }
    }

    public List<TvAccount> listToCreate(Date now) throws SQLException {
        return super.list("deviceState=? AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR dateTo>=?) AND parentId<=0", null, new Object[]{(short)-1, TimeUtils.convertDateToSqlDate((Date)now), TimeUtils.convertDateToSqlDate((Date)now)});
    }

    public List<TvAccount> listToCancel(Date now) throws SQLException {
        return super.list("deviceState!=? AND (dateTo IS NOT NULL AND dateTo<?) AND parentId<=0", null, new Object[]{(short)-1, TimeUtils.convertDateToSqlDate((Date)now)});
    }

    public int lastNumericLogin(int max) throws SQLException {
        int login = 0;
        String query = "SELECT MAX( CAST( login AS UNSIGNED ) ) FROM " + this.tableName + " WHERE (? OR CAST( login AS UNSIGNED )<=?)";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setBoolean(1, max <= 0);
            ps.setInt(2, max);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    login = rs.getInt(1);
                }
            }
        }
        return login;
    }

    public List<TvAccount> search(List<KeyValue> filter, int tvAccountSpecId, boolean loginStrictCheck) throws SQLException {
        ArrayList<TvAccount> result = new ArrayList<TvAccount>();
        String query = "SELECT serv.*, serv.title as title, serv_type.title AS specTitle, device.title AS deviceTitle,  contract.sub_mode, contract.scid, contract.title, contract.comment FROM " + this.tableName + " AS serv LEFT JOIN " + this.specTable + " AS serv_type ON serv.specId=serv_type.id LEFT JOIN " + this.deviceTable + " AS device ON serv.deviceId=device.id LEFT JOIN contract ON serv.contractId=contract.id WHERE 1=1 ";
        for (KeyValue filterCond : filter) {
            if ("login".equals(filterCond.getKey()) && Utils.notBlankString((String)filterCond.getValue())) {
                query = query + (loginStrictCheck ? " AND serv.login = ? " : "AND serv.login LIKE ? ");
            }
            if ("extId".equals(filterCond.getKey()) && Utils.notBlankString((String)filterCond.getValue())) {
                query = query + (loginStrictCheck ? " AND serv.deviceAccountId = ? " : "AND serv.deviceAccountId LIKE ? ");
            }
            if ("identifier".equals(filterCond.getKey()) && Utils.notBlankString((String)filterCond.getValue())) {
                query = query + "AND serv.identifier LIKE ? ";
            }
            if (!"macAddress".equals(filterCond.getKey()) || !Utils.notBlankString((String)filterCond.getValue())) continue;
            query = query + "AND serv.macAddress = ? ";
        }
        if (tvAccountSpecId > 0) {
            query = query + "AND serv.specId=? ";
        }
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            for (KeyValue filterCond : filter) {
                if ("login".equals(filterCond.getKey()) && Utils.notBlankString((String)filterCond.getValue())) {
                    ps.setString(index++, (String)(loginStrictCheck ? filterCond.getValue().trim() : "%" + filterCond.getValue().trim() + "%"));
                }
                if ("extId".equals(filterCond.getKey()) && Utils.notBlankString((String)filterCond.getValue())) {
                    ps.setString(index++, (String)(loginStrictCheck ? filterCond.getValue().trim() : "%" + filterCond.getValue().trim() + "%"));
                }
                if ("identifier".equals(filterCond.getKey()) && Utils.notBlankString((String)filterCond.getValue())) {
                    ps.setString(index++, "%" + filterCond.getValue().trim() + "%");
                }
                if (!"macAddress".equals(filterCond.getKey()) || !Utils.notBlankString((String)filterCond.getValue())) continue;
                ps.setBytes(index++, TvAccount.parseMacAddress((String)filterCond.getValue()));
            }
            if (tvAccountSpecId != 0) {
                ps.setInt(index++, tvAccountSpecId);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(TvAccountDao.getFromRS(rs, true, true));
                }
            }
        }
        return result;
    }
}

