/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

final class EPortTransactionManager2
extends MPSTransactionManager {
    private static final String TIMEPATTERN = "dd.MM.yy HH:mm:ss";
    private final PrivateKey privateKey;
    private static Pattern patternPlus = Pattern.compile("\\+");
    protected static final Pattern TRANSACTION_PATTERN = Pattern.compile("^(.+)\\t(\\d+)\\t([\\d+: -T]+)\\t(\\d+\\.*\\d*)\\t(\\d+)$", 8);

    public EPortTransactionManager2(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public EPortTransactionManager2() {
        this.privateKey = null;
    }

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            this.checkValid(system, mpsRequest, con);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.setTransId(mpsRequest.getTransId());
            switch (mpsRequest.getAction()) {
                case 1: {
                    Contract contract = this.actionCheck(mpsRequest);
                    mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                    mpsResponse.setLocalTime(new Date());
                    break;
                }
                case 2: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction != null && !transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setResult(4);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0435\u0441\u0442\u044c \u0432 \u0431\u0430\u0437\u0435, \u043d\u043e \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                        mpsResponse.setLocalTime(new Date());
                        break;
                    }
                    if (transaction == null) {
                        Contract contract = this.actionCheck(mpsRequest);
                        this.checkTime(mpsRequest);
                        transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    } else {
                        Contract contract = new ContractManager(con).getContractById(transaction.getContractId());
                        if (contract != null) {
                            mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                        }
                    }
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                    break;
                }
                case 4: {
                    GregorianCalendar now = new GregorianCalendar();
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), now.getTime());
                    if (transaction == null) {
                        mpsResponse.setResult(9);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                        mpsResponse.setLocalTime(new Date());
                        break;
                    }
                    ((Calendar)now).add(12, -10);
                    if (transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode()) && now.after(transaction.getLocalTime())) {
                        mpsResponse.setResult(9);
                        mpsResponse.setMessage("\u0418\u0437\u0432\u0438\u043d\u0438\u0442\u0435. \u0412\u0440\u0435\u043c\u044f \u0434\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432\u044b\u0448\u043b\u043e");
                        mpsResponse.setLocalTime(new Date());
                        break;
                    }
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                    this.cancelTransaction(con, moduleId, mpsId, system, transaction);
                    mpsResponse.setResult(8);
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        String hash;
        String revokedate;
        String code = String.valueOf(response.getResult());
        String date = TimeUtils.format((Date)response.getLocalTime(), (String)TIMEPATTERN);
        StringBuilder sb = new StringBuilder(150);
        sb.append("code=");
        sb.append(code);
        sb.append('&');
        sb.append("date=");
        sb.append(date);
        sb.append('&');
        sb.append("message=");
        if (response.getMessage() != null) {
            sb.append(response.getMessage());
        }
        sb.append('&');
        if (response.getAction() == 4) {
            revokedate = TimeUtils.format((Calendar)new GregorianCalendar(), (String)TIMEPATTERN);
            sb.append("revokedate=");
            sb.append(revokedate);
            sb.append('&');
        } else {
            revokedate = null;
        }
        try {
            Signature sign = Signature.getInstance("MD5withRSA");
            sign.initSign(this.privateKey);
            sign.update(sb.toString().getBytes("cp1251"));
            hash = Utils.bytesToString((byte[])sign.sign());
        }
        catch (GeneralSecurityException e) {
            hash = "";
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            hash = "";
            e.printStackTrace();
        }
        try {
            sb = new StringBuilder(150);
            sb.append("code=");
            sb.append(code);
            sb.append('&');
            sb.append("date=");
            sb.append(patternPlus.matcher(URLEncoder.encode(date, "UTF-8")).replaceAll("%20"));
            sb.append('&');
            sb.append("message=");
            if (response.getMessage() != null) {
                sb.append(patternPlus.matcher(URLEncoder.encode(response.getMessage(), "UTF-8")).replaceAll("%20"));
            }
            sb.append('&');
            if (response.getAction() == 4) {
                sb.append("revokedate=");
                sb.append(patternPlus.matcher(URLEncoder.encode(revokedate, "UTF-8")).replaceAll("%20"));
                sb.append('&');
            }
            sb.append("hash=");
            sb.append(hash);
            sb.append('&');
            return sb.toString().getBytes();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] arsgs) {
        System.out.println(System.getProperty("java.version"));
        System.out.println(System.getProperty("java.vendor"));
        System.out.println(System.getProperty("java.specification.name"));
        System.out.println(System.getProperty("os.name"));
        try {
            System.out.println(URLDecoder.decode("account=1234%20567&date=21.10.03%2016%3A07%3A14&hash=5237893&id=30275&sum=234.56&type=1&sign=2BA555F3746588078D99419B2FB52E0303BB87F1EF9D8943CE02D8A2B8D8EFF3AA9899C80D537625E9000A2123AAEFCE8D68ADFC836823C7847203C635521E02D4F4C681CE65AD4AF3C14FE7D55EB2CCEB4DD2B17C15F922ECFE850E23A85FCE81EFABC845B3E7B2EAB98DA2DF03125F6097FCD9E3B8350726D453750303499F", "UTF-8"));
            System.out.println(URLEncoder.encode("account=1234 567&date=21.10.03 16:07:14&hash=5237893&id=30275&sum=234.56&type=1&sign=2BA555F3746588078D99419B2FB52E0303BB87F1EF9D8943CE02D8A2B8D8EFF3AA9899C80D537625E9000A2123AAEFCE8D68ADFC836823C7847203C635521E02D4F4C681CE65AD4AF3C14FE7D55EB2CCEB4DD2B17C15F922ECFE850E23A85FCE81EFABC845B3E7B2EAB98DA2DF03125F6097FCD9E3B8350726D453750303499F", "cp1251").replaceAll("\\+", "%20"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        char type;
        MPSRequest req = new MPSRequest(con, moduleId, mpsId, request, system);
        String actionString = request.getParameter("type");
        if ("1".equals(actionString)) {
            req.setAction(2);
        } else if ("2".equals(actionString)) {
            req.setAction(1);
        } else if ("3".equals(actionString)) {
            req.setAction(4);
        } else if ("4".equals(actionString)) {
            req.setAction(5);
        }
        req.setRawNumber(request.getParameter("account"));
        if (system.osmpPrefix && req.getRawNumber() != null && req.getRawNumber().length() > 1 && req.getRawNumber().charAt(1) == '_' && Character.isDigit((int)(type = req.getRawNumber().charAt(0)))) {
            req.setType(Character.getNumericValue((int)type));
            req.setNumber(req.getRawNumber().substring(2));
        } else {
            req.setNumber(req.getRawNumber());
            req.setType(0);
        }
        String summString = request.getParameter("sum");
        req.setSum(Utils.parseBigDecimal((String)summString, (BigDecimal)BigDecimal.ZERO));
        req.setTransId(request.getParameter("id"));
        String timeString = request.getParameter("date");
        req.setTime(TimeUtils.parseDate((String)timeString, (String)TIMEPATTERN));
        String reqHash = request.getParameter("sign");
        StringBuilder sb = new StringBuilder(100);
        switch (req.getAction()) {
            case 1: {
                sb.append("account=");
                sb.append(req.getRawNumber());
                sb.append('&');
                sb.append("date=");
                sb.append(timeString);
                sb.append('&');
                sb.append("sum=");
                sb.append(summString);
                sb.append('&');
                sb.append("type=");
                sb.append(actionString);
                sb.append('&');
                break;
            }
            case 2: {
                sb.append("account=");
                sb.append(req.getRawNumber());
                sb.append('&');
                sb.append("date=");
                sb.append(timeString);
                sb.append('&');
                sb.append("hash=");
                sb.append(request.getParameter("hash"));
                sb.append('&');
                sb.append("id=");
                sb.append(request.getParameter("id"));
                sb.append('&');
                sb.append("sum=");
                sb.append(summString);
                sb.append('&');
                String testMode = request.getParameter("testMode");
                req.setTestMode("1".equals(testMode));
                sb.append("testMode=");
                sb.append(testMode);
                sb.append('&');
                sb.append("type=");
                sb.append(actionString);
                sb.append('&');
                break;
            }
            case 4: {
                sb.append("account=");
                sb.append(req.getRawNumber());
                sb.append('&');
                sb.append("date=");
                sb.append(timeString);
                sb.append('&');
                sb.append("id=");
                sb.append(request.getParameter("id"));
                sb.append('&');
                sb.append("sum=");
                sb.append(summString);
                sb.append('&');
                sb.append("type=");
                sb.append(actionString);
                sb.append('&');
                break;
            }
            case 5: {
                sb.append("date=");
                sb.append(timeString);
                sb.append('&');
                sb.append("id=");
                sb.append(request.getParameter("id"));
                sb.append('&');
                sb.append("newAccount=");
                sb.append(request.getParameter("newAccount"));
                sb.append('&');
                sb.append("oldAccount=");
                sb.append(request.getParameter("oldAccount"));
                sb.append('&');
                sb.append("sum=");
                sb.append(summString);
                sb.append('&');
                sb.append("type=");
                sb.append(actionString);
                sb.append('&');
            }
        }
        try {
            Signature sign = Signature.getInstance("MD5withRSA");
            sign.initVerify(system.publicKey);
            sign.update(sb.toString().getBytes("cp1251"));
            if (!sign.verify(reqHash.getBytes())) {
                throw new MPSException(10);
            }
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new MPSException(-1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new MPSException(-1);
        }
        return req;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(1);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(2);
                response.setMessage(ex.message);
                break;
            }
            case 6: {
                response.setResult(1);
                response.setMessage(ex.message);
                break;
            }
            case 8: {
                response.setResult(6);
                response.setMessage("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
                break;
            }
            case -1: {
                response.setResult(7);
                response.setMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                break;
            }
            case 9: {
                response.setResult(7);
                response.setMessage(ex.message);
                break;
            }
            case 10: {
                response.setResult(3);
                response.setMessage(ex.message);
                break;
            }
            case 11: {
                response.setResult(9);
                response.setMessage(ex.message);
            }
        }
    }

    @Override
    protected void checkValid(Conf.MPSSystem system, MPSRequest req, Connection con) throws MPSException {
        switch (req.getAction()) {
            case 1: {
                if (req.getNumber() != null && req.getNumber().length() > 0 && req.getSum() != null && (system.extDontCheckSum || req.getSum().compareTo(BigDecimal.ZERO) > 0) && req.getTime() != null) break;
                throw new MPSException(2);
            }
            case 2: {
                if (req.getNumber() != null && req.getNumber().length() > 0 && req.getSum() != null && (system.extDontCheckSum || req.getSum().compareTo(BigDecimal.ZERO) > 0) && req.getTransId() != null && this.parseBigInteger(req.getTransId()).compareTo(BigInteger.ZERO) > 0 && req.getTime() != null && (!req.isTestMode() || system.testMode)) break;
                throw new MPSException(2);
            }
            case 4: {
                if (req.getNumber() == null || req.getNumber().length() <= 0 || req.getSum() == null || !system.extDontCheckSum && req.getSum().compareTo(BigDecimal.ZERO) <= 0 || req.getTransId() == null || this.parseBigInteger(req.getTransId()).compareTo(BigInteger.ZERO) <= 0 || req.getTime() == null) {
                    throw new MPSException(2);
                }
            }
            default: {
                throw new MPSException(2, "\u041a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430");
            }
        }
        super.checkValid(system, req, con);
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    public String getDefaultEncoding() {
        return "windows-1251";
    }

    private class ErrorCode {
        private static final int ANSWER_SUCCESS = 0;
        private static final int ANSWER_ERR_REQUEST = 1;
        private static final int ANSWER_ERR_CONTRACT_NOT_FOUND = 2;
        private static final int ANSWER_ERR_HASH = 3;
        protected static final int ANSWER_ERR_REPEAT = 4;
        protected static final int ANSWER_ERR_REPEAT_NO_HASH = 5;
        private static final int ANSWER_ERR_SUMM = 6;
        private static final int ANSWER_ERR_OFF = 7;
        protected static final int ANSWER_PAYMENT_CANCEL_SUCCESS = 8;
        private static final int ANSWER_PAYMENT_CANCEL_ERROR = 9;

        private ErrorCode(EPortTransactionManager2 ePortTransactionManager2) {
        }
    }
}

