/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.Date;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.SynclogEntry;
import ru.bitel.bgbilling.modules.cerbercrypt.common.service.SynclogService;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.SynclogManager;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.cerbercrypt.common.service.SynclogService")
public class SynclogServiceImpl
extends AbstractService
implements SynclogService {
    private SynclogManager synclogManager;

    @PostConstruct
    private void init() {
        this.synclogManager = new SynclogManager(this.getConnection(), this.moduleId);
    }

    public Result<SynclogEntry> getSynclog(Period period, Page page, int cid, Set<Long> filterNumbers, Set<Integer> filterSuccess, boolean truncateText) throws Exception {
        Result<SynclogEntry> result = this.synclogManager.getList(period, page, cid, filterNumbers, filterSuccess);
        if (truncateText) {
            SynclogServiceImpl.truncateLogText(result.getList(), 128);
        }
        return result;
    }

    private static void truncateLogText(List<SynclogEntry> entrylist, int maxlen) {
        for (SynclogEntry entry : entrylist) {
            Object comm = entry.getComment();
            if (comm == null) continue;
            if (((String)comm).length() > maxlen) {
                comm = ((String)comm).substring(0, maxlen) + "\u2026";
            }
            comm = ((String)comm).replace('\n', ' ');
            entry.setComment((String)comm);
        }
    }

    public SynclogEntry getSynclogEntry(int id, Date date) throws Exception {
        return this.synclogManager.getEntry(id, date);
    }
}

