/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceTrafficRangeRecalculateManager;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.common.TimeUtils;

public class RangeDayFlushingManager
implements AutoCloseable,
Callable<Object> {
    private final Date day;
    private final int index;
    private final VoiceTariffContext tariffContext;
    private final int count;
    private final int moduleId;
    private final Map<Integer, Set<Integer>> affectedDaysForContracts;
    private static Logger logger = LogManager.getLogger();

    public RangeDayFlushingManager(Date day, int moduleId, int index, int count, VoiceTariffContext tariffContext, Map<Integer, Set<Integer>> affectedDaysForContracts) {
        this.day = day;
        this.index = index;
        this.tariffContext = tariffContext;
        this.count = count;
        this.moduleId = moduleId;
        this.affectedDaysForContracts = affectedDaysForContracts;
    }

    @Override
    public void close() throws Exception {
    }

    public void flushDay(Connection con, int moduleId) throws SQLException {
        Date nextDay = TimeUtils.getNextDay((Date)this.day);
        try (VoiceTrafficRangeRecalculateManager rangeManager = new VoiceTrafficRangeRecalculateManager(con, this.day, nextDay, moduleId, this.tariffContext.rangedTrafficManager);){
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.day);
            int dayInt = cal.get(5);
            Map rangedTrafficMap = this.tariffContext.rangedTrafficManager.rangedTrafficMap();
            for (Map.Entry entry : rangedTrafficMap.entrySet()) {
                int contractId = (Integer)entry.getKey();
                if (contractId % this.count != this.index) continue;
                rangeManager.flushDay(contractId, dayInt);
                Set<Integer> affectedDays = this.affectedDaysForContracts.get(contractId);
                if (affectedDays == null) {
                    affectedDays = new HashSet<Integer>();
                    this.affectedDaysForContracts.put(contractId, affectedDays);
                }
                affectedDays.add(dayInt);
            }
        }
    }

    @Override
    public Object call() {
        try {
            ServerContext context = (ServerContext)ServerContext.get();
            this.flushDay(context.getConnection(), this.moduleId);
        }
        catch (SQLException e) {
            logger.error("error while range flushing ", (Throwable)e);
        }
        return null;
    }
}

