/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGConfigEditorPane;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.common.service.EmailService;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.table.BGTableModel;

public class DomainServiceConfig
extends ServiceConfigTabbedPanel {
    private DomainTableModel domainTableModel = new DomainTableModel();
    private EmailService emailService = null;

    public DomainServiceConfig() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() {
        BGUTable table = new BGUTable((TableModel)((Object)this.domainTableModel));
        table.setSelectionMode(0);
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.editItem());
    }

    public void setData() throws Exception {
        Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("Domain").setAttribute("orderBy", "id");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            ArrayList elements = new ArrayList();
            XMLUtils.selectElements((Node)doc, (String)"/data/*[namespace-uri()='http://common.bitel.ru' and local-name()='result']/data/item").forEach(a -> elements.add(a));
            this.domainTableModel.setData(elements);
        }
    }

    public void newItem() {
        new Editor("\u041d\u043e\u0432\u044b\u0439 \u0434\u043e\u043c\u0435\u043d", new Domain()).open();
    }

    public void editItem() {
        Element rowElement = (Element)this.domainTableModel.getSelectedRow();
        if (rowElement == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0434\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u043c\u0435\u043d \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            return;
        }
        try {
            new Editor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0434\u043e\u043c\u0435\u043d\u0430", this.getEmailService().domainGet(Utils.parseInt((String)rowElement.getAttribute("id")))).open();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void deleteItem() {
        Element rowElement;
        if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u043e\u043c\u0435\u043d?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0 && (rowElement = (Element)this.domainTableModel.getSelectedRow()) != null) {
            try {
                this.getEmailService().domainDelete(Utils.parseInt((String)rowElement.getAttribute("id")));
                this.setData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private EmailService getEmailService() {
        if (this.emailService == null) {
            this.emailService = (EmailService)this.getContext().getPort(EmailService.class);
        }
        return this.emailService;
    }

    class DomainTableModel
    extends BGTableModel<Element> {
        public DomainTableModel() {
            super(DomainTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u043e\u0437\u0438\u0446\u0438\u044f", Integer.class, 100, 100, 100, "pos", true, false, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0414\u043e\u043c\u0435\u043d", 300, 400, 500, "name", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 300, -1, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(Element val, int column) throws Exception {
            String i;
            switch (i = this.getIdentifier(column)) {
                case "id": 
                case "pos": {
                    return Utils.parseInt((String)val.getAttribute(i));
                }
                case "comment": {
                    return ((Element)val.getFirstChild()).getTextContent();
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    private class Editor
    extends BGEditorDialog<Domain> {
        private JTabbedPane tabbedPane;
        private BGTextField name;
        private BGTextField posField;
        private BGTextArea comment;
        private BGConfigEditorPane params;

        public Editor(String title, Domain data) {
            super(title, (Object)data);
            this.tabbedPane = new JTabbedPane();
            this.name = new BGTextField(50);
            this.posField = new BGTextField(8);
            this.comment = new BGTextArea();
            this.params = new BGConfigEditorPane();
        }

        public void doDialogPanel() {
            this.tabbedPane.add("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", this.getBasePanel());
            this.tabbedPane.add("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f", this.getParamsPanel());
            this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.name.setText(((Domain)this.data).getName());
            this.posField.setText(String.valueOf(((Domain)this.data).getPos()));
            this.comment.setText(((Domain)this.data).getComment());
            this.params.setText(((Domain)this.data).getParams());
        }

        public boolean doApply() throws Exception {
            int pos = Utils.parseInt((String)this.posField.getText(), (int)-1);
            if (pos == -1) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0447\u0438\u0441\u043b\u043e\u043c!");
                return false;
            }
            ((Domain)this.data).setPos(pos);
            ((Domain)this.data).setName(this.name.getText());
            ((Domain)this.data).setComment(this.comment.getText());
            ((Domain)this.data).setParams(this.params.getText());
            DomainServiceConfig.this.getEmailService().domainUpdate((Domain)this.data);
            DomainServiceConfig.this.setData();
            return true;
        }

        private JPanel getBasePanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getDomainPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.getPosPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.getCommentPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getDomainPanel() {
            JPanel panel = new JPanel(new GridLayout());
            panel.add((Component)this.name);
            panel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder(" \u0414\u043e\u043c\u0435\u043d "), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            return panel;
        }

        private JPanel getPosPanel() {
            this.posField.setHorizontalAlignment(0);
            JPanel panel = new JPanel(new GridLayout());
            panel.add((Component)this.posField);
            panel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder(" \u041f\u043e\u0437\u0438\u0446\u0438\u044f "), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            return panel;
        }

        private JPanel getCommentPanel() {
            JScrollPane pane = new JScrollPane((Component)this.comment);
            JPanel panel = new JPanel(new GridLayout());
            panel.add(pane);
            panel.setBorder(BorderFactory.createCompoundBorder((Border)new BGTitleBorder(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 "), BorderFactory.createEmptyBorder(0, 3, 3, 3)));
            panel.setMinimumSize(new Dimension(100, 100));
            panel.setPreferredSize(new Dimension(100, 100));
            return panel;
        }

        private JPanel getParamsPanel() {
            JPanel panel = new JPanel(new GridLayout());
            panel.add(new JScrollPane((Component)this.params));
            panel.setMinimumSize(new Dimension(100, 100));
            panel.setPreferredSize(new Dimension(100, 100));
            return panel;
        }
    }
}

