/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.organizer.server.action;

import bitel.billing.server.ActionBase;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.organizer.server.bean.OrganizerManager;
import ru.bitel.bgbilling.plugins.organizer.server.bean.OrganizerRecord;
import ru.bitel.bgbilling.plugins.organizer.server.bean.RecordFilter;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;

public class ActionGetRecordsList
extends ActionBase {
    public void doAction() throws Exception {
        Period todoPeriod = this.getPeriod();
        if (todoPeriod.getDateFrom() == null || todoPeriod.getDateTo() == null) {
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434.");
        }
        RecordFilter filter = new RecordFilter();
        filter.setRid(this.getIntParameter("rid", 0));
        filter.setContains(this.getParameter("contains", ""));
        filter.setTodoPeriod(todoPeriod);
        filter.setTodoUid(this.getIntParameter("todouser", 0));
        filter.setTodoGid(this.getIntParameter("todogroup", 0));
        filter.setOnlydone(this.getBooleanParameter("onlydone", false));
        if (filter.isOnlydone()) {
            filter.setCompletedUid(this.getIntParameter("completeduser", 0));
            Period donePeriod = new Period();
            donePeriod.setDateFrom(this.getDateParameter("completedate1", null));
            donePeriod.setDateTo(this.getDateParameter("completedate2", null));
            if (donePeriod.getDateFrom() == null && donePeriod.getDateTo() == null) {
                filter.setDonePeriod(null);
            } else if (donePeriod.getDateFrom() != null && donePeriod.getDateTo() != null) {
                filter.setDonePeriod(donePeriod);
            } else {
                throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0435\u0440\u0438\u043e\u0434 \u0434\u0430\u0442\u044b \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f.");
            }
        }
        filter.setPage(this.getPage());
        OrganizerManager manager = new OrganizerManager(this.con);
        List<OrganizerRecord> records = manager.getRecords(filter);
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        for (OrganizerRecord rec : records) {
            Element row = this.createElement(data, "row");
            row.setAttribute("id", String.valueOf(rec.getId()));
            row.setAttribute("title", rec.getTitle());
            row.setAttribute("comment", rec.getComment());
            row.setAttribute("uid", String.valueOf(rec.getUid()));
            row.setAttribute("user_name", rec.getUserName());
            String whoCompletes = "";
            if (rec.getTodoUid() <= 0) {
                whoCompletes = rec.getTodoGroup();
                row.setAttribute("todo_gid", String.valueOf(rec.getTodoGid()));
            } else {
                whoCompletes = rec.getTodoUserName();
                row.setAttribute("todo_uid", String.valueOf(rec.getTodoUid()));
            }
            row.setAttribute("who_complets", whoCompletes);
            row.setAttribute("cid", String.valueOf(rec.getCid()));
            row.setAttribute("contract", rec.getContractTitle());
            row.setAttribute("created", TimeUtils.formatDate((Date)rec.getCreationDate()));
            row.setAttribute("period", TimeUtils.formatDate((Date)rec.getPeriod().getDateFrom()) + " -- " + TimeUtils.formatDate((Date)rec.getPeriod().getDateTo()));
            row.setAttribute("is_done", rec.isDone() ? "1" : "0");
            row.setAttribute("uid_complete", String.valueOf(rec.getCompleteUid()));
            row.setAttribute("who_complete", rec.getWhoCompleted());
            row.setAttribute("when_complete", rec.getCompleteDate() == null ? "" : TimeUtils.formatDate((Date)rec.getCompleteDate()));
        }
        filter.getPage().setRecordCount(manager.countTotalRecords(filter));
        this.setPageAttribute(table, filter.getPage());
    }
}

