/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.terminal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;

public class TerminalManager {
    private InputStream input = null;
    private String endString = null;
    private String regexp = null;
    Pattern pattern = null;
    private int timeout = 0;
    private long readWait = 100L;
    private OutputStreamWriter writer;

    public TerminalManager(InputStream input, OutputStream out) {
        this.input = input;
        this.writer = new OutputStreamWriter(out);
    }

    public void setReadWait(long readWait) {
        this.readWait = readWait;
    }

    public String doCommand(String command) throws Exception {
        this.doCommandAsync(command);
        return this.readFromInput();
    }

    public String readFromInput() throws IOException, TimeoutException {
        StringBuilder buffer = new StringBuilder(100);
        long start = System.currentTimeMillis();
        while (true) {
            int b;
            if (this.input.available() > 0 && (b = this.input.read()) != -1) {
                buffer.append((char)b);
                start = System.currentTimeMillis();
                continue;
            }
            if (this.pattern.matcher(buffer).find()) break;
            if (this.timeout > 0 && System.currentTimeMillis() - start > (long)this.timeout) {
                throw new TimeoutException();
            }
            try {
                Thread.sleep(this.readWait);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return buffer.toString();
    }

    public void doCommandAsync(String command) throws Exception {
        this.writer.write(command);
        this.writer.flush();
    }

    public String getEndString() {
        return this.endString;
    }

    public void setEndString(String endString) {
        this.endString = endString;
        if (endString != null) {
            this.setRegexp(Pattern.quote(endString));
        }
    }

    public String getRegexp() {
        return this.regexp;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
        if (regexp != null) {
            this.pattern = Pattern.compile(regexp, 32);
        }
    }

    @Deprecated
    public void setRegexp(String regexp, int regexpBufferSize) {
        this.setRegexp(regexp);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Deprecated
    public int getRegexpBufferSize() {
        return 0;
    }

    @Deprecated
    public void setRegexpBufferSize(int regexpBufferSize) {
    }
}

