/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.action.web;

import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.container.web.action.ActionMessage;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.AttributeValueManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.EmailUtils;
import ru.bitel.bgbilling.modules.email.server.bean.Forward;
import ru.bitel.bgbilling.modules.email.server.bean.ForwardManager;
import ru.bitel.bgbilling.modules.email.server.bean.WebPermition;
import ru.bitel.bgbilling.modules.email.server.bean.WebPermitionManager;
import ru.bitel.bgbilling.modules.email.server.event.AccountCreatedEvent;
import ru.bitel.bgbilling.modules.email.server.event.AccountDeleteEvent;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

@WebAction(title="Email")
public class ActionEmail
extends AbstractAction {
    public ActionEmail() {
        super("email");
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432")
    public void accountList() throws Exception {
        DomainManager domainManager = new DomainManager(this.con, this.moduleId);
        HashMap<Integer, Domain> map = new HashMap<Integer, Domain>();
        List<Account> accounts = new AccountManager(this.con, this.moduleId).getContractAccountList(this.contractId);
        List<Domain> domains = domainManager.list(null);
        for (Domain domain : domains) {
            if (!accounts.stream().anyMatch(a -> a.getDomainId() == domain.getId())) continue;
            map.put(domain.getId(), domain);
        }
        this.setResultParam("accountList", accounts);
        this.setResultParam("domainMap", map);
        this.setResultParam("domains", domains);
        this.requestDispatcher(this.moduleName, "list");
    }

    @WebOperation(title="\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430")
    public void accountCreate() throws Exception {
        String accountName = this.req.get("accountName");
        String accountPassword1 = this.req.get("accountPassword1");
        String accountPassword2 = this.req.get("accountPassword2");
        AccountManager accountManager = new AccountManager(this.con, this.moduleId);
        WebPermitionManager webPermitionManager = new WebPermitionManager(this.con, this.moduleId, (ParameterMap)this.moduleSetup);
        WebPermition webPermition = webPermitionManager.getPermition(this.contractId);
        ActionMessage message = new ActionMessage("emailRoot", "accountList", "emailQuery", "\u0410\u0434\u0440\u0435\u0441 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d");
        Object messageText = null;
        if (Utils.isEmptyString((String)accountPassword1) || Utils.isEmptyString((String)accountPassword2)) {
            messageText = "\u041e\u0428\u0418\u0411\u041a\u0410: \u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0432\u0432\u0435\u0434\u0435\u043d\u044b";
        }
        if (messageText == null) {
            String result = ContractUtils.checkPassword((ParameterMap)this.moduleSetup, (String)accountPassword1, (String)accountPassword2);
            Object object = messageText = result != null ? "\u041e\u0428\u0418\u0411\u041a\u0410: " + result : null;
        }
        if (messageText == null) {
            int domainId = this.req.getInt("domain", -1);
            int accountCount = accountManager.getContractAccountsCount(this.contractId, new Date());
            if (!webPermition.create || webPermition.maxCreate != 0 && webPermition.maxCreate <= accountCount) {
                messageText = "\u041e\u0428\u0418\u0411\u041a\u0410: \u0412\u044b \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u044f\u0449\u0438\u043a\u0438!";
            } else if (!webPermition.createDomains.contains(String.valueOf(domainId))) {
                messageText = "\u041e\u0428\u0418\u0411\u041a\u0410: \u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u044f\u0449\u0438\u043a\u0438 \u0432 \u044d\u0442\u043e\u043c \u0434\u043e\u043c\u0435\u043d\u0435!";
            } else if (!EmailUtils.checkAccountName(accountName, (ParameterMap)this.moduleSetup)) {
                messageText = "\u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0438\u043c\u044f \u044f\u0449\u0438\u043a\u0430!";
            } else {
                Account account = new Account();
                account.setContractId(this.contractId);
                account.setAccount(accountName);
                account.setDomainId(domainId);
                account.setQuota(webPermition.createQuota);
                account.setPassword(accountPassword1);
                account.setStatus(0);
                account.setDate1(new Date());
                account.setComment("\u0421\u043e\u0437\u0434\u0430\u043d \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c " + TimeUtils.format((Calendar)new GregorianCalendar(), (String)"dd.MM.yyyy"));
                if (Utils.notBlankString((String)accountManager.checkAccount(account))) {
                    messageText = "\u041e\u0428\u0418\u0411\u041a\u0410: \u0422\u0430\u043a\u043e\u0439 \u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u044f\u0449\u0438\u043a \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!";
                } else {
                    DomainManager domainManager = new DomainManager(this.con, this.moduleId);
                    Domain domain = domainManager.get(domainId);
                    domainManager.getServiceActivator(domain).create(account);
                    accountManager.updateAccount(account);
                    this.context.publishAfterCommit((Event)new AccountCreatedEvent(this.userId, this.moduleId, this.contractId, account.getAccount() + "@" + domain.getName()));
                }
            }
        }
        if (messageText != null) {
            message.setOnClose("close");
            message.setError((String)messageText);
        }
        this.setResultParam("message", message);
        this.requestDispatcher("include", "popup_message");
    }

    @WebOperation(title="\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430")
    public void accountDelete() throws Exception {
        int accountId = this.req.getInt("accountId", -1);
        String message = "\u041e\u0428\u0418\u0411\u041a\u0410: \u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442";
        AccountManager accountManager = new AccountManager(this.con, this.moduleId);
        Account account = accountManager.getAccountById(accountId);
        if (account != null && account.getContractId() == this.contractId) {
            this.setResultParam("account", (Object)account);
            WebPermitionManager webPermitionManager = new WebPermitionManager(this.con, this.moduleId, (ParameterMap)this.moduleSetup);
            WebPermition webPermition = webPermitionManager.getPermition(this.contractId);
            if (!webPermition.delete) {
                message = "\u041e\u0428\u0418\u0411\u041a\u0410: \u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0434\u0430\u043b\u044f\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u044b";
            } else {
                DomainManager domainManager = new DomainManager(this.con, this.moduleId);
                EmailUtils.deleteAccount(account, domainManager, accountManager);
                Domain domain = domainManager.get(account.getDomainId());
                this.context.publishAfterCommit((Event)new AccountDeleteEvent(this.userId, this.moduleId, this.contractId, account.getAccount() + "@" + domain.getName()));
                message = "\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0443\u0434\u0430\u043b\u0435\u043d";
            }
        }
        this.setResultParam("message", message);
        this.requestDispatcher(this.moduleName, "account_message");
    }

    @WebOperation(title="\u0421\u043c\u0435\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f")
    public void changePassword() throws Exception {
        AccountManager accountManager = new AccountManager(this.con, this.moduleId);
        int accountId = this.req.getInt("accountId", -1);
        Account account = accountManager.getAccountById(accountId);
        if (account != null && account.getContractId() == this.contractId) {
            this.setResultParam("account", (Object)account);
            String pswd0 = this.context.getRequest().getParameter("pswd0");
            if (pswd0 == null) {
                DomainManager domainManager = new DomainManager(this.con, this.moduleId);
                this.setResultParam("domain", domainManager.get(account.getDomainId()));
                this.requestDispatcher(this.moduleName, "password");
            } else {
                String error;
                String status = "ok";
                String message = null;
                String pswd1 = this.req.get("pswd1");
                String pswd2 = this.req.get("pswd2");
                WebPermitionManager webPermitionManager = new WebPermitionManager(this.con, this.moduleId, (ParameterMap)this.moduleSetup);
                WebPermition webPermition = webPermitionManager.getPermition(account.getContractId());
                if (!webPermition.passwdChange) {
                    status = "error";
                    message = "\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u043d\u0430 \u0441\u043c\u0435\u043d\u0443 \u043f\u0430\u0440\u043e\u043b\u044f";
                }
                if (message == null && (Utils.isEmptyString((String)pswd0) || Utils.isEmptyString((String)pswd1) || Utils.isEmptyString((String)pswd2))) {
                    status = "error";
                    message = "\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u0432\u0441\u0435 \u043f\u043e\u043b\u044f";
                }
                if (message == null && !pswd0.equals(account.getPassword())) {
                    status = "error";
                    message = "\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u0441\u0442\u0430\u0440\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c";
                }
                if (message == null && account.getDate2() != null && TimeUtils.dateBefore((Date)account.getDate2(), (Date)new Date())) {
                    status = "error";
                    message = "\u041d\u0435\u043b\u044c\u0437\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u0437\u0430\u043a\u0440\u044b\u0442\u044b\u043c \u043f\u0435\u0440\u0438\u043e\u0434\u043e\u043c";
                }
                if (message == null && (error = ContractUtils.checkPassword((ParameterMap)this.moduleSetup, (String)pswd1, (String)pswd2)) != null) {
                    status = "error";
                    message = error;
                }
                if (message == null) {
                    account.setPassword(pswd1);
                    account.setForwardList(new ForwardManager(this.con, this.moduleId).getForwardList(accountId));
                    account.setAttributes(new AttributeValueManager(this.con, this.moduleId).getValueList(account.getId()));
                    DomainManager domainManager = new DomainManager(this.con, this.moduleId);
                    Domain domain = domainManager.get(account.getDomainId());
                    if (domain != null) {
                        if (TimeUtils.dateInRange((Date)new Date(), (Date)account.getDate1(), (Date)account.getDate2())) {
                            domainManager.getServiceActivator(domain).modify(account);
                        }
                        accountManager.updateAccount(account);
                        message = "\u041f\u0430\u0440\u043e\u043b\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d";
                    }
                }
                this.setResultParam("status", status);
                this.setResultParam("message", message);
                this.requestDispatcher(this.moduleName, "password_message");
            }
        }
    }

    @WebOperation(title="\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u0435\u0440\u0435\u0430\u0434\u0440\u0435\u0441\u0430\u0446\u0438\u0439")
    public void forwardList() throws Exception {
        int accountId = this.req.getInt("accountId", -1);
        Account account = new AccountManager(this.con, this.moduleId).getAccountById(accountId);
        if (account != null && account.getContractId() == this.contractId) {
            this.setResultParam("account", (Object)account);
            this.setResultParam("forwardList", new ForwardManager(this.con, this.moduleId).getForwardList(accountId));
            DomainManager domainManager = new DomainManager(this.con, this.moduleId);
            this.setResultParam("domain", domainManager.get(account.getDomainId()));
        }
        this.requestDispatcher(this.moduleName, "forward");
    }

    @WebOperation(title="\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0430\u0434\u0440\u0435\u0441 \u043f\u0435\u0440\u0435\u0430\u0434\u0440\u0435\u0441\u0430\u0446\u0438\u0439")
    public void forwardAdd() throws Exception {
        int accountId = this.req.getInt("accountId", -1);
        String message = null;
        Account account = new AccountManager(this.con, this.moduleId).getAccountById(accountId);
        if (account != null && account.getContractId() == this.contractId) {
            ForwardManager forwardManager = new ForwardManager(this.con, this.moduleId);
            List<Forward> forwardList = forwardManager.getForwardList(accountId);
            String emailForward = this.req.get("forward");
            if (!EmailUtils.getCurrentPermition((int)this.moduleId, (int)this.contractId, (Account)account, (Connection)this.con, (ParameterMap)this.moduleSetup).forward) {
                message = "\u041e\u0428\u0418\u0411\u041a\u0410: \u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u0434\u0440\u0435\u0441\u043e\u0432 \u0437\u0430\u043f\u0440\u0435\u0448\u0435\u043d\u043e";
            } else if (!EmailUtils.checkForwardEmail(emailForward, (ParameterMap)this.moduleSetup)) {
                message = "\u041e\u0428\u0418\u0411\u041a\u0410: \u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u0430\u0434\u0440\u0435\u0441\u0430 \u043f\u0435\u0440\u0435\u0441\u044b\u043b\u043a\u0438!";
            }
            if (message == null) {
                Forward forward = new Forward();
                forward.setAccountId(accountId);
                forward.setEmail(emailForward);
                forwardList.remove(forward);
                forwardList.add(forward);
                account.setForwardList(forwardList);
                DomainManager domainManager = new DomainManager(this.con, this.moduleId);
                domainManager.getServiceActivator(domainManager.get(account.getDomainId())).modify(account);
                forwardManager.updateForwardList(accountId, forwardList);
                message = "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430";
            }
            this.setResultParam("account", (Object)account);
        } else {
            message = "\u041e\u0428\u0418\u0411\u041a\u0410: \u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438";
        }
        this.setResultParam("message", message);
        this.requestDispatcher(this.moduleName, "forward_message");
    }

    @WebOperation(title="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u0434\u0440\u0435\u0441 \u043f\u0435\u0440\u0435\u0430\u0434\u0440\u0435\u0441\u0430\u0446\u0438\u0439")
    public void forwardDelete() throws Exception {
        int accountId = this.req.getInt("accountId", -1);
        String message = null;
        Account account = new AccountManager(this.con, this.moduleId).getAccountById(accountId);
        if (account != null && account.getContractId() == this.contractId) {
            ForwardManager forwardManager = new ForwardManager(this.con, this.moduleId);
            List<Forward> forwardList = forwardManager.getForwardList(accountId);
            String emailForward = this.req.get("forward");
            Forward forward = new Forward();
            forward.setAccountId(accountId);
            forward.setEmail(emailForward);
            forwardList.remove(forward);
            account.setForwardList(forwardList);
            DomainManager domainManager = new DomainManager(this.con, this.moduleId);
            domainManager.getServiceActivator(domainManager.get(account.getDomainId())).modify(account);
            forwardManager.updateForwardList(accountId, forwardList);
            message = "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430";
            this.setResultParam("account", (Object)account);
        } else {
            message = "\u041e\u0428\u0418\u0411\u041a\u0410: \u0421\u0431\u043e\u0439 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438";
        }
        this.setResultParam("message", message);
        this.requestDispatcher(this.moduleName, "forward_message");
    }
}

