/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.modules.inet.server;

import java.sql.Connection;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.catalina.ssi.ByteArrayServletOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.web.action.ActionPerformer;
import ru.bitel.bgbilling.modules.inet.server.action.web.ActionSessionReport;
import ru.bitel.bgbilling.plugins.dispatch.server.interaction.ModuleResponse;
import ru.bitel.common.Preferences;
import ru.bitel.common.XMLUtils;

public class ModuleRequest
implements ru.bitel.bgbilling.plugins.dispatch.server.interaction.ModuleRequest {
    @Override
    public ModuleResponse ask(Connection con, int contractId, int moduleId, String action, Preferences prefs) throws BGException {
        ModuleResponse result = null;
        if ("session".equals(action)) {
            result = this.sessionReport(con, contractId, moduleId, prefs);
        }
        return result;
    }

    private ModuleResponse sessionReport(Connection con, int contractId, int moduleId, Preferences prefs) throws BGException {
        int servId = prefs.getInt(moduleId + ".inet_service_id", 0);
        Calendar now = Calendar.getInstance();
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("inetServId", String.valueOf(servId));
        requestParams.put("year", String.valueOf(now.get(1)));
        requestParams.put("month", String.valueOf(now.get(2) + 1));
        requestParams.put("day_from", String.valueOf(now.getActualMinimum(5)));
        requestParams.put("day_to", String.valueOf(now.getActualMaximum(5)));
        requestParams.put("pageIndex", "-1");
        requestParams.put("pageSize", "-1");
        requestParams.put("unit", "1");
        requestParams.put("mid", String.valueOf(moduleId));
        requestParams.put("operation", "historyExport");
        ByteArrayServletOutputStream os = new ByteArrayServletOutputStream();
        try {
            Document doc = XMLUtils.newDocument();
            Element rootNode = doc.createElement("data");
            doc.appendChild(rootNode);
            ActionPerformer.performAction(ActionSessionReport.class, (Element)rootNode, requestParams, (int)contractId, (ByteArrayServletOutputStream)os);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        ModuleResponse response = new ModuleResponse();
        response.setFile(ModuleResponse.buildDataSource("inet_sessions.html", os.toByteArray(), "text/html"));
        response.setMessage("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u043f\u043e \u0441\u0435\u0441\u0441\u0438\u044f\u043c \u0432\u043e \u0432\u043b\u043e\u0436\u0435\u043d\u0438\u0438.");
        return response;
    }
}

