/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff.max;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetServiceCost;
import ru.bitel.bgbilling.modules.inet.server.tariff.InetTariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMax;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxDao;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxEntry;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxEvent;
import ru.bitel.bgbilling.modules.inet.server.tariff.max.TrafficMaxKey;
import ru.bitel.common.sql.ConnectionSet;

public class TrafficMaxManager
implements EventListener<TrafficMaxEvent> {
    private static final Logger logger = LogManager.getLogger();
    protected final int moduleId;
    private final ConcurrentMap<Integer, TrafficMaxEntry> rangedTrafficMap = new ConcurrentHashMap<Integer, TrafficMaxEntry>(256);
    private final boolean realtime;

    public TrafficMaxManager(int moduleId, boolean realtime) throws BGException {
        this.moduleId = moduleId;
        this.realtime = realtime;
        if (realtime) {
            EventProcessor.getInstance().addListener((EventListener)this, TrafficMaxEvent.class, moduleId, null);
        }
    }

    public TrafficMaxEntry getTrafficMaxEntry(int contractId) {
        TrafficMaxEntry entry = (TrafficMaxEntry)this.rangedTrafficMap.get(contractId);
        if (entry == null) {
            TrafficMaxEntry newEntry = new TrafficMaxEntry();
            entry = this.rangedTrafficMap.putIfAbsent(contractId, newEntry);
            if (entry == null) {
                entry = newEntry;
            }
        }
        return entry;
    }

    protected TrafficMax getMaxTraffic(InetTariffWorkerContext workerContext, int contractId, long accountingPeriodFrom, long treeNodeId, long key, Calendar time) throws BGException {
        try {
            ResultSet rs = workerContext.getPSCache().execute("SELECT counter, amountMax, amount1, amount2 FROM inet_tariff_traffic_max_" + this.moduleId + " WHERE contractId=? AND treeNodeId=? AND maxKey=? ORDER BY yy DESC, mm DESC LIMIT 1", contractId, treeNodeId, key);
            TrafficMax maxTraffic = rs.next() ? new TrafficMax(rs.getInt(1), rs.getLong(2), rs.getLong(3), rs.getLong(4)) : new TrafficMax(0, 0L, 0L, 0L);
            rs.close();
            return maxTraffic;
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetServiceCost addMaxTraffic(TrafficMaxEntry trafficMaxEntry, InetTariffWorkerContext workerContext, int contractId, int accountingPeriodId, long accountingPeriodMillisFrom, int contractTariffOptionId, long treeNodeId, int mode, Calendar time, InetServiceCost serviceCost1, InetServiceCost serviceCost2) throws BGException {
        trafficMaxEntry.lock();
        try {
            TrafficMaxKey key = trafficMaxEntry.searchKey;
            key.setKey(treeNodeId, mode, accountingPeriodId, contractTariffOptionId, time);
            TrafficMax trafficMax = trafficMaxEntry.map.get(key);
            if (trafficMax == null) {
                if (this.realtime && trafficMaxEntry.map.size() > 8) {
                    TrafficMaxKey oldKey;
                    long minKey = 0L;
                    for (Map.Entry<TrafficMaxKey, TrafficMax> e : trafficMaxEntry.map.entrySet()) {
                        oldKey = e.getKey();
                        if (oldKey.treeNodeId != key.treeNodeId || oldKey.key >= key.key || oldKey.key <= minKey) continue;
                        minKey = oldKey.key;
                    }
                    Iterator<Map.Entry<TrafficMaxKey, TrafficMax>> iter = trafficMaxEntry.map.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<TrafficMaxKey, TrafficMax> e;
                        e = iter.next();
                        oldKey = e.getKey();
                        if (oldKey.treeNodeId != key.treeNodeId || oldKey.key >= minKey) continue;
                        logger.debug("Remove old TrafficMax from cache " + String.valueOf(key));
                        iter.remove();
                    }
                }
                trafficMax = this.getMaxTraffic(workerContext, contractId, accountingPeriodMillisFrom, treeNodeId, key.key, time);
                trafficMaxEntry.map.put(new TrafficMaxKey(key.treeNodeId, key.key), trafficMax);
            }
            long amount1 = serviceCost1 != null ? serviceCost1.getAmount() : 0L;
            long amount2 = serviceCost2 != null ? serviceCost2.getAmount() : 0L;
            trafficMax.amount1 += amount1;
            trafficMax.delta1 += amount1;
            trafficMax.amount2 += amount2;
            trafficMax.delta2 += amount2;
            long oldMax = trafficMax.amountMax;
            if (trafficMax.amount1 >= trafficMax.amount2) {
                trafficMax.amountMax = trafficMax.amount1;
            } else {
                trafficMax.amountMax = trafficMax.amount2;
                InetServiceCost serviceCost = serviceCost1;
                serviceCost1 = serviceCost2;
                serviceCost2 = serviceCost;
            }
            long delta = trafficMax.amountMax - oldMax;
            trafficMax.deltaMax += delta;
            if (delta != 0L || amount1 != 0L || amount2 != 0L) {
                trafficMaxEntry.delta = true;
            }
            if (serviceCost2 != null) {
                serviceCost2.setAmount(0L);
                serviceCost2.amountNull = true;
            }
            if (serviceCost1 != null) {
                serviceCost1.setAmount(delta);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Add to " + String.valueOf(key) + " " + delta + " (" + trafficMax.amount1 + ", " + trafficMax.amount2 + ")");
            }
            InetServiceCost inetServiceCost = serviceCost1;
            return inetServiceCost;
        }
        finally {
            trafficMaxEntry.unlock();
        }
    }

    public InetServiceCost addMaxTraffic(InetTariffWorkerContext workerContext, int contractId, int accountingPeriodId, long accountingPeriodFrom, int contractTariffOptionId, long treeNodeId, int mode, Calendar time, InetServiceCost serviceCost1, InetServiceCost serviceCost2) throws BGException {
        TrafficMaxEntry rangedTrafficEntry = this.getTrafficMaxEntry(contractId);
        return this.addMaxTraffic(rangedTrafficEntry, workerContext, contractId, accountingPeriodId, accountingPeriodFrom, contractTariffOptionId, treeNodeId, mode, time, serviceCost1, serviceCost2);
    }

    public InetServiceCost addMaxTraffic(InetTariffWorkerContext workerContext, InetConnectionRuntime connectionRuntime, int contractTariffOptionId, long treeNodeId, int mode, Calendar time, InetServiceCost serviceCost1, InetServiceCost serviceCost2) throws BGException {
        TrafficMaxEntry rangedTrafficEntry = connectionRuntime.maxTraffic;
        if (rangedTrafficEntry == null) {
            rangedTrafficEntry = connectionRuntime.maxTraffic = this.getTrafficMaxEntry(connectionRuntime.contractId);
        }
        return this.addMaxTraffic(rangedTrafficEntry, workerContext, connectionRuntime.contractId, connectionRuntime.accountingPeriodId, connectionRuntime.accountingPeriodMillisFrom, contractTariffOptionId, treeNodeId, mode, time, serviceCost1, serviceCost2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(TrafficMaxEvent e, EventListenerContext ctx) throws BGException {
        TrafficMaxEntry trafficMaxEntry = (TrafficMaxEntry)this.rangedTrafficMap.get(e.getContractId());
        if (trafficMaxEntry != null) {
            trafficMaxEntry.lock();
            try {
                TrafficMaxKey key = trafficMaxEntry.searchKey;
                key.setKey(e.getTreeNodeId(), e.getKey());
                TrafficMax maxTraffic = trafficMaxEntry.map.get(key);
                if (maxTraffic == null) {
                    maxTraffic = new TrafficMax(e.getCounter(), e.getAmountMax(), e.getAmount1(), e.getAmount2());
                    trafficMaxEntry.map.put(new TrafficMaxKey(key.treeNodeId, key.key), maxTraffic);
                } else if (e.getCounter() > maxTraffic.counter) {
                    if (trafficMaxEntry.delta) {
                        maxTraffic.amountMax += e.getDeltaMax();
                        maxTraffic.amount1 += e.getDelta1();
                        maxTraffic.amount2 += e.getDelta2();
                    } else {
                        maxTraffic.counter = e.getCounter();
                        maxTraffic.amountMax = e.getAmountMax();
                        maxTraffic.amount1 = e.getAmount1();
                        maxTraffic.amount2 = e.getAmount2();
                    }
                }
            }
            finally {
                trafficMaxEntry.unlock();
            }
        }
    }

    public PreparedStatement createUpdatePS(Connection con, int moduleId, Calendar time) {
        return null;
    }

    public Set<Map.Entry<Integer, TrafficMaxEntry>> entrySet() {
        return this.rangedTrafficMap.entrySet();
    }

    public void removeTrafficMaxEntry(int contractId) {
        this.rangedTrafficMap.remove(contractId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCache(ConnectionSet connectionSet, boolean canClear) throws BGException {
        if (canClear) {
            logger.info("Clear trafficMax cache");
            this.rangedTrafficMap.clear();
            return;
        }
        logger.info("Updating trafficMax cache");
        try (TrafficMaxDao rangeDao = new TrafficMaxDao(connectionSet.getConnection(), this.moduleId);){
            for (Map.Entry e : this.rangedTrafficMap.entrySet()) {
                Integer contractId = (Integer)e.getKey();
                TrafficMaxEntry rangeEntry = (TrafficMaxEntry)e.getValue();
                rangeEntry.lock();
                try {
                    for (Map.Entry<TrafficMaxKey, TrafficMax> ee : rangeEntry.map.entrySet()) {
                        TrafficMaxKey key = ee.getKey();
                        TrafficMax max = ee.getValue();
                        rangeDao.get(contractId, key, max);
                    }
                }
                finally {
                    rangeEntry.unlock();
                }
            }
        }
        logger.info("TrafficMax cache updated");
    }
}

