/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.gospell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.gospell.ByteDeserializer;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.gospell.ByteSerializer;
import ru.bitel.common.Utils;
import ru.bitel.common.util.DebugUtils;

public abstract class Packet
extends BGLogger {
    private int sessionId;
    private final int CAS_VER = 2;
    private static final int HEADER_LENGTH = 6;
    static final int COMMAND_send_entitlement_to_user = 1;
    static final int COMMAND_display_OSD = 2;
    static final int COMMAND_reset_PIN_code = 3;
    static final int COMMAND_activate_STB_card_pairing = 4;
    static final int COMMAND_deactivate_STB_card_pairing = 5;
    static final int COMMAND_show_frigerprint = 6;
    static final int COMMAND_activate_area_lock = 8;
    static final int COMMAND_cancel_regional_lockin = 9;
    static final int COMMAND_card_issue_by_operator = 10;
    static final int COMMAND_start_stop_card = 11;
    static final int COMMAND_send_EMM_data = 12;
    static final int COMMAND_send_email = 13;
    static final int COMMAND_conditional_addressing = 14;
    static final int COMMAND_IPPV_NVOD_amount_charge = 16;
    static final int COMMAND_activate_conditional_prohibit_play = 17;
    static final int COMMAND_cancel_conditional_prohibit_play = 18;

    public int getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(int sessionId) {
        this.sessionId = sessionId;
    }

    protected abstract int getCommandType();

    public void writePacket(OutputStream output) throws IOException {
        byte[] data = this.getDataBody();
        ByteSerializer result = new ByteSerializer(6 + data.length);
        result.put(this.sessionId, 2);
        result.put(2, 1);
        result.put(this.getCommandType(), 1);
        result.put(data.length, 2);
        if (data.length > 0) {
            result.put(data);
        }
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("-> " + Utils.bytesToString((byte[])result.getBuffer()));
        }
        output.write(result.getBuffer());
    }

    protected abstract byte[] getDataBody();

    public void readPacket(InputStream input) throws IOException {
        byte[] header = new byte[6];
        Utils.readFullBuffer((InputStream)input, (byte[])header);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace("<- " + Utils.bytesToString((byte[])header));
        }
        ByteDeserializer bd = new ByteDeserializer(header);
        this.sessionId = bd.getInt(2);
        int CAS_Ver = bd.getInt(1);
        if (CAS_Ver != 2) {
            throw new IOException(String.format("unsupported version request packet (current: %d, response: %d)", 2, CAS_Ver));
        }
        int Command_Type = bd.getInt(1);
        if (Command_Type != this.getCommandType()) {
            throw new IOException(String.format("not equals command type (current: %d, response: %d)", this.getCommandType(), Command_Type));
        }
        int Data_Len = bd.getInt(2);
        if (Data_Len > 0) {
            byte[] bodybytes = new byte[Data_Len];
            Utils.readFullBuffer((InputStream)input, (byte[])bodybytes);
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("<- " + Utils.bytesToString((byte[])bodybytes));
            }
            ByteDeserializer body = new ByteDeserializer(bodybytes);
            this.parseDataBody(body);
        }
    }

    protected abstract void parseDataBody(ByteDeserializer var1);

    public String toString() {
        return DebugUtils.dumpObject((Object)((Object)this));
    }
}

