/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.elkom;

import au.com.bytecode.opencsv.CSVWriter;
import bitel.billing.server.contract.bean.Contract;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.common.service.InetServService;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.upload.elkom.ElkomPaymentType;
import ru.bitel.bgbilling.modules.sorm.server.bean.InternalUser;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.elkom.ElkomFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.utils.InternalUserAddressUtils;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUploadHelper;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;

public class ElkomUpload
extends Upload {
    private static final Logger logger = LogManager.getLogger();

    public ElkomUpload(int moduleId, SormProject sormProject, boolean isFullUpload) {
        super(moduleId, sormProject, isFullUpload);
    }

    @Override
    public Path abonents() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, ElkomFileTitle.ABONENT.getTitle(), "%s_%td%tm%tY_%tH%tM.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            Map<String, List<Integer>> telephoneModules = SormUtils.getTelephoneModulesIds(this.config);
            Map<Integer, List<InetServ>> abonentServices = SormUtils.getPairsAbonentInetServices(this.config, this.contracts, this.serverContext);
            try {
                if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                    for (SormContract contract : this.contracts) {
                        this.helper.setCurrentContract(contract);
                        List<InetServ> servList = abonentServices.get(contract.getContractId());
                        if (servList == null) continue;
                        for (InetServ inetServ : servList) {
                            if (this.isClosed(inetServ.getDateTo())) continue;
                            ArrayList<String> ip4Addresses = new ArrayList<String>(SormUtils.IpUtils.expand(inetServ.getAddressFrom(), inetServ.getAddressTo()));
                            String login = Utils.maskBlank((String)inetServ.getLogin(), (String)inetServ.getContractTitle());
                            for (String ip : ip4Addresses) {
                                String[] item = this.getInetItem(contract, inetServ, ip, login);
                                this.writeItemToFile(item, contract.getContractId(), ElkomFileTitle.ABONENT.getTitle(), csvFile);
                                this.writeInternalUsers(this.helper, item, csvFile, login, ip, null, contract.getContractId());
                            }
                        }
                    }
                }
                if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                    for (Integer voiceMid : telephoneModules.get(UploadModulesTitle.VOICE.getTitleModule())) {
                        VoiceAccountService accountService = (VoiceAccountService)this.serverContext.getService(VoiceAccountService.class, voiceMid.intValue());
                        for (SormContract contract : this.contracts) {
                            this.helper.setCurrentContract(contract);
                            List accounts = accountService.voiceAccountList(contract.getContractId(), 0, new Period(contract.getDateFrom(), contract.getDateTo()));
                            for (VoiceAccount account : accounts) {
                                if (this.isClosed(account.getDateTo())) continue;
                                String login = Utils.maskBlank((String)account.getLogin(), (String)contract.getContractTitle());
                                String phoneNumber = String.valueOf(account.getNumber());
                                String[] item = this.getPhoneItem(contract, account.getDateFrom(), account.getDateTo(), phoneNumber, login);
                                this.writeItemToFile(item, contract.getContractId(), ElkomFileTitle.ABONENT.getTitle(), csvFile);
                                this.writeInternalUsers(this.helper, item, csvFile, login, null, phoneNumber, contract.getContractId());
                            }
                        }
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0438\u0445 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u044e\u0440.\u043b\u0438\u0446");
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            logger.error(text + String.valueOf(e));
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        logger.info("\u0417\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0444\u0430\u0439\u043b\u0430 \u0441 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430\u043c\u0438");
        return file;
    }

    private boolean isClosed(Date dateTo) {
        return dateTo != null && dateTo.before(new Date());
    }

    private String[] getPhoneItem(SormContract contract, Date dateFrom, Date dateTo, String phoneNumber, String login) throws Exception {
        String[] item = this.getAbonentItem(contract, dateFrom, dateTo, login);
        item[0] = "1";
        item[1] = Utils.maskBlank((String)phoneNumber, (String)"");
        return item;
    }

    private String[] getInetItem(SormContract contract, InetServ inetServ, String ipv4, String login) throws Exception {
        String[] item = this.getAbonentItem(contract, inetServ.getDateFrom(), inetServ.getDateTo(), login);
        item[0] = "2";
        item[2] = ipv4;
        item[4] = "";
        return item;
    }

    private String[] getAbonentItem(SormContract contract, Date dateFrom, Date dateTo, String login) throws Exception {
        String[] item = new String[46];
        item[0] = "";
        item[1] = "";
        item[2] = "";
        item[3] = "";
        item[4] = "";
        item[5] = contract.isFiz() ? Utils.maskBlank((String)login, (String)"") : "";
        item[6] = "";
        item[7] = contract.isFiz() ? "1" : "2";
        item[8] = this.helper.contractIsActive() ? "2" : "1";
        item[9] = contract.getContractTitle();
        if (contract.isFiz()) {
            item[10] = "";
            item[11] = this.helper.getStringParam("sorm.upload.fiz.lastname");
            item[12] = this.helper.getStringParam("sorm.upload.fiz.firstname");
            item[13] = this.helper.getStringParam("sorm.upload.fiz.middlename");
            item[14] = "";
            item[15] = "";
            item[16] = this.helper.getDateParam("sorm.upload.fiz.birthday", "dd.MM.yyyy");
            item[17] = "";
        } else {
            item[10] = this.helper.getStringParam("sorm.upload.org.contactface");
            item[11] = "";
            item[12] = "";
            item[13] = "";
            item[14] = this.helper.getContactFacePhone();
            item[15] = this.helper.getFullTitleOrg();
            item[16] = "";
            item[17] = this.helper.getINN();
        }
        AddressStruct address = this.helper.getAddress();
        String region = SormUtils.getParameterOfCity((Upload)this, address, "region");
        String zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
        if (address != null) {
            item[18] = Utils.maskBlank((String)address.getIndex(), (String)"");
            item[19] = Utils.maskBlank((String)address.getCountry(), (String)"");
            item[20] = region;
            item[21] = zone;
            item[22] = Utils.maskBlank((String)address.getCity(), (String)"");
            item[23] = Utils.maskBlank((String)address.getStreet(), (String)"");
            item[24] = Utils.maskBlank((String)address.getHouse(), (String)"");
            item[25] = Utils.maskBlank((String)address.getFrac(), (String)"");
            item[26] = Utils.maskBlank((String)address.getFlat(), (String)"");
        } else {
            item[18] = "";
            item[19] = "";
            item[20] = "";
            item[21] = "";
            item[22] = "";
            item[23] = "";
            item[24] = "";
            item[25] = "";
        }
        address = this.helper.getCommutatorsAddress();
        if (address != null) {
            region = SormUtils.getParameterOfCity((Upload)this, address, "region");
            zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
            item[27] = Utils.maskBlank((String)address.getIndex(), (String)"");
            item[28] = Utils.maskBlank((String)address.getCountry(), (String)"");
            item[29] = region;
            item[30] = zone;
            item[31] = Utils.maskBlank((String)address.getCity(), (String)"");
            item[32] = Utils.maskBlank((String)address.getStreet(), (String)"");
            item[33] = Utils.maskBlank((String)address.getHouse(), (String)"");
            item[34] = Utils.maskBlank((String)address.getFrac(), (String)"");
            item[35] = Utils.maskBlank((String)address.getFlat(), (String)"");
        } else {
            item[26] = "";
            item[27] = "";
            item[28] = "";
            item[29] = "";
            item[30] = "";
            item[31] = "";
            item[32] = "";
            item[33] = this.helper.getUnstructCommutatorsAddress();
            item[34] = "";
            item[35] = "";
        }
        if (contract.isFiz()) {
            item[36] = this.defineDocumentType(contract.getContractId());
            item[37] = this.helper.getStringParam("sorm.upload.fiz.documentserial");
            item[38] = this.helper.getStringParam("sorm.upload.fiz.documentnumber");
            String whoWhenGive = this.helper.getStringParam("sorm.upload.fiz.documentwhogive") + " " + this.helper.getStringParam("sorm.upload.fiz.documentwhengive");
            item[39] = Utils.maskBlank((String)whoWhenGive, (String)"").trim();
        } else {
            item[36] = "";
            item[37] = "";
            item[38] = "";
            item[39] = "";
        }
        item[40] = this.helper.getBankTitle();
        item[41] = this.helper.getBankAccount();
        item[42] = TimeUtils.format((Date)dateFrom, (String)"yyyy-MM-dd");
        item[43] = dateTo != null ? TimeUtils.format((Date)dateTo, (String)"yyyy-MM-dd") : "2045-12-31";
        item[44] = "1";
        item[45] = "";
        return item;
    }

    private String defineDocumentType(int contractId) throws BGException {
        int pid;
        String value;
        String documentRatio = this.config.get("sorm.elkom.document.ratio");
        JSONObject ratio = Utils.isBlankString((String)documentRatio) ? new JSONObject() : new JSONObject(documentRatio);
        if (ratio.has(value = (String)this.contractDao.getContractParameterListAsString(contractId, pid = this.config.getInt("sorm.upload.documenttype", -1)).orElse(null))) {
            return String.valueOf(ratio.get(value));
        }
        return "";
    }

    private void writeInternalUsers(SormUploadHelper helper, String[] parentItem, CSVWriter csvFile, String login, String ip, String phone, int cid) throws Exception {
        InternalUser internalUser;
        if (parentItem == null) {
            return;
        }
        List<InternalUser> internalUserList = SormUtils.getInternalUsers(this.contractObjectDao, helper, this.config);
        InternalUser internalUser2 = internalUser = internalUserList.size() > 0 ? internalUserList.get(0) : null;
        if (internalUser != null) {
            String[] internalItem = Arrays.copyOfRange(parentItem, 0, parentItem.length);
            internalItem[1] = Utils.maskBlank((String)phone, (String)"");
            internalItem[2] = Utils.maskBlank((String)ip, (String)"");
            internalItem[5] = Utils.maskBlank((String)login, (String)"");
            internalItem[7] = "3";
            internalItem[11] = internalUser.getLastName();
            internalItem[12] = internalUser.getFirstName();
            internalItem[13] = internalUser.getMiddleName();
            internalItem[16] = internalUser.getBirthday() == null ? "" : TimeUtils.format((Date)internalUser.getBirthday(), (String)"yyyy-MM-dd");
            EntityAttrAddress entityAttrAddress = internalUser.getAddressStruct();
            if (entityAttrAddress != null) {
                InternalUserAddressUtils addressUtils = new InternalUserAddressUtils(entityAttrAddress, this.con);
                internalItem[18] = addressUtils.getIndex();
                internalItem[19] = addressUtils.getCountry();
                internalItem[20] = "";
                internalItem[21] = addressUtils.getArea();
                internalItem[22] = addressUtils.getCity();
                internalItem[23] = addressUtils.getStreet();
                internalItem[24] = addressUtils.getHouse();
                internalItem[25] = addressUtils.getFrac();
                internalItem[26] = addressUtils.getFlat();
            } else {
                internalItem[18] = "";
                internalItem[19] = "";
                internalItem[20] = "";
                internalItem[21] = "";
                internalItem[22] = "";
                internalItem[23] = "";
                internalItem[24] = "";
                internalItem[25] = "";
                internalItem[26] = "";
            }
            internalItem[36] = internalUser.getDocumentType();
            internalItem[37] = internalUser.getDocumentSerial();
            internalItem[38] = internalUser.getDocumentNumber();
            Date whenGiveDate = internalUser.getDocumentWhenGive();
            String whenGive = whenGiveDate == null ? "" : TimeUtils.format((Date)whenGiveDate, (String)"yyyy-MM-dd");
            internalItem[39] = internalUser.getDocumentWhoGive() + " " + whenGive;
            internalItem[45] = internalUser.getAddress();
            this.writeItemToFile(internalItem, cid, "abonents_internal_" + internalUser.getBgObjectId(), csvFile);
        }
    }

    @Override
    public Path abonentsAddresses() {
        return null;
    }

    @Override
    public Path abonentLogins() {
        return null;
    }

    @Override
    public Path services() {
        return null;
    }

    @Override
    public Path abonentServices() {
        return null;
    }

    @Override
    public Path ipNumbering() {
        return null;
    }

    @Override
    public Path abonentsIpNumbering() {
        return null;
    }

    @Override
    public Path switches() {
        return null;
    }

    @Override
    public Path gateways() {
        return null;
    }

    @Override
    public Path bunches() {
        return null;
    }

    @Override
    public Path phoneNumbering() {
        return null;
    }

    @Override
    public Path phoneNumberingAbonents() {
        return null;
    }

    @Override
    public Path documentTypes() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, ElkomFileTitle.DOCUMENT_TYPE.getTitle(), "%s_%td%tm%tY_%tH%tM.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, ';');){
            csvFile.close();
            for (IdTitle docType : SormUtils.getDocumentsTypes(this.config, this.cpm)) {
                String[] item = new String[]{docType.getTitle().equals("\u041f\u0430\u0441\u043f\u043e\u0440\u0442 \u0420\u0424") ? "21" : String.valueOf(docType.getId()), docType.getTitle() + "{" + docType.getId() + "}", "", ""};
                this.writeItemToFile(item, -1, ElkomFileTitle.DOCUMENT_TYPE.getTitle(), csvFile);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432: ";
            logger.error(text + String.valueOf(e));
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        logger.info("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
        return file;
    }

    @Override
    public Path paymentTypes() {
        return null;
    }

    @Override
    public Path abonentsPayments() {
        logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
        Path file = SormUtils.getUploadFile(this.localUserPath, ElkomFileTitle.PAYMENTS.getTitle(), "%s_%td%tm%tY_%tH%tM.csv");
        ArrayList<Integer> inetMids = new ArrayList<Integer>();
        boolean inetModuleIsInstalled = this.checkInstalledModule(UploadModulesTitle.INET);
        if (inetModuleIsInstalled) {
            inetMids.addAll(SormUtils.getSelectedInetModulesToUpload(this.config));
        }
        ArrayList<Integer> voiceMids = new ArrayList<Integer>();
        boolean voiceModuleIsInstalled = this.checkInstalledModule(UploadModulesTitle.VOICE);
        if (voiceModuleIsInstalled) {
            voiceMids.addAll(SormUtils.getSelectedVoiceModulesToUpload(this.config));
        }
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, '\u0000');){
            List<Payment> payments = this.paymentsToUpload.getPaymentsToUpload(false);
            if (logger.isDebugEnabled()) {
                logger.debug("\u0412\u0441\u0435\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + payments.size());
            }
            for (Payment payment : payments) {
                try {
                    Object accounts;
                    Contract contract = this.contractManager.getContractById(payment.getContractId());
                    if (contract == null) continue;
                    this.helper.setCurrentContract(contract);
                    String phoneNumber = "";
                    if (voiceModuleIsInstalled) {
                        Iterator iterator = voiceMids.iterator();
                        while (iterator.hasNext()) {
                            int voiceMid = (Integer)iterator.next();
                            VoiceAccountService voiceAccountService = (VoiceAccountService)this.serverContext.getService(VoiceAccountService.class, voiceMid);
                            accounts = voiceAccountService.voiceAccountList(contract.getId(), 0, new Period(contract.getDateFrom(), contract.getDateTo()));
                            if (!Utils.notEmptyCollection((Collection)accounts)) continue;
                            phoneNumber = String.valueOf(((VoiceAccount)accounts.get(0)).getNumber());
                        }
                    }
                    String[] item = new String[33];
                    item[0] = this.getPaymentTypeCode(payment.getTypeId());
                    item[1] = contract.getTitle();
                    item[2] = Utils.maskBlank((String)phoneNumber, (String)"");
                    item[3] = "";
                    item[4] = "";
                    item[5] = "";
                    item[6] = contract.getTitle();
                    item[7] = "";
                    String login = "";
                    String ipV4 = "";
                    if (inetModuleIsInstalled) {
                        accounts = inetMids.iterator();
                        while (accounts.hasNext()) {
                            int inetMid = (Integer)accounts.next();
                            InetServService servService = (InetServService)this.serverContext.getService(InetServService.class, inetMid);
                            List contractServices = servService.inetServList(contract.getId(), null);
                            if (!Utils.notEmptyCollection((Collection)contractServices)) continue;
                            InetServ serv = (InetServ)contractServices.get(0);
                            login = serv.getLogin();
                            byte[] addressFrom = serv.getAddressFrom();
                            if (addressFrom != null) {
                                ipV4 = InetAddress.getByAddress(addressFrom).getHostAddress();
                            }
                            if (!Utils.notBlankString((String)login) && !Utils.notBlankString((String)ipV4)) continue;
                            break;
                        }
                    }
                    item[8] = Utils.maskBlank((String)ipV4, (String)"");
                    item[9] = "";
                    item[10] = Utils.maskBlank((String)login, (String)"");
                    item[11] = payment.getDate() != null ? TimeUtils.format((Date)payment.getDate(), (String)"yyyy-MM-dd") : "";
                    item[12] = Utils.maskBlank((String)contract.getComment(), (String)"").replaceAll(";", "");
                    item[13] = "";
                    item[14] = "";
                    item[15] = this.helper.getBankTitle().replaceAll("\\\"", "");
                    item[16] = "";
                    item[17] = "";
                    item[18] = this.helper.getBankAccount();
                    item[19] = "";
                    item[20] = "";
                    item[21] = "";
                    item[22] = "";
                    AddressStruct address = this.helper.getAddress();
                    if (address != null) {
                        String region = SormUtils.getParameterOfCity((Upload)this, address, "region");
                        String zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
                        item[23] = "";
                        item[24] = Utils.maskBlank((String)address.getCountry(), (String)"");
                        item[25] = Utils.maskBlank((String)region, (String)"");
                        item[26] = Utils.maskBlank((String)zone, (String)"");
                        item[27] = Utils.maskBlank((String)address.getCity(), (String)"");
                        item[28] = Utils.maskBlank((String)address.getStreet(), (String)"");
                        item[29] = Utils.maskBlank((String)address.getHouse(), (String)"");
                        item[30] = "";
                    } else {
                        item[23] = "";
                        item[24] = "";
                        item[25] = "";
                        item[26] = "";
                        item[27] = "";
                        item[28] = "";
                        item[29] = "";
                        item[30] = "";
                    }
                    item[31] = payment.getSum() != null ? payment.getSum().toString() : "";
                    item[32] = "1";
                    this.writeItemToFile(item, payment.getContractId(), ElkomFileTitle.PAYMENTS.getTitle(), csvFile);
                }
                catch (Exception e) {
                    logger.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0430 " + payment.getId() + " : " + String.valueOf(e));
                }
            }
            if (Utils.notEmptyCollection(payments)) {
                this.paymentsToUpload.updatePaymentsLogTable(payments.get(payments.size() - 1).getId());
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: ";
            logger.error(text + String.valueOf(ex));
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text);
        }
        logger.info("\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
        return file;
    }

    public String getPaymentTypeCode(int paymentTypeId) {
        Map<Integer, List<Integer>> typesRatio = SormUtils.getPairsMidsListIds(this.config, "sorm.upload.paytype.ratio");
        List<Integer> types = typesRatio.get(paymentTypeId);
        if (Utils.isEmptyCollection(types)) {
            return ElkomPaymentType.BANK_TRANSACTION.getCodeStr();
        }
        ElkomPaymentType type = ElkomPaymentType.getType((int)types.get(0));
        if (type != null) {
            return type.getCodeStr();
        }
        return ElkomPaymentType.BANK_TRANSACTION.getCodeStr();
    }

    @Override
    public Path operatorInfo() {
        return null;
    }

    @Override
    public List<Pair<String, Path>> getOtherFiles() {
        return Collections.emptyList();
    }
}

