/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public final class EPortTransactionManager
extends MPSTransactionManager {
    private static final String TIMEPATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final String TIMEPATTERN2 = "yyyy-MM-dd'T'HH:mm:ss";
    private static final Pattern patPlus = Pattern.compile("\\+");
    private static final Pattern patStar = Pattern.compile("\\*");
    protected static final Pattern TRANSACTION_PATTERN = Pattern.compile("^(.+)\\t(\\d+)\\t([\\d+: -T]+)\\t(\\d+\\.*\\d*)\\t(\\d+)$", 8);

    private static String enc(String s) throws UnsupportedEncodingException {
        return patStar.matcher(patPlus.matcher(URLEncoder.encode(s, "UTF-8")).replaceAll("%20")).replaceAll("%2A");
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        char type;
        MPSRequest mpsRequest = new MPSRequest(con, moduleId, mpsId, request, system);
        String actionString = request.getParameter("type");
        if ("payment".equals(actionString)) {
            mpsRequest.setAction(2);
        } else if ("check".equals(actionString)) {
            mpsRequest.setAction(1);
        } else if ("revoke".equals(actionString)) {
            mpsRequest.setAction(4);
        } else if ("status".equals(actionString)) {
            mpsRequest.setAction(3);
        }
        mpsRequest.setRawNumber(request.getParameter("account"));
        if (system.osmpPrefix && mpsRequest.getRawNumber() != null && mpsRequest.getRawNumber().length() > 1 && mpsRequest.getRawNumber().charAt(1) == '_' && Character.isDigit((int)(type = mpsRequest.getRawNumber().charAt(0)))) {
            mpsRequest.setType(Character.getNumericValue((int)type));
            mpsRequest.setNumber(mpsRequest.getRawNumber().substring(2));
        } else {
            mpsRequest.setNumber(mpsRequest.getRawNumber());
            mpsRequest.setType(0);
        }
        String summString = request.getParameter("sum");
        mpsRequest.setSum(Utils.parseBigDecimal((String)summString, (BigDecimal)BigDecimal.ZERO));
        mpsRequest.setTransId(request.getParameter("id"));
        String timestamp = request.getParameter("timestamp");
        String timeString = request.getParameter("pay_time");
        Date timestampDate = EPortTransactionManager.parseDate(timestamp, new GregorianCalendar());
        Date payTimeDate = EPortTransactionManager.parseDate(timeString, new GregorianCalendar());
        mpsRequest.setTimeString(timeString != null ? timeString : timestamp);
        mpsRequest.setTime(EPortTransactionManager.parseDate(mpsRequest.getTimeString(), new GregorianCalendar()));
        mpsRequest.setComment(request.getParameter("comment"));
        String reqHash = request.getParameter("sign");
        ArrayList<String> parameterNames = Collections.list(request.getParameterNames());
        Collections.sort(parameterNames);
        try {
            byte[] myHash;
            StringBuilder sb = new StringBuilder(100);
            switch (mpsRequest.getAction()) {
                case 1: {
                    if (mpsRequest.getNumber() != null && mpsRequest.getNumber().length() > 0 && mpsRequest.getSum() != null && mpsRequest.getSum().compareTo(BigDecimal.ZERO) > 0 && timestampDate != null) break;
                    throw new MPSException(2);
                }
                case 2: {
                    if (mpsRequest.getNumber() == null || mpsRequest.getNumber().length() <= 0 || mpsRequest.getSum() == null || mpsRequest.getSum().compareTo(BigDecimal.ZERO) <= 0 || mpsRequest.getTransId() == null || this.parseBigInteger(mpsRequest.getTransId()).compareTo(BigInteger.ZERO) <= 0 || timestampDate == null) {
                        throw new MPSException(2);
                    }
                    if (!system.extEportPayTime || payTimeDate != null) break;
                    throw new MPSException(2);
                }
                case 4: {
                    if (mpsRequest.getTransId() != null && this.parseBigInteger(mpsRequest.getTransId()).compareTo(BigInteger.ZERO) > 0 && timestampDate != null) break;
                    throw new MPSException(2);
                }
                case 3: {
                    if (mpsRequest.getTransId() != null && this.parseBigInteger(mpsRequest.getTransId()).compareTo(BigInteger.ZERO) > 0 && timestampDate != null) break;
                    throw new MPSException(2);
                }
                default: {
                    throw new MPSException(2);
                }
            }
            switch (mpsRequest.getAction()) {
                case 1: 
                case 2: {
                    if (system.numberPattern == null || system.numberPattern.matcher(mpsRequest.getRawNumber()).matches()) break;
                    throw new MPSException(2);
                }
            }
            for (String name : parameterNames) {
                String[] values;
                if ("sign".equals(name) || (values = request.getParameterValues(name)) == null) continue;
                for (String value : values) {
                    sb.append(name).append("=");
                    sb.append(EPortTransactionManager.enc(value));
                    sb.append('&');
                }
            }
            if (reqHash == null) {
                throw new MPSException(2);
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            Signature sign = Signature.getInstance("MD5withRSA");
            sign.initVerify(system.publicKey);
            String data = sb.toString();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("MPS.eport: answer request sign data: " + data);
            }
            sign.update(data.getBytes("cp1251"));
            try {
                myHash = new BigInteger(reqHash, 16).toByteArray();
            }
            catch (Exception e) {
                myHash = null;
            }
            if (myHash == null) {
                throw new MPSException(2);
            }
            if (!sign.verify(myHash)) {
                throw new MPSException(10);
            }
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
            throw new MPSException(-1);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new MPSException(-1);
        }
        return mpsRequest;
    }

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest httpRequest, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.getParameters().put("request", httpRequest);
        mpsResponse.setResult(-1);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, httpRequest);
            this.checkValid(system, mpsRequest, con);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.setTransId(mpsRequest.getTransId());
            mpsResponse.setTime(mpsRequest.getTime());
            mpsResponse.setTimeString(mpsRequest.getTimeString());
            mpsResponse.comment = mpsRequest.getComment();
            mpsResponse.setNumber(mpsRequest.getNumber());
            mpsResponse.setSum(mpsRequest.getSum());
            switch (mpsRequest.getAction()) {
                case 1: {
                    Contract contract = this.actionCheck(mpsRequest);
                    mpsResponse.setMessage(this.getComment(system, conf, con, contract));
                    mpsResponse.setLocalTime(new Date());
                    mpsResponse.setResult(0);
                    break;
                }
                case 2: 
                case 10: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction != null && !transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setResult(14);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0435\u0441\u0442\u044c \u0432 \u0431\u0430\u0437\u0435, \u043d\u043e \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                        mpsResponse.setLocalTime(new Date());
                        break;
                    }
                    if (transaction == null) {
                        Contract contract = this.actionCheck(mpsRequest);
                        this.checkTime(mpsRequest);
                        transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                        mpsResponse.setResult(0);
                    } else {
                        mpsResponse.setResult(25);
                        Contract contract = new ContractManager(con).getContractById(transaction.getContractId());
                        if (contract != null) {
                            mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                        }
                    }
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                    break;
                }
                case 4: {
                    GregorianCalendar now = new GregorianCalendar();
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), now.getTime());
                    if (transaction == null) {
                        mpsResponse.setResult(26);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                        mpsResponse.setLocalTime(new Date());
                        break;
                    }
                    if (transaction.getStatus().equals(TransactionStatus.PAYMENT_CANCELED.getCode()) || transaction.getStatus().equals(TransactionStatus.PAYMENT_CANCELED.getCode())) {
                        mpsResponse.setResult(27);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0443\u0436\u0435 \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                        mpsResponse.setLocalTime(new Date());
                        break;
                    }
                    ((Calendar)now).add(12, -10);
                    if (transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode()) && now.after(transaction.getLocalTime())) {
                        mpsResponse.setResult(28);
                        mpsResponse.setMessage("\u0418\u0437\u0432\u0438\u043d\u0438\u0442\u0435. \u0412\u0440\u0435\u043c\u044f \u0434\u043b\u044f \u043e\u0442\u043c\u0435\u043d\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0432\u044b\u0448\u043b\u043e");
                        mpsResponse.setLocalTime(new Date());
                        break;
                    }
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                    this.cancelTransaction(con, moduleId, mpsId, system, transaction);
                    mpsResponse.setResult(1);
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                    break;
                }
                case 3: {
                    GregorianCalendar now = new GregorianCalendar();
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), now.getTime());
                    if (transaction == null) {
                        now.set(5, 1);
                        ((Calendar)now).add(2, -1);
                        transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), now.getTime());
                    }
                    if (transaction == null) {
                        mpsResponse.setResult(26);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
                        break;
                    }
                    if (!transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setResult(1);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                    } else {
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0431\u044b\u043b \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
                    }
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                    mpsResponse.setSum(transaction.getSum());
                    mpsResponse.setNumber(transaction.getRawNumber());
                    mpsResponse.setTime(transaction.getTime());
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    private String result(int result) {
        switch (result) {
            case 11: {
                return "E1";
            }
            case 12: {
                return "E2";
            }
            case 13: {
                return "E3";
            }
            case 14: {
                return "E4";
            }
            case 0: {
                return "S1";
            }
            case 1: {
                return "S2";
            }
            case 21: {
                return "F1";
            }
            case 22: {
                return "F2";
            }
            case 23: {
                return "F3";
            }
            case 24: {
                return "F4";
            }
            case 25: {
                return "F5";
            }
            case 26: {
                return "F6";
            }
            case 27: {
                return "F7";
            }
            case 28: {
                return "F8";
            }
        }
        return null;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse mpsResponse) {
        mpsResponse.getResponse().setContentType("application/x-www-form-urlencoded");
        mpsResponse.getResponse().setCharacterEncoding("UTF-8");
        String result = this.result(mpsResponse.getResult());
        TreeMap<Object, List<String>> answer = new TreeMap<Object, List<String>>();
        try {
            PrivateKey privateKey;
            if (mpsResponse.getAction() == 1 || mpsResponse.getAction() == 10) {
                if (mpsResponse.getNumber() != null) {
                    answer.put("account", Collections.singletonList(EPortTransactionManager.enc(mpsResponse.getNumber())));
                }
                if (mpsResponse.getResult() != 0 && mpsResponse.getResult() != 1) {
                    answer.put("reason", Collections.singletonList(mpsResponse.getMessage() != null ? EPortTransactionManager.enc(mpsResponse.getMessage()) : ""));
                }
                answer.put("result", Collections.singletonList(result));
                if (mpsResponse.getSum() != null && mpsResponse.getSum().compareTo(BigDecimal.ZERO) != 0) {
                    answer.put("sum", Collections.singletonList(EPortTransactionManager.enc(Utils.formatCost((BigDecimal)mpsResponse.getSum()))));
                }
                answer.put("type", Collections.singletonList("check"));
            } else if (mpsResponse.getAction() == 2) {
                if (mpsResponse.getNumber() != null) {
                    answer.put("account", Collections.singletonList(EPortTransactionManager.enc(mpsResponse.getNumber())));
                }
                if (mpsResponse.getLocalTime() != null && mpsResponse.getResult() == 0) {
                    answer.put("accepted", Collections.singletonList(EPortTransactionManager.enc(EPortTransactionManager.formatDate(mpsResponse.getLocalTime()))));
                }
                if (mpsResponse.getTransId() != null && this.parseBigInteger(mpsResponse.getTransId()).compareTo(BigInteger.ZERO) > 0) {
                    answer.put("id", Collections.singletonList(String.valueOf(mpsResponse.getTransId())));
                }
                if (mpsResponse.getResult() != 0 && mpsResponse.getResult() != 1) {
                    answer.put("reason", Collections.singletonList(mpsResponse.getMessage() != null ? EPortTransactionManager.enc(mpsResponse.getMessage()) : ""));
                }
                answer.put("result", Collections.singletonList(result));
                if (mpsResponse.getSum() != null && mpsResponse.getSum().compareTo(BigDecimal.ZERO) != 0) {
                    answer.put("sum", Collections.singletonList(EPortTransactionManager.enc(Utils.formatCost((BigDecimal)mpsResponse.getSum()))));
                }
                answer.put("type", Collections.singletonList("payment"));
            } else if (mpsResponse.getAction() == 3) {
                if (mpsResponse.getLocalTime() != null && mpsResponse.getResult() == 0) {
                    answer.put("accepted", Collections.singletonList(EPortTransactionManager.enc(EPortTransactionManager.formatDate(mpsResponse.getLocalTime()))));
                }
                if (mpsResponse.getLocalTime() != null && mpsResponse.getResult() == 1) {
                    answer.put("revoked", Collections.singletonList(EPortTransactionManager.enc(EPortTransactionManager.formatDate(mpsResponse.getLocalTime()))));
                }
                if (mpsResponse.getTime() != null && (mpsResponse.getResult() == 0 || mpsResponse.getResult() == 1)) {
                    answer.put("pay_time", Collections.singletonList(EPortTransactionManager.enc(EPortTransactionManager.formatDate(mpsResponse.getTime()))));
                }
                if (mpsResponse.getNumber() != null) {
                    answer.put("account", Collections.singletonList(EPortTransactionManager.enc(mpsResponse.getNumber())));
                }
                if (mpsResponse.getTransId() != null && this.parseBigInteger(mpsResponse.getTransId()).compareTo(BigInteger.ZERO) > 0) {
                    answer.put("id", Collections.singletonList(String.valueOf(mpsResponse.getTransId())));
                }
                if (mpsResponse.getResult() != 0 && mpsResponse.getResult() != 1) {
                    answer.put("reason", Collections.singletonList(mpsResponse.getMessage() != null ? EPortTransactionManager.enc(mpsResponse.getMessage()) : ""));
                }
                answer.put("result", Collections.singletonList(result));
                if (mpsResponse.getSum() != null && mpsResponse.getSum().compareTo(BigDecimal.ZERO) != 0) {
                    answer.put("sum", Collections.singletonList(EPortTransactionManager.enc(Utils.formatCost((BigDecimal)mpsResponse.getSum()))));
                }
                answer.put("type", Collections.singletonList("status"));
            } else if (mpsResponse.getAction() == 4) {
                if (mpsResponse.comment != null) {
                    answer.put("comment", Collections.singletonList(EPortTransactionManager.enc(mpsResponse.comment)));
                }
                if (mpsResponse.getTransId() != null && this.parseBigInteger(mpsResponse.getTransId()).compareTo(BigInteger.ZERO) > 0) {
                    answer.put("id", Collections.singletonList(String.valueOf(mpsResponse.getTransId())));
                }
                if (mpsResponse.getResult() != 0 && mpsResponse.getResult() != 1) {
                    answer.put("reason", Collections.singletonList(mpsResponse.getMessage() != null ? EPortTransactionManager.enc(mpsResponse.getMessage()) : ""));
                }
                answer.put("result", Collections.singletonList(result));
                if (mpsResponse.getLocalTime() != null && mpsResponse.getResult() == 1) {
                    answer.put("revoked", Collections.singletonList(EPortTransactionManager.enc(EPortTransactionManager.formatDate(mpsResponse.getLocalTime()))));
                }
                answer.put("type", Collections.singletonList("revoke"));
            } else {
                if (mpsResponse.getResult() != 0 && mpsResponse.getResult() != 1) {
                    answer.put("reason", Collections.singletonList(mpsResponse.getMessage() != null ? EPortTransactionManager.enc(mpsResponse.getMessage()) : ""));
                }
                answer.put("result", Collections.singletonList(result));
            }
            if (mpsResponse.getResult() != 11 && mpsResponse.getResult() != 12 && mpsResponse.getResult() != 13) {
                HttpServletRequest httpRequest = (HttpServletRequest)mpsResponse.getParameters().get("request");
                ArrayList<Object> arrayList = Collections.list(httpRequest.getParameterNames());
                for (Object name : arrayList) {
                    String[] values;
                    if ("sign".equals(name) || answer.containsKey(name) || (values = httpRequest.getParameterValues((String)name)) == null) continue;
                    ArrayList<String> list = new ArrayList<String>();
                    for (String value : values) {
                        list.add(EPortTransactionManager.enc(value));
                    }
                    answer.put(name, list);
                }
            }
            StringBuilder sb = new StringBuilder(150);
            for (Map.Entry entry : answer.entrySet()) {
                String name = (String)entry.getKey();
                for (String value : (List)entry.getValue()) {
                    sb.append(name).append("=").append(value).append("&");
                }
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            if ((privateKey = system.getPrivateKey()) == null) {
                this.getLogger().error("MPS: Server private key is null!");
            }
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initSign(privateKey);
            String data = sb.toString();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("MPS.eport: answer sign data: " + data);
            }
            signature.update(sb.toString().getBytes("cp1251"));
            String hash = EPortTransactionManager.bytesToString(signature.sign());
            sb.append("&sign=");
            sb.append(hash);
            return sb.toString().getBytes();
        }
        catch (GeneralSecurityException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return "".getBytes();
    }

    private static String formatDate(Date date) {
        String result = TimeUtils.format((Date)date, (String)TIMEPATTERN);
        return result.substring(0, 22);
    }

    private static Date parseDate(String time, Calendar calendar) {
        if (time != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(TIMEPATTERN);
            try {
                if (((String)time).length() == 22) {
                    time = (String)time + "00";
                }
                Date date = sdf.parse((String)time);
                return date;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected static Calendar parseCalendar2(String time, Calendar calendar) {
        SimpleDateFormat sdf = new SimpleDateFormat(TIMEPATTERN);
        try {
            if (((String)time).length() == 22 || ((String)time).length() == 24 || ((String)time).length() == 25) {
                time = (String)time + "00";
            }
            Date date = sdf.parse((String)time);
            int offset = sdf.getCalendar().get(15);
            GregorianCalendar result = new GregorianCalendar();
            result.setTime(date);
            result.set(15, offset - calendar.get(15));
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected static Calendar parseCalendar3(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat(TIMEPATTERN2);
        try {
            if (time.length() == 22 || time.length() == 24 || time.length() == 25) {
                time = time.substring(0, 19);
            }
            Date date = sdf.parse(time);
            GregorianCalendar result = new GregorianCalendar();
            result.setTime(date);
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void main(String[] arsgs) throws Exception {
        System.out.println(TimeUtils.format((Date)EPortTransactionManager.parseDate("2009-03-19T12:54:45+03", new GregorianCalendar()), (String)"HH:mm:ss"));
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(11);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(23);
                response.setMessage(ex.message);
                break;
            }
            case 6: {
                response.setResult(11);
                response.setMessage(ex.message);
                break;
            }
            case 8: {
                response.setResult(22);
                response.setMessage("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430");
                break;
            }
            case -1: {
                response.setResult(12);
                response.setMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                break;
            }
            case 9: {
                response.setResult(12);
                response.setMessage(ex.message);
                break;
            }
            case 10: {
                response.setResult(13);
                response.setMessage(ex.message);
                break;
            }
            case 11: {
                response.setResult(28);
                response.setMessage(ex.message);
                break;
            }
            case 20: {
                response.setResult(24);
                response.setMessage(ex.message);
            }
        }
    }

    @Override
    protected void checkValid(Conf.MPSSystem system, MPSRequest req, Connection con) throws MPSException {
        super.checkValid(system, req, con);
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    public String getDefaultEncoding() {
        return "windows-1251";
    }

    private static String bytesToString(byte[] value) {
        StringBuilder sb = new StringBuilder(value.length * 2);
        if (value != null) {
            for (int i = 0; i < value.length; ++i) {
                sb.append(Utils.HEX[(value[i] & 0xF0) >> 4]);
                sb.append(Utils.HEX[value[i] & 0xF]);
            }
        }
        return sb.toString();
    }

    private class ErrorCode {
        private static final String ANSWER_ERR_REQUEST = "E1";
        private static final int ANSWER_ERR_REQUEST_INT = 11;
        private static final String ANSWER_ERR_REQUEST_2 = "E2";
        private static final int ANSWER_ERR_REQUEST_2_INT = 12;
        private static final String ANSWER_ERR_SIGN = "E3";
        private static final int ANSWER_ERR_SIGN_INT = 13;
        private static final String ANSWER_ERR_OPERATION = "E4";
        private static final int ANSWER_ERR_OPERATION_INT = 14;
        private static final String ANSWER_SUCESS = "S1";
        private static final int ANSWER_SUCESS_INT = 0;
        private static final String ANSWER_CANCEL_SUCESS = "S2";
        private static final int ANSWER_CANCEL_SUCESS_INT = 1;
        private static final String ANSWER_ERR_SUMM_TO_SMALL = "F1";
        private static final int ANSWER_ERR_SUMM_TO_SMALL_INT = 21;
        private static final String ANSWER_ERR_SUMM_TO_BIG = "F2";
        private static final int ANSWER_ERR_SUMM_TO_BIG_INT = 22;
        private static final String ANSWER_ERR_CONTRACT_NOT_FOUND = "F3";
        private static final int ANSWER_ERR_CONTRACT_NOT_FOUND_INT = 23;
        private static final String ANSWER_ERR_CONTRACT_BLOCKED = "F4";
        private static final int ANSWER_ERR_CONTRACT_BLOCKED_INT = 24;
        private static final String ANSWER_ERR_ALREADY_PAYMENT = "F5";
        private static final int ANSWER_ERR_ALREADY_PAYMENT_INT = 25;
        private static final String ANSWER_ERR_PAYMENT_NOT_FOUND = "F6";
        private static final int ANSWER_ERR_PAYMENT_NOT_FOUND_INT = 26;
        private static final String ANSWER_ERR_ALREADY_CANCELED = "F7";
        private static final int ANSWER_ERR_ALREADY_CANCELED_INT = 27;
        private static final String ANSWER_ERR_CANT_CANCEL = "F8";
        private static final int ANSWER_ERR_CANT_CANCEL_INT = 28;

        private ErrorCode(EPortTransactionManager ePortTransactionManager) {
        }
    }
}

