/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.license.server.service;

import bitel.billing.common.SummaToString;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractUtils;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.admin.mail.server.MailMsg;
import ru.bitel.bgbilling.kernel.admin.mail.server.bean.MailData;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.license.common.OrderUtils;
import ru.bitel.bgbilling.modules.license.common.bean.AdditionalAgreement;
import ru.bitel.bgbilling.modules.license.common.bean.ContractData;
import ru.bitel.bgbilling.modules.license.common.bean.License;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponent;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseComponentPrice;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseCopy;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrder;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderBillData;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderConfirmed;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderPermanentNew;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseOrderTestNew;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseProduct;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseStatData;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseTariffGroup;
import ru.bitel.bgbilling.modules.license.common.bean.LicenseTariffRange;
import ru.bitel.bgbilling.modules.license.common.bean.SpecificationTitle;
import ru.bitel.bgbilling.modules.license.common.bean.enums.LicenseOrderType;
import ru.bitel.bgbilling.modules.license.common.service.LicenseService;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseComponentDao;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseManager;
import ru.bitel.bgbilling.modules.license.server.bean.LicensePriceDao;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseProductDao;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseTariffGroupDao;
import ru.bitel.bgbilling.modules.license.server.bean.LicenseTariffRangeDao;
import ru.bitel.bgbilling.modules.license.server.event.AddAdditionalAgreementEvent;
import ru.bitel.bgbilling.modules.license.server.event.RemoveAdditionalAgreementEvent;
import ru.bitel.bgbilling.modules.license.server.event.SignAdditionalAgreementEvent;
import ru.bitel.bgbilling.modules.license.server.mail.MailLicenseCreate;
import ru.bitel.bgbilling.modules.license.server.mail.MailOrderCreate;
import ru.bitel.bgbilling.modules.license.server.utils.LicenseUtils;
import ru.bitel.bgbilling.plugins.documents.common.bean.Document;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentPattern;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentTableExtractMethod;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsPatternService;
import ru.bitel.bgbilling.plugins.documents.common.service.DocumentsService;
import ru.bitel.bgbilling.plugins.documents.server.bean.pattern.DocumentsPatternGenerator;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.license.common.service.LicenseService")
public class LicenseServiceImpl
extends AbstractService
implements LicenseService {
    private LicenseManager licenseManager;
    private LicenseProductDao licenseProductDao;
    private LicenseComponentDao licenseComponentDao;
    private LicenseTariffGroupDao licenseTariffGroupDao;
    private LicenseTariffRangeDao licenseTariffRangeDao;

    @PostConstruct
    void init() {
        this.licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        this.licenseProductDao = new LicenseProductDao(this.getConnection(), this.moduleId);
        this.licenseComponentDao = new LicenseComponentDao(this.getConnection(), this.moduleId);
        this.licenseTariffGroupDao = new LicenseTariffGroupDao(this.getConnection(), this.moduleId);
        this.licenseTariffRangeDao = new LicenseTariffRangeDao(this.getConnection(), this.moduleId);
    }

    public List<LicenseCopy> copyList(int contractId) throws BGException {
        return this.licenseManager.getCopyList(contractId);
    }

    public LicenseCopy copyGet(int id) throws Exception {
        return this.licenseManager.getCopy(id);
    }

    public int copyUpdate(LicenseCopy copy) throws Exception {
        this.licenseManager.updateCopy(copy);
        return copy.getId();
    }

    public boolean copyDelete(int copyId, int contractId) throws Exception {
        LicenseCopy copy = this.licenseManager.getCopy(copyId);
        if (copy == null) {
            throw new BGMessageException("\u041a\u043e\u043f\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
        }
        if (copy.getContractId() != contractId) {
            throw new BGMessageException("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u0432 \u043a\u043e\u043f\u0438\u0438 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
        }
        List<LicenseOrder> orders = this.licenseManager.getOrders(copyId);
        if (!orders.isEmpty()) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043a\u043e\u043f\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0437\u0430\u043a\u0430\u0437\u044b");
        }
        return this.licenseManager.deleteCopy(copyId);
    }

    public List<LicenseProduct> productList() throws Exception {
        return this.licenseProductDao.list();
    }

    public List<IdTitle> productTitles() throws Exception {
        return this.licenseProductDao.list().stream().map(a -> new IdTitle(a.getId(), a.getTitle() + " [" + a.getVersion() + "]")).toList();
    }

    public List<LicenseProduct> productListWithComponent(int componentId) throws Exception {
        return this.licenseProductDao.getProductsWithComponent(componentId);
    }

    public List<LicenseCopy> productCopyList(int contractId) {
        return this.licenseManager.getCopyList(contractId);
    }

    public List<LicenseOrderConfirmed> confirmedOrderList(int contractId, int copyId, int filter) throws BGException {
        if (!this.copyList(contractId).stream().anyMatch(a -> a.getId() == copyId)) {
            throw new BGIllegalArgumentException("copyId");
        }
        return this.licenseManager.getCopyItems(copyId, filter);
    }

    public List<License> licenseList(int contractId, int copyId) throws Exception {
        LicenseCopy copy = this.licenseManager.getCopy(copyId);
        if (copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("copyId");
        }
        return this.licenseManager.getLicenses(copyId);
    }

    private Map<String, BigDecimal> getItemsCosts(List<LicenseOrderConfirmed> items, String productVersion) {
        String url = LicenseUtils.buildLicenseCostUrlRequest(items, productVersion, (ParameterMap)this.getModuleSetup());
        return LicenseUtils.getCosts(url);
    }

    public List<LicenseOrderConfirmed> licenseComponentList(int contractId, int licenseId) throws BGException, BGIllegalArgumentException {
        License license = this.licenseManager.getLicenseById(licenseId);
        LicenseCopy copy = this.licenseManager.getCopy(license.getCopyId());
        if (copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("licenseId");
        }
        List<LicenseOrderConfirmed> result = this.licenseManager.getLicenseItems(licenseId, false);
        Map<String, BigDecimal> licenseItemCosts = this.getItemsCosts(result, copy.getProductVersion());
        for (LicenseOrderConfirmed item : result) {
            BigDecimal itemCost = licenseItemCosts.get(item.getComponentName());
            if (itemCost == null || item.getType() == LicenseOrderType.TEST.getCode()) {
                itemCost = BigDecimal.ZERO;
            }
            item.setCost(itemCost);
        }
        return result;
    }

    public int licenseCreate(int contractId, int copyId, Set<String> confirmedOrderIds_, boolean customer) throws Exception {
        String receiverEmail;
        Set confirmedOrderIds = confirmedOrderIds_.stream().map(a -> Utils.toIntegerSet((String)a)).collect(Collectors.toSet());
        List<LicenseOrderConfirmed> currentConfirmedOrderList = this.confirmedOrderList(contractId, copyId, 2);
        Map<Set, LicenseOrderConfirmed> currentConfirmedOrderMap = currentConfirmedOrderList.stream().collect(Collectors.toMap(k -> Utils.toIntegerSet((String)k.getIds()), v -> v));
        if (!currentConfirmedOrderMap.keySet().containsAll(confirmedOrderIds)) {
            throw new BGIllegalArgumentException("confirmedComponentIds");
        }
        currentConfirmedOrderMap.keySet().retainAll(confirmedOrderIds);
        ArrayList<LicenseOrderConfirmed> confirmedOrderList = new ArrayList<LicenseOrderConfirmed>(currentConfirmedOrderMap.values());
        int[] componentIds = new int[confirmedOrderList.size()];
        int i = 0;
        HashSet<Integer> componentIdCheckSet = new HashSet<Integer>();
        for (LicenseOrderConfirmed confirmedOrder : confirmedOrderList) {
            if (!componentIdCheckSet.add(confirmedOrder.getComponentId())) {
                throw new BGMessageException("\u041b\u0438\u0446\u0435\u043d\u0437\u0438\u044f \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0432\u043a\u043b\u044e\u0447\u0430\u0442\u044c \u043e\u0434\u0438\u043d\u0430\u043a\u043e\u0432\u044b\u0435 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u044b.", "confirmedComponentIds.componentIntersection");
            }
            for (Object orderId : Utils.toIntegerSet((String)confirmedOrder.getIds())) {
                if (this.licenseManager.checkCopyItemStatus((Integer)orderId)) continue;
                throw new BGMessageException("\u0421\u0442\u0430\u0442\u0443\u0441 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043d\u0435 \u043f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0432\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0438\u0445 \u0432 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e.", "confirmedComponentIds.status");
            }
            componentIds[i++] = confirmedOrder.getComponentId();
        }
        Set ids = confirmedOrderIds.stream().reduce(new HashSet(), (a, b) -> {
            a.addAll(b);
            return a;
        });
        int[] idsa = new int[ids.size()];
        int c = 0;
        for (Integer id : ids) {
            idsa[c++] = id;
        }
        License license = new License();
        license.setCopyId(copyId);
        license.setUserId(this.userId);
        license.setCopyItemIds(idsa);
        license.setData("");
        license.setOriginalData("");
        int licenseId = this.licenseManager.createLicense(license);
        LicenseCopy copy = this.licenseManager.getCopy(copyId);
        List<LicenseOrderConfirmed> licenseItems = this.licenseManager.getLicenseItems(license.getId(), true);
        String licText = LicenseUtils.getLicenseText(licenseItems, this.licenseManager, contractId, (Preferences)this.getModuleSetup(), copy);
        if (Utils.isBlankString((String)licText)) {
            throw new BGIllegalAccessException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0442\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        license.setOriginalData(licText);
        try {
            license.setData(LicenseUtils.encryptLicenseText(licText, (Preferences)this.getModuleSetup()));
        }
        catch (IOException e) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0448\u0438\u0444\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        if (Utils.isBlankString((String)license.getData())) {
            throw new BGIllegalAccessException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        this.licenseManager.updateLicenseData(license);
        if (customer && "true".equals(this.getModuleSetup().get("license.create.email.send", "false")) && Utils.notBlankString((String)(receiverEmail = this.getModuleSetup().get("license.bills.email.to", "")))) {
            try {
                bitel.billing.server.contract.bean.Contract contract = new ContractManager(this.getConnection()).getContractById(contractId);
                MailData mailData = new MailLicenseCreate().setModuleId(this.moduleId).setRecipients(receiverEmail).setSubject("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438").addTextPart("text", "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + contract.getTitle() + " \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043b \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u044e.");
                new MailMsg((Preferences)this.getSetup()).sendMessage(mailData);
            }
            catch (Exception ex) {
                LogManager.getLogger().error((Object)ex);
            }
        }
        return licenseId;
    }

    public int createPackage(int contractId, int copyId, Set<String> confirmedOrderIds) throws BGException, BGMessageException, BGIllegalArgumentException {
        int[] ids = confirmedOrderIds.stream().mapToInt(a -> Utils.parseInt((String)a)).toArray();
        License license = new License();
        license.setCopyId(copyId);
        license.setUserId(this.userId);
        license.setCopyItemIds(ids);
        license.setData("");
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        LicenseCopy copy = licenseManager.getCopy(copyId);
        int packageId = licenseManager.createLicense(license);
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        List<LicenseOrderConfirmed> licenseItems = licenseManager.getLicenseItems(license.getId(), true);
        String licText = LicenseUtils.getLicenseText(licenseItems, licenseManager, contractId, (Preferences)moduleSetup, copy);
        if (!Utils.notBlankString((String)licText)) {
            throw new BGIllegalAccessException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0442\u0438\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        license.setOriginalData(licText);
        String encryptedLicense = "";
        try {
            encryptedLicense = LicenseUtils.encryptLicenseText(licText, (Preferences)moduleSetup);
        }
        catch (IOException e) {
            throw new BGException("error while license encrypting", (Throwable)e);
        }
        if (Utils.isBlankString((String)encryptedLicense)) {
            throw new BGIllegalAccessException("\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438.");
        }
        license.setData(encryptedLicense);
        licenseManager.updateLicenseData(license);
        return packageId;
    }

    public void prolongTestOrders(int contractId, Date dateTo, List<Integer> ids) throws BGException, BGMessageException, BGIllegalArgumentException {
        if (ids.size() == 0) {
            throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u044b \u0437\u0430\u043a\u0430\u0437\u044b");
        }
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        for (int condirmedOrderId : ids) {
            int orderId;
            LicenseOrder order;
            if (condirmedOrderId <= 0 || (order = licenseManager.getOrder(orderId = licenseManager.getOrderIdFromConfirmedId(condirmedOrderId))) == null || order.getType() != LicenseOrderType.TEST) continue;
            Date createDate = order.getCreateDate();
            int term = TimeUtils.daysDelta((Date)createDate, (Date)dateTo);
            order.setTerm(term);
            licenseManager.updateCopyItemOrder(order, false);
            licenseManager.updateTestComponentDateTo(condirmedOrderId, dateTo);
        }
    }

    public LicenseOrder orderGet(int orderId) throws BGException {
        if (orderId <= 0) {
            throw new BGIllegalArgumentException();
        }
        return this.licenseManager.getOrder(orderId);
    }

    public void orderUpdate(LicenseOrder order) throws BGException {
        if (order.getType() == LicenseOrderType.BUY) {
            boolean deny = true;
            if (order.getId() > 0) {
                LicenseOrder oldOrder = this.licenseManager.getOrder(order.getId());
                boolean bl = deny = oldOrder == null || !order.isRealyEquals(oldOrder);
            }
            if (deny && this.licenseManager.checkHaveNonSignAdditionalAgreement(order.getCopyId())) {
                throw new BGMessageException("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435/\u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e. \u0415\u0441\u0442\u044c \u043d\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u043e\u0435 \u0434\u043e\u043f.\u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435.");
            }
            order.setTerm(0);
        }
        order.setUserId(this.userId);
        if (this.illegalArguments(order)) {
            throw new BGIllegalArgumentException();
        }
        this.licenseManager.updateCopyItemOrder(order);
    }

    public void orderDelete(int orderId) throws Exception {
        LicenseOrder order = this.licenseManager.getOrder(orderId);
        if (order == null) {
            throw new BGIllegalArgumentException();
        }
        if (order.getType() == LicenseOrderType.BUY && this.licenseManager.checkHaveNonSignAdditionalAgreement(order.getCopyId())) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e. \u0415\u0441\u0442\u044c \u043d\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u043e\u0435 \u0434\u043e\u043f. \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435.");
        }
        if (order.getStatus() != 0) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u044f\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0430\u0437\u044b \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043d\u043e\u0432\u044b\u0439\".");
        }
        this.licenseManager.deleteOrder(orderId);
    }

    public List<LicenseStatData> doStatData(int productId) throws Exception {
        LicenseStatData statData;
        ArrayList<LicenseStatData> statDataList = new ArrayList<LicenseStatData>();
        for (LicenseComponent component : this.licenseComponentDao.listForProduct(productId)) {
            statData = new LicenseStatData();
            statData.setComponent(component);
            statDataList.add(statData);
        }
        Map<Integer, int[]> componentCopyMap = this.licenseManager.getCopyCountForComponentByProductMap(productId);
        Iterator iterator = statDataList.iterator();
        while (iterator.hasNext()) {
            int[] counters = componentCopyMap.get((statData = (LicenseStatData)iterator.next()).getComponent().getId());
            statData.setCopyCount(counters == null ? 0 : counters[0]);
            statData.setUnlimCount(counters == null ? 0 : counters[1]);
            statData.setLicCount(counters == null ? 0 : counters[2]);
        }
        return statDataList;
    }

    public List<ContractData> doContractData(int productId, int componentId) throws BGException {
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        return licenseManager.doContractData(productId, componentId);
    }

    private boolean illegalArguments(LicenseOrder order) {
        return order.getCopyId() <= 0 || order.getComponentId() <= 0 || order.getCount() < 0 || order.getType().getCode() < 0 || order.getStatus() < 0 || order.getTerm() < 0 || order.getTerm() == 0 && order.getType() == LicenseOrderType.TEST;
    }

    public String getProductLinks(int productId) throws Exception {
        JSONArray links = new JSONArray();
        if (productId > 0) {
            List<LicenseComponent> selectedProductItems = this.licenseComponentDao.listForProduct(productId);
            List<LicenseComponent> allProductItems = this.licenseComponentDao.list();
            for (LicenseComponent component : allProductItems) {
                JSONObject link = new JSONObject().put("id", component.getId()).put("title", (Object)component.getTitle()).put("select", this.isSelected(component, selectedProductItems));
                links.put((Object)link);
            }
        }
        return links.toString();
    }

    public String getProductItemLinks(int productItemId) throws Exception {
        JSONArray links = new JSONArray();
        if (productItemId > 0) {
            List<LicenseProduct> allProducts = this.licenseProductDao.list();
            List<LicenseProduct> selectedProducts = this.licenseProductDao.getProductsWithComponent(productItemId);
            for (LicenseProduct product : allProducts) {
                JSONObject link = new JSONObject().put("id", product.getId()).put("title", (Object)(product.getTitle() + " " + product.getVersion())).put("select", this.isSelected(product, selectedProducts));
                links.put((Object)link);
            }
        }
        return links.toString();
    }

    private boolean isSelected(LicenseComponent productItem, List<LicenseComponent> selectedProductItems) {
        for (LicenseComponent selectedItem : selectedProductItems) {
            if (selectedItem.getId() != productItem.getId()) continue;
            return true;
        }
        return false;
    }

    private boolean isSelected(LicenseProduct product, List<LicenseProduct> selectedProducts) {
        for (LicenseProduct selectedProduct : selectedProducts) {
            if (selectedProduct.getId() != product.getId()) continue;
            return true;
        }
        return false;
    }

    public List<LicenseComponent> productAllLicenseComponents() throws Exception {
        return this.licenseComponentDao.list();
    }

    public List<LicenseComponent> productLicenseComponents(int productId) throws Exception {
        return this.licenseComponentDao.listForProduct(productId);
    }

    public String sendLicenseTextByEmail(int contractId, int copyId, String email, String licenseText) throws BGException, BGMessageException {
        LicenseManager licenseManager;
        LicenseCopy copy;
        StringBuilder subject = new StringBuilder("\u0422\u0435\u043a\u0441\u0442 \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0438");
        if (copyId > 0 && (copy = (licenseManager = new LicenseManager(this.getConnection(), this.moduleId)).getCopy(copyId)) != null) {
            subject.append(" \u043d\u0430 " + copy.getProductTitle());
        }
        if (contractId > 0) {
            try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
                Contract contract = (Contract)contractDao.get(contractId);
                subject.append(" \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 " + contract.getTitle() + "[" + contract.getComment() + "].");
            }
        }
        return LicenseUtils.sendLiceneseText(email, licenseText, subject.toString(), this.moduleId);
    }

    public List<LicenseOrder> getOrders(int copyId, String testFilter, String permanentFilter, int componentFilter) throws BGException {
        List filterPermanentStatus = Utils.toIntegerList((String)permanentFilter);
        List filterTestStatus = Utils.toIntegerList((String)testFilter);
        if (copyId <= 0) {
            throw new BGIllegalArgumentException();
        }
        String permanentFS = Utils.toString((List)filterPermanentStatus, (int)0);
        permanentFS = permanentFS.replaceAll(",0", "");
        String testFS = Utils.toString((List)filterTestStatus, (int)0);
        testFS.replaceAll(",0", "");
        List<LicenseOrder> list = null;
        if (!Utils.isBlankString((String)testFS) || !Utils.isBlankString((String)permanentFS)) {
            list = this.licenseManager.getOrders(copyId, permanentFS, testFS, componentFilter);
            for (LicenseOrder order : list) {
                if (order.getUserId() != 0) continue;
                order.setUserName("-");
            }
        }
        return list;
    }

    public List<LicenseOrder> getOrdersList(int copyId, int type, int status, int componentId) throws BGException {
        return this.licenseManager.getOrders(copyId, Stream.of(LicenseOrderType.getOrderTypeByCode((int)type)).toList(), Stream.of(Integer.valueOf(status)).toList(), componentId);
    }

    public List<LicenseComponent> getComponentItems(int copyId, boolean showHidden, boolean customer) throws Exception {
        if (copyId < 0) {
            return this.licenseComponentDao.list();
        }
        return this.licenseComponentDao.list(copyId, showHidden, customer ? Boolean.valueOf(true) : null);
    }

    public BigDecimal getCostComponent(String componentName, int count, int copyId) throws BGException {
        LicenseCopy copy = this.licenseManager.getCopy(copyId);
        String productVersion = copy.getProductVersion();
        float floatCost = LicenseUtils.getCost(LicenseUtils.buildLicenseCostUrlRequest(componentName, count, productVersion, (Preferences)Setup.getSetup()), null);
        return new BigDecimal(Float.toString(floatCost));
    }

    public Integer getCountOrderedComponents(String componentName, int copyId) throws BGException {
        List<LicenseOrder> listOrder = this.licenseManager.getOrders(copyId, "2", null, -1);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Collections.reverse(listOrder);
        for (LicenseOrder order : listOrder) {
            String name = order.getComponentName();
            if (!componentName.equals(name)) continue;
            if (map.containsKey(name)) {
                if (order.getCount() == 0) {
                    map.put(name, 0);
                    continue;
                }
                if ((Integer)map.get(name) == 0) {
                    return null;
                }
                map.put(name, order.getCount() + (Integer)map.get(name));
                continue;
            }
            map.put(order.getComponentName(), order.getCount());
        }
        return map.get(componentName) == null ? -1 : (Integer)map.get(componentName);
    }

    public List<LicenseOrderPermanentNew> getNewPermanentOrders(int copyId) throws Exception {
        return this.convertPermanent(this.licenseManager.getOrders(copyId, "0", null, -1), copyId);
    }

    public List<LicenseOrderTestNew> getNewTestOrders(int copyId) throws Exception {
        return this.convertTest(this.licenseManager.getOrders(copyId, null, "0", -1), copyId);
    }

    private List<LicenseOrderPermanentNew> convertPermanent(List<LicenseOrder> orders, int copyId) throws Exception {
        if (orders == null) {
            return null;
        }
        ArrayList<LicenseOrderPermanentNew> result = new ArrayList<LicenseOrderPermanentNew>();
        int number = 1;
        for (LicenseOrder component : orders) {
            int presentCount = this.getCountOrderedComponents(component.getComponentName(), copyId);
            BigDecimal presentSum = presentCount > -1 ? this.getCostComponent(component.getComponentName(), presentCount, copyId) : BigDecimal.ZERO;
            LicenseOrderPermanentNew order = new LicenseOrderPermanentNew(component.getComponentId(), component.getComponentName(), presentCount, presentSum, this.isComponenetUnlimit(component.getComponentId(), copyId), copyId);
            order.setId(component.getId());
            order.setCount(component.getCount());
            order.setNumber(number++);
            if (order.getCount() == 0) {
                order.setTotalCount(Integer.valueOf(0));
            } else {
                order.setTotalCount(Integer.valueOf(order.getPresentCount() == -1 ? order.getCount() : order.getCount() + order.getPresentCount()));
            }
            BigDecimal totalCost = order.getTotalCount() > -1 ? this.getCostComponent(order.getComponentName(), order.getTotalCount(), copyId) : BigDecimal.ZERO;
            order.setTotalSum(totalCost.setScale(2, RoundingMode.CEILING));
            if (order.getCount() == 0) {
                order.setUnlimited(true);
            }
            result.add(order);
        }
        return result;
    }

    private List<LicenseOrderTestNew> convertTest(List<LicenseOrder> orders, int copyId) throws Exception {
        ArrayList<LicenseOrderTestNew> result = new ArrayList<LicenseOrderTestNew>();
        int number = 1;
        for (LicenseOrder component : orders) {
            LicenseOrderTestNew order = new LicenseOrderTestNew(component.getComponentId(), component.getComponentName(), this.isComponenetUnlimit(component.getComponentId(), copyId), copyId);
            order.setId(component.getId());
            order.setCount(component.getCount());
            if (order.getCount() == 0) {
                order.setUnlimited(true);
            }
            order.setNumber(number++);
            order.setTerm(component.getTerm());
            order.setToDate(TimeUtils.nowPlusPeriod((int)5, (int)component.getTerm()));
            result.add(order);
        }
        return result;
    }

    private boolean isComponenetUnlimit(int componentId, int copyId) throws Exception {
        for (LicenseComponent component : this.getComponentItems(copyId, false, false)) {
            if (component.getId() != componentId) continue;
            return component.getUnlimited() == 1;
        }
        return false;
    }

    public int orderCreate(int contractId, LicenseOrder order, boolean customer) throws BGException {
        if (order.getType().getCode() < 0) {
            throw new BGIllegalArgumentException("order.type");
        }
        if (order.getCount() < 0) {
            throw new BGIllegalArgumentException("order.count");
        }
        if (order.getType() == LicenseOrderType.TEST && order.getTerm() <= 0) {
            throw new BGMessageException("\u0421\u0440\u043e\u043a \u0443\u043a\u0430\u0437\u0430\u043d \u043d\u0435 \u0432\u0435\u0440\u043d\u043e!", "order.term");
        }
        LicenseCopy copy = this.licenseManager.getCopy(order.getCopyId());
        if (copy == null || copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("order.copyId");
        }
        if (order.getType() == LicenseOrderType.BUY && this.licenseManager.checkHaveNonSignAdditionalAgreement(order.getCopyId())) {
            throw new BGMessageException("\u0417\u0430\u043a\u0430\u0437 \u0437\u0430\u043f\u0440\u0435\u0449\u0451\u043d! \\n\u0423 \u0432\u0430\u0441 \u0438\u043c\u0435\u0435\u0442\u0441\u044f \u043d\u0435\u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u043e\u0435 \u0434\u043e\u043f. \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435, \u0435\u0441\u043b\u0438 \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0435\u0433\u043e \u0441\u043e\u0441\u0442\u0430\u0432, \u043f\u043e\u043f\u0440\u043e\u0441\u0438\u0442\u0435 \u043d\u0430\u0441 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c( \u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d \u0441\u0447\u0435\u0442 \u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 ), \u0430 \u0435\u0441\u043b\u0438 \u0432\u044b \u0435\u0433\u043e \u0443\u0436\u0435 \u043e\u043f\u043b\u0430\u0442\u0438\u043b\u0438, \u0442\u043e \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430 \u043d\u0430\u043f\u043e\u043c\u043d\u0438\u0442\u0435 \u043d\u0430\u043c \u0435\u0433\u043e \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u0442\u044c.", "order.create.agreementError");
        }
        this.licenseManager.updateCopyItemOrder(order);
        order = this.licenseManager.getOrder(order.getId());
        if (customer && order != null && order.getType() == LicenseOrderType.TEST) {
            MailMsg message = new MailMsg((Preferences)this.getSetup());
            String recipient = this.getModuleSetup().get("license.bills.email.to", "");
            if (Utils.notBlankString((String)recipient)) {
                ContractUtils cu = new ContractUtils(this.getConnection());
                String text = "\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 " + cu.getContractTitle(contractId, false) + " \u0434\u043e\u0431\u0430\u0432\u0438\u043b \u0437\u0430\u043a\u0430\u0437 \u043d\u0430 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442 \n" + order.getComponentName() + " \u0432 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0435 " + OrderUtils.getCount((Integer)order.getCount()) + " \u043d\u0430 \u0441\u0440\u043e\u043a " + order.getTerm() + " \u0434\u043d\u0435\u0439.";
                try {
                    MailOrderCreate mailData = new MailOrderCreate();
                    mailData.setModuleId(this.moduleId);
                    mailData.setRecipients(recipient);
                    mailData.setSubject("\u0423\u0432\u0435\u0434\u043e\u043c\u043b\u0435\u043d\u0438\u0435 \u043e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0442\u0435\u0441\u0442\u043e\u0432\u043e\u0433\u043e \u0437\u0430\u043a\u0430\u0437\u0430");
                    mailData.addTextPart("text", text);
                    message.sendMessage((MailData)mailData);
                }
                catch (Exception ex) {
                    throw new BGException((Throwable)ex);
                }
            } else {
                this.getLogger().error("Wrong license.bills.email.to value. Can't send email.");
            }
        }
        return order.getId();
    }

    public void ordersCopy(int contractId, int copyId, Set<Integer> orderIds, int term) throws BGException {
        if (orderIds == null || orderIds.size() == 0) {
            throw new BGIllegalArgumentException("orderIds");
        }
        if (term <= 0) {
            throw new BGIllegalArgumentException("term");
        }
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        ArrayList<LicenseOrder> orderList = new ArrayList<LicenseOrder>();
        LicenseCopy copy = licenseManager.getCopy(copyId);
        if (copy == null || copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("copyId");
        }
        for (Integer orderId : orderIds) {
            LicenseOrder order = licenseManager.getOrder(orderId);
            if (order == null) {
                throw new BGIllegalArgumentException("orderIds");
            }
            if (copy.getId() != order.getCopyId()) {
                throw new BGIllegalArgumentException("orderIds");
            }
            if (order.getType() != LicenseOrderType.BUY) {
                throw new BGMessageException("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0430\u0437\u044b \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043d\u043e\u0432\u044b\u0439\" \u0438 \u0442\u0438\u043f\u043e\u043c \"\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0439\".", "orderIds.type.notBuy");
            }
            if (order.getStatus() != 0) {
                throw new BGMessageException("\u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0430\u0437\u044b \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043d\u043e\u0432\u044b\u0439\" \u0438 \u0442\u0438\u043f\u043e\u043c \"\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u044b\u0439\".", "orderIds.status.notNew");
            }
            orderList.add(order);
        }
        for (LicenseOrder order : orderList) {
            LicenseOrderConfirmed grouppedItems = licenseManager.groupCopyItems(order.getComponentId(), order.getCopyId(), new int[]{2, 0});
            licenseManager.createTestCopiesForOrder(order, term, grouppedItems.getCount());
        }
    }

    public List<LicenseOrderBillData> ordersBillDataList(int contractId, int copyId, Set<Integer> orderIds) throws BGException {
        if (orderIds == null || orderIds.size() == 0) {
            throw new BGIllegalArgumentException("orderIds");
        }
        ArrayList<LicenseOrderBillData> result = new ArrayList<LicenseOrderBillData>();
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        ArrayList<LicenseOrder> orderList = new ArrayList<LicenseOrder>();
        LicenseCopy copy = licenseManager.getCopy(copyId);
        if (copy == null || copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("copyId");
        }
        for (Integer orderId : orderIds) {
            LicenseOrder order = licenseManager.getOrder(orderId);
            if (order == null) {
                throw new BGIllegalArgumentException("orderIds");
            }
            if (copy.getId() != order.getCopyId()) {
                throw new BGIllegalArgumentException("orderIds");
            }
            if (order.getType() == LicenseOrderType.TEST) {
                throw new BGMessageException("\u0421\u0447\u0435\u0442 \u043c\u043e\u0436\u043d\u043e \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u0441 \"\u043f\u043e\u0441\u0442\u043e\u044f\u043d\u043d\u043e\u0439\" \u043b\u0438\u0446\u0435\u043d\u0437\u0438\u0435\u0439.", "orderIds.type.notBuy");
            }
            orderList.add(order);
        }
        String productVersion = copy.getProductVersion();
        HashSet<Integer> processedComponentIds = new HashSet<Integer>();
        for (LicenseOrder order : orderList) {
            int componentId = order.getComponentId();
            if (!processedComponentIds.add(componentId)) continue;
            LicenseOrderConfirmed grouppedConfirmedItem = licenseManager.groupCopyItems(componentId, copy.getId(), new int[]{2, 3});
            LicenseOrderConfirmed grouppedNewItem = licenseManager.groupCopyItems(componentId, copy.getId(), new int[]{0});
            if (grouppedConfirmedItem == null && grouppedNewItem == null) continue;
            String productItemName = new String();
            Integer confirmedItemsCount = null;
            if (grouppedConfirmedItem != null) {
                confirmedItemsCount = grouppedConfirmedItem.getCount();
                productItemName = grouppedConfirmedItem.getComponentName();
            }
            Integer newItemsCount = null;
            if (grouppedNewItem != null) {
                newItemsCount = grouppedNewItem.getCount();
                productItemName = grouppedNewItem.getComponentName();
            }
            LicenseOrderBillData orderBillData = LicenseUtils.getCostDelta(productItemName, confirmedItemsCount, newItemsCount, productVersion, (Preferences)this.getModuleSetup());
            orderBillData.setComponentId(order.getComponentId());
            orderBillData.setComponentTitle(order.getComponentTitle());
            result.add(orderBillData);
        }
        return result;
    }

    public void ordersDelete(int contractId, int copyId, Set<Integer> orderIds) throws BGException {
        LicenseManager licenseManager = new LicenseManager(this.getConnection(), this.moduleId);
        LicenseCopy copy = licenseManager.getCopy(copyId);
        if (copy == null || copy.getContractId() != contractId) {
            throw new BGIllegalArgumentException("copyId");
        }
        boolean haveNonSign = licenseManager.checkHaveNonSignAdditionalAgreement(copyId);
        for (Integer orderId : orderIds) {
            LicenseOrder order = licenseManager.getOrder(orderId);
            if (order == null || order.getCopyId() != copyId) {
                throw new BGIllegalArgumentException("orderIds");
            }
            if (order.getStatus() != 0) {
                throw new BGMessageException("\u0423\u0434\u0430\u043b\u044f\u0442\u044c \u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0437\u0430\u043a\u0430\u0437\u044b \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u043d\u043e\u0432\u044b\u0439\".", "orderIds.status.notNew");
            }
            if (!haveNonSign || order.getType() != LicenseOrderType.BUY) continue;
            throw new BGMessageException("\u0423 \u0432\u0430\u0441 \u0438\u043c\u0435\u0435\u0442\u0441\u044f \u043d\u0435\u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u043e\u0435 \u0434\u043e\u043f. \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435, \u0435\u0441\u043b\u0438 \u0432\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0435\u0433\u043e \u0441\u043e\u0441\u0442\u0430\u0432, \u043f\u043e\u043f\u0440\u043e\u0441\u0438\u0442\u0435 \u043d\u0430\u0441 \u0435\u0433\u043e \u0443\u0434\u0430\u043b\u0438\u0442\u044c (\u043f\u0440\u0438 \u044d\u0442\u043e\u043c \u0431\u0443\u0434\u0435\u0442 \u0443\u0434\u0430\u043b\u0435\u043d \u0441\u0447\u0435\u0442 \u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442).", "orderIds.agreement.notSign");
        }
        for (Integer orderId : orderIds) {
            licenseManager.deleteOrder(orderId);
        }
    }

    public List<AdditionalAgreement> additionalAgreements(int contractId, int copyId) throws Exception {
        List<AdditionalAgreement> list = this.licenseManager.getListAdditionalAgreement(contractId, copyId);
        Comparator<SpecificationTitle> comparer = new Comparator<SpecificationTitle>(this){

            @Override
            public int compare(SpecificationTitle arg0, SpecificationTitle arg1) {
                String first = arg0.getName();
                String second = arg1.getName();
                return first.compareTo(second);
            }
        };
        for (AdditionalAgreement agreement : list) {
            List specificationList = agreement.getSpecification();
            Collections.sort(specificationList, comparer);
        }
        return list;
    }

    public void additionalAgreementCreate(int contractId, AdditionalAgreement additionalAgreement, int typeDocument) throws Exception {
        int typeId;
        int journalId;
        String idPattern;
        AddAdditionalAgreementEvent event = new AddAdditionalAgreementEvent(this.moduleId, contractId, this.userId, additionalAgreement);
        event.setAttribute("module.bill.id", String.valueOf(this.getModuleSetup().getInt("module.bill.id", 0)));
        EventProcessor.getInstance().request((QueueEvent)event);
        if (typeDocument == -1) {
            idPattern = this.getModuleSetup().get("license.newDocument.pattern.id", "1");
            journalId = Utils.parseInt((String)this.getModuleSetup().get("license.newDocument.journal.id", "-1"), (int)-1);
            typeId = Utils.parseInt((String)this.getModuleSetup().get("license.newDocument.type.id", "-1"), (int)-1);
        } else {
            journalId = Utils.parseInt((String)this.getModuleSetup().get("license.document.journal.id", "-1"), (int)-1);
            typeId = Utils.parseInt((String)this.getModuleSetup().get("license.document.type.id", "-1"), (int)-1);
            idPattern = this.getModuleSetup().get("license.document.idDefault", "1");
            SortedMap map = this.getModuleSetup().subIndexed("license.document.");
            long group = new ContractManager(this.getConnection()).getContractById(contractId).getGroups();
            for (Map.Entry entry : map.entrySet()) {
                int value = ((ParameterMap)entry.getValue()).getInt("group", 0);
                if ((group & (long)(1 << value)) <= 0L) continue;
                ((ParameterMap)entry.getValue()).getInt("id", 0);
                idPattern = String.valueOf(((ParameterMap)entry.getValue()).getInt("id", 0));
                break;
            }
        }
        if (typeId == -1 || journalId == -1) {
            throw new BGMessageException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043a\u043e\u0434 \u0442\u0438\u043f\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0438\u043b\u0438/\u0438 \u043a\u043e\u0434 \u0436\u0443\u0440\u043d\u0430\u043b\u0430!");
        }
        Document result = null;
        DocumentPattern pattern = ((DocumentsPatternService)this.context.newService(DocumentsPatternService.class, 0)).getPattern(Utils.parseInt((String)idPattern));
        if (pattern == null) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430.");
        }
        DocumentTable table = new DocumentTable();
        table.setIdentifier("components");
        table.setExtractMethod(DocumentTableExtractMethod.NONE);
        pattern.addTable(table);
        Object nameFile = typeDocument == 0 ? "\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u0435 \u2116" + additionalAgreement.getAgreementNumber() : pattern.getDocumentName();
        pattern.setDocumentName((String)nameFile);
        pattern.setDocumentComment("");
        pattern.setGeneratedFileNamePattern((String)nameFile);
        try (DocumentsPatternGenerator generator = new DocumentsPatternGenerator(this.getConnection(), pattern, contractId, typeId, journalId, this.userId);){
            ArrayList tableData = new ArrayList();
            int i = 1;
            for (SpecificationTitle specification : additionalAgreement.getSpecification()) {
                HashMap<String, String> currentRow = new HashMap<String, String>(additionalAgreement.getSpecification().size());
                currentRow.put("col1", String.valueOf(i));
                String itemTitle = specification.getName().toUpperCase();
                if (itemTitle.contains(".")) {
                    itemTitle = itemTitle.substring(itemTitle.lastIndexOf(".") + 1);
                }
                currentRow.put("col2", itemTitle);
                currentRow.put("col3", specification.getCount() == 0 ? "\u043d\u0435 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043e" : Utils.formatCostByGrouping((BigDecimal)new BigDecimal(specification.getCount()), (int)3, (int)0));
                tableData.add(currentRow);
                ++i;
            }
            generator.setTableData("components", tableData);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("NUMBER_DOC", Integer.toString(additionalAgreement.getAgreementNumber()));
            map.put("SUM", Utils.formatCostByGrouping((BigDecimal)additionalAgreement.getSum(), (int)-1, (int)2).replace(' ', '\u00a0'));
            map.put("SUMSTRING", SummaToString.summaToString((String)Utils.formatCost((BigDecimal)additionalAgreement.getSum()), (boolean)false, (boolean)true));
            map.put("CPARAM_7", this.getEmailForDocument(contractId, 20));
            try {
                result = generator.generateDocument(map);
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
            if (result == null) {
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430.");
            }
        }
        additionalAgreement.setDocumentId(result.getId());
        this.licenseManager.setAdditionalAgreement(contractId, additionalAgreement);
    }

    public void additionalAgreementUpdate(int contractId, AdditionalAgreement additionalAgreement) throws Exception {
        if (additionalAgreement == null) {
            throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442.");
        }
        this.licenseManager.updateAdditionalAgreement(contractId, additionalAgreement);
    }

    public void additionalAgreementDelete(int contractId, AdditionalAgreement additionalAgreement) throws Exception {
        if (additionalAgreement == null) {
            throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d \u0443\u0434\u0430\u043b\u044f\u0435\u043c\u044b\u0439 \u0434\u043e\u043f\u0438\u043a.");
        }
        AdditionalAgreement deleteAgreement = this.licenseManager.getAdditionalAgreement(additionalAgreement.getId());
        if (deleteAgreement != null && deleteAgreement.getStatus() == 0) {
            if (!this.getStatusSigned(additionalAgreement.getId())) {
                RemoveAdditionalAgreementEvent event = new RemoveAdditionalAgreementEvent(this.moduleId, contractId, this.userId, additionalAgreement);
                event.setAttribute("module.bill.id", String.valueOf(this.getModuleSetup().getInt("module.bill.id", 0)));
                EventProcessor.getInstance().request((QueueEvent)event);
                DocumentsService docService = (DocumentsService)this.context.newService(DocumentsService.class, 0);
                docService.deleteDocument(Arrays.asList(additionalAgreement.getDocumentId()));
                this.licenseManager.deleteAdditionalAgreement(additionalAgreement.getId());
                if (this.licenseManager.getLastNumber(contractId) == 0) {
                    this.licenseManager.resetCopyDiscount(contractId, additionalAgreement.getCopyId());
                }
            }
        } else {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u043d\u044b\u0445 \u0434\u043e\u043f. \u0441\u043e\u0433\u043b. \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e.");
        }
    }

    public List<SpecificationTitle> specificationTitles(int id) throws Exception {
        return this.licenseManager.getSpecificationOfAdditionalAgreement(id);
    }

    public List<LicenseOrder> permanentOrders(int copyId, boolean onlyPerformed) throws Exception {
        if (onlyPerformed) {
            return this.licenseManager.getOrders(copyId, "2", null, -1);
        }
        return this.licenseManager.getOrders(copyId, "0,2", null, -1);
    }

    public BigDecimal costComponents(int copyId, List<SpecificationTitle> specificationList) throws Exception {
        ArrayList<LicenseOrderConfirmed> packageItems = new ArrayList<LicenseOrderConfirmed>();
        for (SpecificationTitle specificationTitle : specificationList) {
            LicenseOrderConfirmed order = new LicenseOrderConfirmed();
            order.setComponentName(specificationTitle.getName());
            order.setCount(specificationTitle.getCount());
            packageItems.add(order);
        }
        LicenseCopy copy = this.licenseManager.getCopy(copyId);
        String productVersion = copy.getProductVersion();
        Map<String, BigDecimal> costMap = LicenseUtils.getCosts(LicenseUtils.buildLicenseCostUrlRequest(packageItems, productVersion, (ParameterMap)Setup.getSetup()));
        BigDecimal cost = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> entry : costMap.entrySet()) {
            cost = cost.add(entry.getValue());
        }
        return cost;
    }

    public int lastNumber(int contractId) throws Exception {
        return this.licenseManager.getLastNumber(contractId);
    }

    public BigDecimal discountGet(int contractId, int copyId) throws Exception {
        return this.licenseManager.getDiscount(contractId, copyId);
    }

    public void discountSet(int contractId, int copyId, BigDecimal discount) throws Exception {
        this.licenseManager.setDiscount(discount, contractId, copyId);
    }

    public void statusSignedSet(int contractId, int copyId, AdditionalAgreement additionalAgreement) throws Exception {
        if (!this.getStatusSigned(additionalAgreement.getId())) {
            SignAdditionalAgreementEvent event = new SignAdditionalAgreementEvent(this.moduleId, contractId, this.userId, additionalAgreement);
            event.setAttribute("module.bill.id", String.valueOf(this.getModuleSetup().getInt("module.bill.id", 0)));
            event.setAttribute("license.charge.type.id", String.valueOf(this.getModuleSetup().getInt("license.charge.type.id", 0)));
            EventProcessor.getInstance().request((QueueEvent)event);
            this.licenseManager.setCharge(additionalAgreement.getId(), additionalAgreement.getChargeId());
            this.licenseManager.setInvoice(additionalAgreement.getId(), additionalAgreement.getInvoiceId());
            this.licenseManager.setStatusSigned(additionalAgreement.getId());
            List<AdditionalAgreement> list = this.additionalAgreements(contractId, copyId);
            boolean flag = true;
            List<LicenseOrder> orderList = this.licenseManager.getOrders(copyId, "0", null, -1);
            if (list.size() > 1) {
                int indexPrevious = list.indexOf(additionalAgreement) - 1;
                HashMap<String, Integer> previousMap = this.listToMap(list.get(indexPrevious).getSpecification());
                HashMap<String, Integer> difference = new HashMap<String, Integer>();
                for (SpecificationTitle specification : additionalAgreement.getSpecification()) {
                    if (specification.getCount() == 0) {
                        if (previousMap.get(specification.getName()) != null && previousMap.get(specification.getName()) == 0) continue;
                        difference.put(specification.getName(), 0);
                        continue;
                    }
                    int dif = specification.getCount() - (previousMap.get(specification.getName()) == null ? 0 : previousMap.get(specification.getName()));
                    if (dif <= 0) continue;
                    difference.put(specification.getName(), dif);
                }
                if (orderList.size() != difference.size()) {
                    flag = false;
                }
                for (LicenseOrder order : orderList) {
                    if (difference.get(order.getComponentName()) != null && order.getCount() == ((Integer)difference.get(order.getComponentName())).intValue() && additionalAgreement.getDate().compareTo(order.getCreateDate()) > 0) continue;
                    flag = false;
                    break;
                }
                if (flag) {
                    for (LicenseOrder order : orderList) {
                        if (order.getType() != LicenseOrderType.BUY || order.getStatus() != 0) continue;
                        order.setStatus(2);
                        this.orderUpdate(order);
                    }
                }
            } else {
                HashMap<String, Integer> now = this.listToMap(additionalAgreement.getSpecification());
                for (LicenseOrder order : orderList) {
                    if (order.getType() == LicenseOrderType.BUY && order.getStatus() == 0 && now.get(order.getComponentName()) != null && now.get(order.getComponentName()).intValue() == order.getCount()) {
                        order.setStatus(2);
                        this.orderUpdate(order);
                        continue;
                    }
                    flag = false;
                }
            }
            if (!flag) {
                throw new BGMessageException("\u041d\u0435 \u043f\u043e\u043b\u0443\u0447\u0438\u043b\u043e\u0441\u044c \u0432\u044b\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0443 \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u0441\u0442\u0430\u0442\u0443\u0441 \"\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\".\n\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u044d\u0442\u043e \u0432\u0440\u0443\u0447\u043d\u0443\u044e. \u0414\u043b\u044f \u0442\u043e\u0433\u043e \u0447\u0442\u043e\u0431\u044b \u0437\u0430\u043a\u0430\u0437\u044b \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u043b\u0438\u0441\u044c\n\u0430\u0432\u0442\u043e\u043c\u0430\u0442\u043e\u043c \u043f\u0440\u0438\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0439\u0442\u0435\u0441\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u043e\u0432\u0435\u0442\u043e\u0432:\n\u043d\u0435 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0439\u0442\u0435 \u043d\u043e\u0432\u044b\u0445 \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u0434\u043e \u043c\u043e\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u0434\u043e\u043f.\u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f,\n\u043d\u0435 \u0438\u0437\u043c\u0435\u043d\u044f\u0439\u0442\u0435 \u043a\u043e\u043b-\u0432\u043e \u0437\u0430\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0445 \u043a\u043e\u043c\u043f\u043e\u043d\u0435\u043d\u0442\u043e\u0432.");
            }
        }
    }

    public BigDecimal prospectiveDiscount(int copyId) throws Exception {
        List<LicenseOrder> listOrder = this.licenseManager.getOrders(copyId, "2", null, -1);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<SpecificationTitle> specificationList = new ArrayList<SpecificationTitle>();
        Collections.reverse(listOrder);
        for (LicenseOrder licenseOrder : listOrder) {
            String componentName = licenseOrder.getComponentName();
            if (map.containsKey(componentName)) {
                if (licenseOrder.getCount() == 0) {
                    map.put(componentName, 0);
                    continue;
                }
                if ((Integer)map.get(componentName) == 0) {
                    return null;
                }
                map.put(componentName, licenseOrder.getCount() + (Integer)map.get(componentName));
                continue;
            }
            map.put(licenseOrder.getComponentName(), licenseOrder.getCount());
        }
        for (Map.Entry entry : map.entrySet()) {
            specificationList.add(new SpecificationTitle(((Integer)entry.getValue()).intValue(), (String)entry.getKey()));
        }
        return this.costComponents(copyId, specificationList);
    }

    public AdditionalAgreement toReplaceSpecification(AdditionalAgreement agreement, int oldCopyId) throws Exception {
        LicenseComponent ipn = (LicenseComponent)this.licenseComponentDao.get(this.getModuleSetup().getInt("license.component.ipn.id", -1));
        LicenseComponent dialup = (LicenseComponent)this.licenseComponentDao.get(this.getModuleSetup().getInt("license.component.dialup.id", -1));
        LicenseComponent inet = (LicenseComponent)this.licenseComponentDao.get(this.getModuleSetup().getInt("license.component.inet.id", -1));
        if (ipn == null || dialup == null || inet == null) {
            throw new BGMessageException("\u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0438\u0434 ipn \u0438\u043b\u0438/\u0438 dialup \u0438\u043b\u0438/\u0438 inet( \u041f\u0440\u0438\u043c\u0435\u0440 - \"license.component.ipn.id=34\" ) \u0438\u043b\u0438 \u043d\u0435\u0432\u0435\u0440\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0430\u043d\u044b. \u041a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u043a\u0430\u0437\u043e\u0432 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u043e!");
        }
        List list = agreement.getSpecification();
        agreement.setSum(this.costComponents(oldCopyId, list));
        if (list.contains(inet)) {
            list.remove(dialup);
            list.remove(ipn);
        } else {
            ArrayList<SpecificationTitle> costList = new ArrayList<SpecificationTitle>();
            if (list.contains(ipn)) {
                costList.add((SpecificationTitle)list.get(list.lastIndexOf(ipn)));
            }
            if (list.contains(dialup)) {
                costList.add((SpecificationTitle)list.get(list.lastIndexOf(dialup)));
            }
            list.remove(dialup);
            list.remove(ipn);
            BigDecimal sumRemovedComponents = this.costComponents(oldCopyId, costList);
            if (sumRemovedComponents.compareTo(BigDecimal.ZERO) == 1) {
                int inetCount = this.getInetCount(sumRemovedComponents);
                list.add(new SpecificationTitle(inetCount, inet.getName()));
                LicenseOrderPermanentNew order = new LicenseOrderPermanentNew(inet.getId(), inet.getName(), 0, BigDecimal.ZERO, inetCount == -1, oldCopyId);
                order.setTotalCount(Integer.valueOf(inetCount));
                order.setTotalSum(sumRemovedComponents);
                order.setStatus(2);
                order.setCount(inetCount);
                this.licenseManager.updateCopyItemOrder((LicenseOrder)order);
            }
        }
        return agreement;
    }

    private boolean getStatusSigned(int id) throws Exception {
        return this.licenseManager.getAdditionalAgreement(id).getStatus() == 1;
    }

    private HashMap<String, Integer> listToMap(List<SpecificationTitle> list) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (SpecificationTitle specification : list) {
            map.put(specification.getName(), specification.getCount());
        }
        return map;
    }

    private int getInetCount(BigDecimal sum) throws Exception {
        try {
            byte[] bytes = Utils.readByBlock((InputStream)URI.create("http://www.bgbilling.ru/inet5.txt").toURL().openConnection().getInputStream());
            String text = new String(bytes);
            ArrayList<Double> counts = new ArrayList<Double>();
            ArrayList<Double> sums = new ArrayList<Double>();
            for (String line : text.split("\n")) {
                String[] mas = line.split(" +");
                if (mas.length < 2) continue;
                Double countSide = Utils.parseDouble((String)mas[0], (double)-1.0);
                Double sumSide = Utils.parseDouble((String)mas[1], (double)-1.0);
                if (mas[0].lastIndexOf("unlimited") != -1) {
                    countSide = 0.0;
                }
                if (!(countSide > -1.0) || !(sumSide > 0.0)) continue;
                counts.add(countSide);
                sums.add(sumSide);
            }
            Double bottomSum = 1.0;
            Double bottomCount = 0.0;
            Double topSum = (Double)sums.get(sums.size() - 1);
            Double topCount = 0.0;
            boolean flag = true;
            for (int j = sums.size() - 1; j > -1; --j) {
                if ((Double)sums.get(j) > (double)sum.intValue()) {
                    topSum = (Double)sums.get(j);
                    continue;
                }
                if (!flag) continue;
                bottomSum = (Double)sums.get(j);
                flag = false;
            }
            if (bottomSum > 0.0) {
                bottomCount = (Double)counts.get(sums.lastIndexOf(bottomSum));
            }
            topCount = (Double)counts.get(sums.lastIndexOf(topSum));
            Double count = (sum.doubleValue() - bottomSum) * (topCount - bottomCount) / (topSum - bottomSum) + bottomCount;
            if (count > (double)count.intValue()) {
                count = count + 1.0;
            }
            return count.intValue();
        }
        catch (IOException e) {
            throw new BGException((Throwable)e);
        }
    }

    private String getEmailForDocument(int contractId, int parameterId) throws Exception {
        try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
            String string = contractDao.optContractParameterEmailAsString(contractId, parameterId).orElse("");
            return string;
        }
    }

    public LicenseComponentPrice licenseComponentPriceGet(int productId, int componentId) throws Exception {
        return new LicensePriceDao(this.getConnection(), this.moduleId).getPrice(productId, componentId);
    }

    public void licenseComponentPriceUpdate(int productId, int componentId, String price) throws Exception {
        new LicensePriceDao(this.getConnection(), this.moduleId).update(new LicenseComponentPrice().setProductId(productId).setComponentId(componentId).setPrice(price));
    }

    public LicenseTariffGroup licenseTariffGroupGet(int id) throws Exception {
        return (LicenseTariffGroup)this.licenseTariffGroupDao.get(id);
    }

    public int licenseTariffGroupUpdate(LicenseTariffGroup tariffGroup) throws Exception {
        this.licenseTariffGroupDao.update(tariffGroup);
        return tariffGroup.getId();
    }

    public boolean licenseTariffGroupDelete(int id) throws Exception {
        return this.licenseTariffGroupDao.delete(id) > 0;
    }

    public LicenseComponent productComponentGet(int id) throws Exception {
        return (LicenseComponent)this.licenseComponentDao.get(id);
    }

    public LicenseComponent productComponentByNameGet(String name) throws Exception {
        return this.licenseComponentDao.getByName(name);
    }

    public List<IdTitle> licenseTariffGroupTitles() throws Exception {
        return this.licenseTariffGroupDao.list().stream().map(a -> a.toIdTitle()).toList();
    }

    public int productComponentUpdate(LicenseComponent component) throws Exception {
        if (Utils.isBlankString((String)component.getTitle())) {
            throw new BGMessageException("\u041f\u043e\u043b\u0435 '\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.");
        }
        if (Utils.isBlankString((String)component.getName())) {
            throw new BGMessageException("\u041f\u043e\u043b\u0435 '\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435' \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c.");
        }
        this.licenseComponentDao.update(component);
        return component.getId();
    }

    public LicenseTariffRange licenseTariffRangeGet(int id) throws Exception {
        return (LicenseTariffRange)this.licenseTariffRangeDao.get(id);
    }

    public int licenseTariffRangeUpdate(LicenseTariffRange tariffRange) throws Exception {
        this.licenseTariffRangeDao.update(tariffRange);
        return tariffRange.getId();
    }

    public boolean licenseTariffRangeDelete(int id) throws Exception {
        return this.licenseTariffRangeDao.delete(id) > 0;
    }

    public List<IdTitle> licenseTariffRangeTitles() throws Exception {
        return this.licenseTariffRangeDao.list().stream().map(a -> a.toIdTitle()).toList();
    }
}

