/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.web.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.model.ParameterTableModel;
import ru.bitel.bgbilling.kernel.admin.web.client.WebMenuEditor;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.GuiTitlable;

public class WebContractSearchConfig
extends BGUPanel {
    private WebMenuEditor webMenuEditor;
    private JTabbedPane tabbedPane;
    private BGUList<ListItem> avaibleSearchModules;
    private BGUList<ListItem> restoreSearchModules;
    private BGUList<ListItem> paymentSearchModules;
    private JSONArray modules;

    public WebContractSearchConfig(WebMenuEditor webMenuEditor) {
        this.webMenuEditor = webMenuEditor;
    }

    @Override
    protected void jbInit() throws Exception {
        this.restoreSearchModules = new BGUList();
        this.restoreSearchModules.setCellRenderer(new SearchModuleCellRenderer());
        this.paymentSearchModules = new BGUList();
        this.paymentSearchModules.setCellRenderer(new SearchModuleCellRenderer());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.add((Component)this.getListPanel(this.restoreSearchModules), "\u0412\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0430");
        this.tabbedPane.add((Component)this.getListPanel(this.paymentSearchModules), "\u041e\u043f\u043b\u0430\u0442\u0430");
        this.tabbedPane.addChangeListener(e -> this.performAction("refresh"));
        BGSplitPaneNoBorder splitPane = new BGSplitPaneNoBorder(1, this.tabbedPane, (Component)this.getAvaiblePanel(), 800L);
        this.setLayout(new GridBagLayout());
        this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getAvaiblePanel() {
        this.avaibleSearchModules = new BGUList();
        this.avaibleSearchModules.setCellRenderer(new SearchModuleCellRenderer());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 11, 3, new Insets(25, 10, 0, 15), 0, 0));
        panel.add((Component)new JLabel("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435 \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)new JScrollPane(this.avaibleSearchModules), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getButtonPanel() {
        JButton addButton = new JButton("<<<");
        addButton.addActionListener(a -> this.addDelSearchModule(this.avaibleSearchModules, "true"));
        JButton delButton = new JButton(">>>");
        delButton.addActionListener(a -> this.addDelSearchModule(this.tabbedPane.getSelectedIndex() == 0 ? this.restoreSearchModules : this.paymentSearchModules, "false"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)addButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)delButton, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 11, 2, new Insets(5, 0, 0, 0), 0, 0));
        return panel;
    }

    private void addDelSearchModule(BGUList<ListItem> modules, String value) {
        int index = this.tabbedPane.getSelectedIndex();
        modules.getSelectedValuesList().forEach(i -> {
            JSONArray params = i.jsonObject.optJSONArray("params");
            params.forEach(p -> {
                JSONObject paramJson = (JSONObject)p;
                if (index == 0 && "use.for.access.restore".equals(paramJson.optString("key"))) {
                    paramJson.put("value", (Object)value);
                } else if (index == 1 && "use.for.payment".equals(paramJson.optString("key"))) {
                    paramJson.put("value", (Object)value);
                }
            });
            this.tryCall(() -> this.webMenuEditor.getWebService().updateContractSearchModuleParams(i.jsonObject.getString("className"), i.jsonObject.optJSONArray("params")));
        });
        this.performAction("refresh");
    }

    private JPanel getListPanel(BGUList<ListItem> modules) {
        BGSwingUtilites.handleLDMouseClicked(modules, e -> this.performAction("edit"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u044b\u0435 \u043c\u043e\u0434\u0443\u043b\u0438"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(modules, 400, 200), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 3, 3, 3), 0, 0));
        return panel;
    }

    @Override
    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh(e -> {
            int tabId = this.tabbedPane.getSelectedIndex();
            ArrayList avaibleData = new ArrayList();
            ArrayList restoreData = new ArrayList();
            ArrayList paymentData = new ArrayList();
            this.modules = this.webMenuEditor.getWebService().getContractSearchModuleList();
            this.modules.forEach(a -> {
                JSONObject json = (JSONObject)a;
                JSONArray array = json.optJSONArray("params");
                array.forEach(b -> {
                    JSONObject paramJson = (JSONObject)b;
                    if ("use.for.access.restore".equals(paramJson.optString("key"))) {
                        if ("true".equals(paramJson.optString("value"))) {
                            restoreData.add(new ListItem(this, json));
                        } else if (tabId == 0) {
                            avaibleData.add(new ListItem(this, json));
                        }
                    }
                    if ("use.for.payment".equals(paramJson.optString("key"))) {
                        if ("true".equals(paramJson.optString("value"))) {
                            paymentData.add(new ListItem(this, json));
                        } else if (tabId == 1) {
                            avaibleData.add(new ListItem(this, json));
                        }
                    }
                });
            });
            this.restoreSearchModules.setData(restoreData);
            this.paymentSearchModules.setData(paymentData);
            this.avaibleSearchModules.setData(avaibleData);
        });
        new AbstractBGUPanel.BGActionEdit(e -> {
            int index = this.tabbedPane.getSelectedIndex();
            BGUList<ListItem> selectedList = index == 0 ? this.restoreSearchModules : this.paymentSearchModules;
            ListItem listItem = (ListItem)selectedList.getSelectedValue();
            if (listItem != null) {
                new ContractSeachParamEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u043e\u0433\u043e \u043c\u043e\u0434\u0443\u043b\u044f", listItem.jsonObject).open();
            }
        });
    }

    class SearchModuleCellRenderer
    extends DefaultListCellRenderer {
        private JPanel panel;
        private JLabel title = new JLabel();
        private JLabel className = new JLabel();

        public SearchModuleCellRenderer() {
            this.title.setFont(this.title.getFont().deriveFont(1).deriveFont(this.title.getFont().getSize2D() * 1.3f));
            Color fgColor = UIManager.getColor("TextField.inactiveForeground");
            this.className.setForeground(fgColor);
            this.panel = new JPanel(new GridBagLayout());
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.getPropertyPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        }

        private JPanel getPropertyPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.className, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.setOpaque(false);
            return panel;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ListItem listItem = (ListItem)value;
            this.title.setText(listItem.jsonObject.optString("title"));
            this.className.setText("\u041a\u043b\u0430\u0441\u0441: " + listItem.jsonObject.optString("className"));
            this.panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this.panel;
        }
    }

    class ListItem
    implements GuiTitlable {
        JSONObject jsonObject;

        public ListItem(WebContractSearchConfig this$0, JSONObject jsonObject) {
            this.jsonObject = jsonObject;
        }

        public String toString() {
            return this.jsonObject.toString();
        }

        @Override
        public String getGuiTitle() {
            return this.jsonObject.toString();
        }
    }

    class ContractSeachParamEditor
    extends BGEditorDialog<JSONObject> {
        private ParameterTableModel parameterTableModel;

        public ContractSeachParamEditor(String title, JSONObject data) {
            super(title, data);
            this.parameterTableModel = new ParameterTableModel();
        }

        @Override
        public void doDialogPanel() {
            BGUTable table = new BGUTable(this.parameterTableModel);
            table.setSelectionMode(0);
            BGSwingUtilites.handleLDMouseClicked(table, e -> this.tableMouseClicked((MouseEvent)e));
            this.panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0438\u0441\u043a\u043e\u0432\u043e\u0433\u043e \u043c\u043e\u0434\u0443\u043b\u044f"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane(table, 1000, 400), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 20, 0), 0, 0));
            ArrayList rows = new ArrayList();
            if (((JSONObject)this.data).has("params")) {
                ((JSONObject)this.data).optJSONArray("params").forEach(a -> {
                    if (!((JSONObject)a).optString("key").startsWith("use.for.")) {
                        rows.add((JSONObject)a);
                    }
                });
            }
            this.parameterTableModel.setData(rows);
        }

        private void tableMouseClicked(MouseEvent event) {
            JSONObject jsonObject = (JSONObject)this.parameterTableModel.getSelectedRow();
            if (jsonObject != null && "BOOLEAN".equals(jsonObject.optString("type"))) {
                jsonObject.put("value", (Object)String.valueOf(Boolean.valueOf(jsonObject.optString("value")) == false));
                this.parameterTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean doApply() throws Exception {
            return this.tryCallBoolean(() -> WebContractSearchConfig.this.webMenuEditor.getWebService().updateContractSearchModuleParams(((JSONObject)this.data).getString("className"), ((JSONObject)this.data).optJSONArray("params")));
        }
    }
}

