/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.client.tree;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.tariff.client.tree.DefaultTariffTreeNode;
import ru.bitel.common.Utils;

public abstract class CostTariffTreeNode
extends DefaultTariffTreeNode {
    private static Icon icon = ClientUtils.getIcon("coin");
    private JLabel view = new JLabel(icon, 2);
    private BGComboBox<ComboBoxItem> costSourceCombo;
    private BGFloatTextField cost;
    private JCheckBox defaultPrice;
    private String costValue;
    private boolean isDefault;
    private String costSource;
    private String costType;

    @Override
    protected void loadData() {
        this.extractData();
        this.cost.setText(this.costValue);
        this.defaultPrice.setSelected(this.isDefault);
        ClientUtils.setComboBoxSelection(this.costSourceCombo, this.costSource);
    }

    private void extractData() {
        Map<String, String> data = this.getDataInHash();
        this.costValue = data.get("cost");
        if (this.costValue == null) {
            this.costValue = "";
        }
        this.isDefault = data.get("default") != null;
        this.costType = data.get("cost_type");
        if (Utils.isBlankString(this.costType)) {
            this.costType = "min";
        }
        this.costSource = data.get("cost_source");
        if (Utils.isBlankString(this.costSource)) {
            this.costSource = "node";
        }
        if (data.size() == 0) {
            this.costValue = this.getData();
            this.isDefault = false;
            this.costType = "min";
            this.costSource = "node";
        }
    }

    @Override
    protected void serializeData() {
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("cost", this.cost.getText());
        if (this.defaultPrice.isSelected()) {
            data.put("default", "true");
        }
        data.put("cost_source", ClientUtils.getIdFromComboBox(this.costSourceCombo));
        this.setDataInHash(data);
    }

    @Override
    public void loadFromXML(Element element) {
        this.loadHashFromXML(element);
    }

    @Override
    public void serializeToXML(Element element) {
        this.serializeHashToXML(element);
    }

    @Override
    protected JPanel getEditorPanel() {
        JPanel propsPanel = new JPanel();
        if (this.costSourceCombo == null) {
            this.costSourceCombo = new BGComboBox();
            this.costSourceCombo.addItem(new ComboBoxItem("node", "="));
            this.costSourceCombo.addItem(new ComboBoxItem("costMap", "\u0432\u0437\u044f\u0442\u044c \u0438\u0437 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d"));
            this.cost = new BGFloatTextField();
            this.cost.setColumns(10);
            this.defaultPrice = new JCheckBox("\u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
            propsPanel.add(new JLabel(this.getLabelText()));
            propsPanel.add(this.costSourceCombo);
            propsPanel.add(this.cost);
            propsPanel.add(this.defaultPrice);
        }
        return propsPanel;
    }

    @Override
    public Component getView() {
        this.extractData();
        StringBuilder labelText = new StringBuilder(100);
        labelText.append(this.getLabelText());
        if (this.costSource.equals("costMap")) {
            labelText.append("\u0432\u0437\u044f\u0442\u044c \u0438\u0437 \u043a\u0430\u0440\u0442\u044b \u0446\u0435\u043d");
        } else {
            labelText.append(this.costValue);
        }
        if (this.isDefault) {
            labelText.append(" (*)");
        }
        this.view.setText(labelText.toString());
        return this.view;
    }

    protected abstract String getLabelText();
}

