/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.edo.server.provider.sbis;

import bitel.billing.common.VersionInfo;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.common.ParameterMap;

public class SbisAPI
extends BGLogger {
    private int userId = 0;
    private BGPluginServer plugin = null;
    private static Map<Integer, String> tokenMap = new HashMap<Integer, String>();

    public SbisAPI(int userId) {
        this.userId = userId;
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.edo");
    }

    public List<String> doChangeList() throws BGException, SbisJsonRpcException {
        JSONObject filter = new JSONObject();
        filter.put("\u041f\u043e\u043b\u043d\u044b\u0439\u0421\u0435\u0440\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u042d\u041f", (Object)"\u041d\u0435\u0442");
        JSONObject params = new JSONObject();
        params.put("\u0424\u0438\u043b\u044c\u0442\u0440", (Object)filter);
        this.doRequest("\u0421\u0411\u0418\u0421.\u0421\u043f\u0438\u0441\u043e\u043a\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439", params, this.getToken());
        ArrayList<String> list = new ArrayList<String>();
        return list;
    }

    public WriteDoc writeDocs(final String name, final String base64data, final ParameterMap documentSetup) throws BGException, SbisJsonRpcException {
        HashMap<String, Object> params = new HashMap<String, Object>(){
            {
                this.put("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", new HashMap<String, Object>(){
                    {
                        this.put("\u0412\u043b\u043e\u0436\u0435\u043d\u0438\u0435", new ArrayList<HashMap<String, Object>>(){
                            {
                                this.add(new HashMap<String, Object>(){
                                    {
                                        this.put("\u0424\u0430\u0439\u043b", new HashMap<String, Object>(){
                                            {
                                                this.put("\u0414\u0432\u043e\u0438\u0447\u043d\u044b\u0435\u0414\u0430\u043d\u043d\u044b\u0435", base64data);
                                                this.put("\u0418\u043c\u044f", name);
                                            }
                                        });
                                    }
                                });
                            }
                        });
                        final String ourUlInn = documentSetup.get("\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0421\u0432\u042e\u041b_\u0418\u041d\u041d");
                        final String ourFlInn = documentSetup.get("\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0421\u0432\u0424\u041b_\u0418\u041d\u041d");
                        this.put("\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f", new HashMap<String, Object>(){
                            {
                                if (ourUlInn != null) {
                                    this.put("\u0421\u0432\u042e\u041b", new HashMap<String, Object>(){
                                        {
                                            this.put("\u0418\u041d\u041d", ourUlInn);
                                            this.put("\u041a\u041f\u041f", documentSetup.get("\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0421\u0432\u042e\u041b_\u041a\u041f\u041f"));
                                            this.put("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", documentSetup.get("\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0421\u0432\u042e\u041b_\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"));
                                        }
                                    });
                                }
                                if (ourFlInn != null) {
                                    this.put("\u0421\u0432\u0424\u041b", new HashMap<String, Object>(){
                                        {
                                            this.put("\u0418\u041d\u041d", ourFlInn);
                                            this.put("\u0421\u041d\u0418\u041b\u0421", documentSetup.get("\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0421\u0432\u0424\u041b_\u0421\u041d\u0418\u041b\u0421"));
                                            this.put("\u0424\u0430\u043c\u0438\u043b\u0438\u044f", documentSetup.get("\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0421\u0432\u0424\u041b_\u0424\u0430\u043c\u0438\u043b\u0438\u044f"));
                                            this.put("\u0418\u043c\u044f", documentSetup.get("\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0421\u0432\u0424\u041b_\u0418\u043c\u044f"));
                                            this.put("\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e", documentSetup.get("\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f_\u0421\u0432\u0424\u041b_\u041e\u0442\u0447\u0435\u0441\u0442\u0432\u043e"));
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        };
        JSONObject jsonobject = new JSONObject((Map)params);
        JSONObject response = (JSONObject)this.doRequest("\u0421\u0411\u0418\u0421.\u0417\u0430\u043f\u0438\u0441\u0430\u0442\u044c\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", jsonobject, this.getToken());
        WriteDoc writeDoc = new WriteDoc();
        writeDoc.link = response.optString("\u0421\u0441\u044b\u043b\u043a\u0430\u0414\u043b\u044f\u041d\u0430\u0448\u0430\u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f");
        return writeDoc;
    }

    private String getToken() throws BGException, SbisJsonRpcException {
        String token = tokenMap.get(this.userId);
        if (token == null) {
            String login = this.plugin.getSetup().get("sbis.service.login");
            String password = this.plugin.getSetup().get("sbis.service.password");
            JSONObject loginPassword = new JSONObject();
            loginPassword.put("\u041b\u043e\u0433\u0438\u043d", (Object)login);
            loginPassword.put("\u041f\u0430\u0440\u043e\u043b\u044c", (Object)password);
            JSONObject params = new JSONObject();
            params.put("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", (Object)loginPassword);
            Object result = this.doAuthRequest("\u0421\u0411\u0418\u0421.\u0410\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c", params, null);
            token = (String)result;
            tokenMap.put(this.userId, token);
        }
        return token;
    }

    private String httpRequest(String url, String httpMethod, String data, String sessionId) throws BGException {
        String result = null;
        HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(url));
        if ("GET".equals(httpMethod)) {
            builder = builder.GET();
        } else if ("POST".equals(httpMethod)) {
            builder = builder.POST(HttpRequest.BodyPublishers.ofString(data));
        }
        builder.setHeader("Content-Type", "application/json-rpc;charset=utf-8");
        builder.setHeader("User-Agent", "BGBilling " + String.valueOf(VersionInfo.getVersionInfo((String)"kernel")));
        if (sessionId != null) {
            builder.setHeader("X-SBISSessionID", sessionId);
        }
        HttpRequest request = builder.build();
        try {
            this.getLogger().debug("-> {}", (Object)request);
            result = httpClient.send(request, HttpResponse.BodyHandlers.ofString()).body();
            this.getLogger().debug("<- {}", (Object)result);
        }
        catch (IOException ex) {
            throw new BGException("io error", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            throw new BGException("interrupt error", (Throwable)ex);
        }
        return result;
    }

    private Object jsonRequest(String url, String jsonMethod, JSONObject jsonParams, String sessionId) throws BGException, SbisJsonRpcException {
        JSONObject json = new JSONObject().put("jsonrpc", (Object)"2.0").put("method", (Object)jsonMethod).put("params", (Object)jsonParams).put("id", System.currentTimeMillis());
        JSONObject result = new JSONObject(this.httpRequest(url, "POST", json.toString(), sessionId));
        if (result.has("result")) {
            return result.get("result");
        }
        if (result.has("error")) {
            JSONObject error = result.getJSONObject("error");
            throw new SbisJsonRpcException(error.getInt("code"), error.getString("message"), error.getString("details"), error.getJSONObject("data"));
        }
        throw new BGException("error jsonrpc reply");
    }

    private Object doAuthRequest(String jsonMethod, JSONObject jsonParams, String sessionId) throws BGException, SbisJsonRpcException {
        String url = this.plugin.getSetup().get("sbis.auth.url", "https://online.sbis.ru/auth/service/");
        return this.jsonRequest(url, jsonMethod, jsonParams, sessionId);
    }

    private Object doRequest(String jsonMethod, JSONObject jsonParams, String sessionId) throws BGException, SbisJsonRpcException {
        String url = this.plugin.getSetup().get("sbis.service.url", "https://online.sbis.ru/service/?srv=1");
        return this.jsonRequest(url, jsonMethod, jsonParams, sessionId);
    }

    public static class WriteDoc {
        public String link;
    }

    public static class SbisJsonRpcException
    extends BGException {
        int code;
        String message;
        String details;
        JSONObject data;

        public SbisJsonRpcException(int code, String message, String details, JSONObject data) {
            super("JsonRpc error " + code + ": " + message);
            this.code = code;
            this.message = message;
            this.details = details;
            this.data = data;
        }
    }
}

