/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.contract;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGControlPanelMonthAndDays;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTimeButton;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.tv.client.contract.PeriodPanel;
import ru.bitel.bgbilling.modules.tv.client.contract.ProductFormBase;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccount;
import ru.bitel.bgbilling.modules.tv.common.service.TvAccountService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGTitleLabel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Idable;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOfferingActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;
import ru.bitel.oss.systems.order.product.common.service.ProductOrderService;

public class ProductPanel
extends BGUPanel {
    private String title;
    private Integer contractId;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private BGControlPanelMonthAndDays monthAndDays;
    private List<IdTitle> accounts = null;
    ProductForm productForm;
    ProductTableModel productModel;
    ProductTableModel historyModel;

    public ProductPanel(String title, ClientContext context) {
        super(context);
        this.title = title;
        this.contractId = context.getContractId();
    }

    protected void jbInit() {
        try {
            Directory productSpecDirectory = ((ClientContext)this.getContext()).getDirectory(ProductSpec.class, 0);
            this.productModel = new ProductTableModel("product", (Directory<ProductSpec>)productSpecDirectory);
            this.historyModel = new ProductTableModel("productHistory", (Directory<ProductSpec>)productSpecDirectory);
            BGUTable productTable = new BGUTable((TableModel)((Object)this.productModel));
            BGUTable historyTable = new BGUTable((TableModel)((Object)this.historyModel));
            this.productForm = new ProductForm((ClientContext)this.getContext());
            BGEditor editor = new BGEditor();
            editor.setVisible(false);
            editor.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
            editor.addForm((JComponent)((Object)this.productForm));
            BGDialogToolBar toolBar = new BGDialogToolBar();
            BGSwingUtilites.buildToolBar((BGDialogToolBar)toolBar, (JComponent)((Object)this.productForm));
            toolBar.compact();
            BGSwingUtilites.handleEdit((JTable)productTable, (AbstractBGUPanel)editor);
            BGSwingUtilites.handleEdit((JTable)historyTable, (AbstractBGUPanel)editor);
            this.tabbedPane.addTab("\u0422\u0435\u043a\u0443\u0449\u0438\u0435", BGSwingUtilites.wrapEmptyBorder((JComponent)new JScrollPane((Component)productTable)));
            this.tabbedPane.addTab("\u0418\u0441\u0442\u043e\u0440\u0438\u044f", this.getProductHistoryPanel(historyTable));
            JPanel productPanel = new JPanel(new BorderLayout());
            productPanel.add((Component)this.getToolbarPanel(toolBar), "North");
            productPanel.add((Component)this.tabbedPane, "Center");
            productPanel.add((Component)editor, "South");
            BGEditor editor2 = new BGEditor("productPanel");
            editor2.addForm((JComponent)productPanel, (Object)"productPanel");
            editor2.addForm((JComponent)((Object)new PeriodPanel(this)));
            this.setLayout(new BorderLayout());
            this.add((Component)editor2, "Center");
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private JPanel getToolbarPanel(BGDialogToolBar toolBar) {
        JPanel panel = new JPanel(new GridBagLayout());
        if (this.title != null) {
            panel.add((Component)new BGTitleLabel(this.title), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 5), 0, 0));
        }
        panel.add((Component)toolBar, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 20, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getProductHistoryPanel(BGUTable historyTable) {
        this.monthAndDays = new BGControlPanelMonthAndDays(true);
        this.monthAndDays.addActionListener((ActionListener)this.productForm.getActionMap().get("refresh"));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 5, 0), 0, 0));
        panel.add((Component)this.monthAndDays, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        panel.add((Component)new JScrollPane((Component)historyTable), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        return panel;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.productForm.activate.setEnabled(enabled);
        this.productForm.deactivate.setEnabled(enabled);
        this.productForm.getActionMap().get("new").setEnabled(enabled);
        this.productForm.getActionMap().get("edit").setEnabled(enabled);
        this.productForm.getActionMap().get("delete").setEnabled(enabled);
    }

    class ProductTableModel
    extends BGTableModel<Product> {
        private Directory<ProductSpec> productSpecDirectory;
        private Map<Integer, TvAccount> tvAccountMap;

        public ProductTableModel(String name, Directory<ProductSpec> productSpecDirectory) throws BGException {
            super(name);
            this.productSpecDirectory = null;
            this.productSpecDirectory = productSpecDirectory;
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041f\u0440\u043e\u0434\u0443\u043a\u0442", -1, 180, -1, "product", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0410\u043a\u043a\u0430\u0443\u043d\u0442", -1, 180, -1, "accountId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041d\u0430\u0447\u0430\u043b\u043e", 150, 150, 150, "timeFrom", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435", 150, 150, 150, "timeTo", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041e\u043f\u043b\u0430\u0447\u0435\u043d\u043e \u0434\u043e", 150, 150, 150, "subscriptionTimeTo", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", 120, 120, 120, "deviceState", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c (\u0438\u0437 MW)", 140, 140, 140, "activationPrice", true, (TableCellRenderer)DecimalTableCellRenderer.DEFAULT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 80, 200, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(Product product, int column) throws Exception {
            String identifier = this.getIdentifier(column);
            if ("product".equals(identifier)) {
                try {
                    return ((ProductSpec)this.productSpecDirectory.get(product.getProductSpecId())).getGuiTitle();
                }
                catch (BGException ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                    return ex.getMessage();
                }
            }
            if ("accountId".equals(identifier)) {
                TvAccount tvAccount = this.tvAccountMap.get(product.getAccountId());
                return tvAccount == null ? "ID#" + product.getAccountId() : tvAccount.getGuiTitle();
            }
            if ("deviceState".equals(identifier)) {
                return product.getDeviceState() == 1 ? "\u0432\u043a\u043b\u044e\u0447\u0435\u043d" : "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d";
            }
            return super.getValue((Object)product, column);
        }

        public void setTvAccountMap(Map<Integer, TvAccount> tvAccountMap) {
            this.tvAccountMap = tvAccountMap;
        }
    }

    class ProductForm
    extends ProductFormBase {
        AbstractBGUPanel.DefaultAction activate;
        AbstractBGUPanel.DefaultAction deactivate;

        public ProductForm(ClientContext context) {
            super(context);
            this.activate = new AbstractBGUPanel.DefaultAction("activate", "\u0410\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442", ClientUtils.getIcon((String)"fugue/present--plus")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (ProductPanel.this.tabbedPane.getSelectedIndex() != 0) {
                        return;
                    }
                    try {
                        ((ProductOrderService)((ClientContext)ProductForm.this.getContext()).getWebService(ProductOrderService.class, 0)).isAllowProductActivate(((ClientContext)ProductForm.this.getContext()).getModuleId(), ProductPanel.this.contractId.intValue());
                    }
                    catch (BGException ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                        return;
                    }
                    new ProductEditor("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", Product.builder().build(), "activate", ProductPanel.this.accounts, null).open();
                    ProductForm.this.performAction("refresh");
                }
            };
            this.deactivate = new AbstractBGUPanel.DefaultAction("deactivate", "\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442", ClientUtils.getIcon((String)"fugue/present--minus")){

                public void actionPerformedImpl(ActionEvent e) throws Exception {
                    if (ProductPanel.this.tabbedPane.getSelectedIndex() != 0) {
                        return;
                    }
                    Product current = (Product)ProductPanel.this.productModel.getSelectedRow();
                    if (current != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442?", "\u0414\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f", 0) == 0) {
                        ((ProductOrderService)((ClientContext)ProductForm.this.getContext()).getWebService(ProductOrderService.class, 0)).productDeactivate(((ClientContext)ProductForm.this.getContext()).getContractId(), current.getId(), null, false, true, false);
                        ProductForm.this.performAction("refresh");
                    }
                }
            };
        }

        protected void initActions() {
            new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
                GregorianCalendar calendar = new GregorianCalendar();
                ((Calendar)calendar).add(12, -10);
                LocalDate dateFrom = ProductPanel.this.monthAndDays.getBeginDate();
                LocalDateTime dateTo = ProductPanel.this.monthAndDays.getEndDate().atStartOfDay();
                dateTo = dateTo.plusDays(1L);
                dateTo = dateTo.plusNanos(-1L);
                int moduleId = ((ClientContext)this.getContext()).getModuleId();
                ProductListData result = new ProductListData();
                ProductService productService = (ProductService)((ClientContext)this.getContext()).getWebService(ProductService.class, 0);
                result.productModelData = productService.productList(moduleId, ProductPanel.this.contractId.intValue(), 0, false, null, null, calendar.getTime(), null, true, true);
                result.historyModelData = productService.productList(moduleId, ProductPanel.this.contractId.intValue(), 0, false, null, calendar.getTime(), TimeUtils.convertLocalDateToDate((LocalDate)dateFrom), TimeUtils.convertLocalDateTimeToDate((LocalDateTime)dateTo), true, true);
                List list = ((TvAccountService)((ClientContext)this.getContext()).getWebService(TvAccountService.class)).tvAccounContracttList(((ClientContext)this.getContext()).getContractId());
                list.forEach(a -> result.tvAccountMap.put(a.getId(), (TvAccount)a));
                ProductPanel.this.accounts = new ArrayList<IdTitle>();
                ProductPanel.this.accounts.add(new IdTitle(0, "\u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442"));
                ProductPanel.this.accounts.addAll(list.stream().filter(a -> a.getParentId() < 1).map(IdTitle::toIdTitle).toList());
                ProductPanel.this.productModel.setTvAccountMap(result.tvAccountMap);
                ProductPanel.this.productModel.setData(result.productModelData);
                ProductPanel.this.historyModel.setTvAccountMap(result.tvAccountMap);
                ProductPanel.this.historyModel.setData(result.historyModelData);
            });
            new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> {
                try {
                    List<ProductOffering> offerings = this.toProductOfferingList(((ClientContext)this.getContext()).getDirectory(ProductSpec.class, 0).list());
                    new ProductEditor("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", Product.builder().build(), "add", ProductPanel.this.accounts, offerings).open();
                    this.performAction("refresh");
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }).setIcon((Icon)ClientUtils.getIcon((String)"item_add"));
            new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
                Product current;
                Product product = current = ProductPanel.this.tabbedPane.getSelectedIndex() == 0 ? (Product)ProductPanel.this.productModel.getSelectedRow() : (Product)ProductPanel.this.historyModel.getSelectedRow();
                if (current != null) {
                    try {
                        List<ProductOffering> offerings = this.toProductOfferingList(((ClientContext)this.getContext()).getDirectory(ProductSpec.class, 0).list());
                        new ProductEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430", current, "edit", ProductPanel.this.accounts, offerings).open();
                        this.performAction("refresh");
                    }
                    catch (Exception ex) {
                        ClientUtils.showErrorMessageDialog((Throwable)ex);
                    }
                }
            }).setIcon((Icon)ClientUtils.getIcon((String)"item_edit"));
            new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
                Product current;
                Product product = current = ProductPanel.this.tabbedPane.getSelectedIndex() == 0 ? (Product)ProductPanel.this.productModel.getSelectedRow() : (Product)ProductPanel.this.historyModel.getSelectedRow();
                if (current != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0443\u043a\u0442?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                    ((ProductService)((ClientContext)this.getContext()).getWebService(ProductService.class, 0)).productDelete(current.getContractId(), current.getId());
                    this.performAction("refresh");
                }
            }).setIcon((Icon)ClientUtils.getIcon((String)"item_delete"));
        }
    }

    class ProductEditor
    extends BGEditorDialog<Product> {
        private String mode;
        private List<ProductOffering> offerings;
        private List<IdTitle> accounts;
        private BGUComboBox<IdTitle> tvAccount;
        private BGUComboBox<ProductOfferingItem> productSpec;
        private BGUComboBox<ProductOfferingActivationMode> activationMode;
        private BGCalendarButton dateFrom;
        private BGTimeButton timeFrom;
        private BGCalendarButton dateTo;
        private BGTimeButton timeTo;
        private JTextArea comment;
        private JTabbedPane tabbedPane;
        private JTextField description;

        public ProductEditor(String title, Product data, String mode, List<IdTitle> accounts, List<ProductOffering> offerings) {
            super(title, (Object)data);
            this.mode = null;
            this.offerings = null;
            this.accounts = null;
            this.tvAccount = new BGUComboBox();
            this.productSpec = new BGUComboBox();
            this.activationMode = new BGUComboBox();
            this.dateFrom = new BGCalendarButton();
            this.timeFrom = new BGTimeButton();
            this.dateTo = new BGCalendarButton();
            this.timeTo = new BGTimeButton();
            this.comment = new JTextArea(10, 30);
            this.tabbedPane = new JTabbedPane();
            this.description = new JTextField(30);
            this.mode = mode;
            this.accounts = accounts;
            this.offerings = offerings;
        }

        public void doDialogPanel() {
            LocalDateTime from;
            this.tabbedPane.add((Component)this.getBasePanel(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
            this.tabbedPane.add((Component)this.getCommentPanel(), "\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439");
            this.panel.add((Component)this.tabbedPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
            this.tvAccount.setData(this.accounts);
            this.tvAccount.addItemListener(e -> Async.of(() -> {
                if (e.getStateChange() == 1) {
                    this.setProductOffering();
                }
            }));
            this.tvAccount.setEnabled(((Product)this.data).getAccountId() < 1);
            if (((Product)this.data).getAccountId() > 0) {
                this.tvAccount.setSelectedItem((Object)this.accounts.stream().filter(a -> a.getId() == ((Product)this.data).getAccountId()).findFirst().orElse(this.accounts.get(0)));
            } else {
                this.tvAccount.setSelectedItem((Object)this.accounts.get(this.accounts.size() == 2 ? 1 : 0));
            }
            this.productSpec.setEnabled(((Product)this.data).getProductSpecId() < 1);
            if (((Product)this.data).getProductSpecId() > 0) {
                try {
                    ProductOffering productOffering = new ProductOffering();
                    productOffering.setProductSpec(((ProductService)((ClientContext)ProductPanel.this.getContext()).getWebService(ProductService.class, 0)).productSpecGet(((Product)this.data).getProductSpecId()));
                    this.productSpec.setData(Arrays.asList(ProductOfferingItem.toProductOfferingItem(productOffering)));
                    this.productSpec.setSelectedIndex(0);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            this.activationMode.setEnabled(((Product)this.data).getActivationModeId() < 1);
            if (((Product)this.data).getActivationModeId() > 0) {
                try {
                    ProductOfferingActivationMode productOfferingActivationMode = new ProductOfferingActivationMode();
                    productOfferingActivationMode.setProductSpecActivationMode(((ProductService)((ClientContext)ProductPanel.this.getContext()).getWebService(ProductService.class, 0)).productSpecActivationModeGet(((Product)this.data).getActivationModeId()));
                    this.activationMode.setData(Arrays.asList(productOfferingActivationMode));
                    this.activationMode.setSelectedIndex(0);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            this.dateFrom.setLocalDate((from = TimeUtils.convertDateToLocalDateTime((Date)((Product)this.data).getTimeFrom())) != null ? from.toLocalDate() : null);
            this.timeFrom.setTime(from != null ? from.toLocalTime() : null);
            LocalDateTime to = TimeUtils.convertDateToLocalDateTime((Date)((Product)this.data).getTimeTo());
            this.dateTo.setLocalDate(to != null ? to.toLocalDate() : null);
            this.timeTo.setTime(to != null ? to.toLocalTime() : null);
            boolean toEnabled = !"activate".equals(this.mode);
            this.dateTo.setEnabled(toEnabled);
            this.timeTo.setEnabled(toEnabled);
            this.description.setText(((Product)this.data).getDescription());
            this.comment.setText(((Product)this.data).getComment());
        }

        public boolean doApply() throws Exception {
            int accountId = ((IdTitle)this.tvAccount.getSelectedItem()).getId();
            if (accountId < 1) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442");
                return false;
            }
            ((Product)this.data).setTimeFrom(this.getDate(this.dateFrom.getLocalDate(), this.timeFrom.getTime()));
            ((Product)this.data).setTimeTo(this.getDate(this.dateTo.getLocalDate(), this.timeTo.getTime()));
            if (((Product)this.data).getTimeFrom() == null) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430");
                return false;
            }
            ProductOffering selectedProduct = ((ProductOfferingItem)this.productSpec.getSelectedItem()).productOffering;
            if (!this.checkIncompatible(selectedProduct, (Product)this.data, accountId)) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 \u0443\u0436\u0435 \u0438\u043c\u0435\u044e\u0449\u0438\u043c\u0438\u0441\u044f");
                return false;
            }
            if (selectedProduct == null) {
                return false;
            }
            if (this.activationMode.getSelectedItem() == null) {
                return false;
            }
            ((Product)this.data).setProductSpecId(selectedProduct.getProductSpec().getId());
            ((Product)this.data).setActivationModeId(((ProductOfferingActivationMode)this.activationMode.getSelectedItem()).getProductSpecActivationMode().getId());
            ((Product)this.data).setAccountId(accountId);
            ((Product)this.data).setContractId(((ClientContext)ProductPanel.this.getContext()).getContractId());
            ((Product)this.data).setDescription(this.description.getText());
            ((Product)this.data).setComment(this.comment.getText());
            if ("activate".equals(this.mode)) {
                Date time = null;
                if (((Product)this.data).getTimeFrom() != null && Math.abs(TimeUtils.daysDelta((Date)((Product)this.data).getTimeFrom(), (Date)new Date())) < 210) {
                    time = ((Product)this.data).getTimeFrom();
                }
                ((ProductOrderService)((ClientContext)ProductPanel.this.getContext()).getWebService(ProductOrderService.class, 0)).productActivate((Product)this.data, time, false, true);
            } else {
                ((ProductService)((ClientContext)ProductPanel.this.getContext()).getWebService(ProductService.class, 0)).productUpdate((Product)this.data);
            }
            return true;
        }

        private void setProductOffering() {
            int tvAccountid;
            IdTitle idTitle = (IdTitle)this.tvAccount.getSelectedItem();
            if (idTitle != null && (tvAccountid = idTitle.getId()) > 0) {
                int moduleId = ((ClientContext)ProductPanel.this.getContext()).getModuleId();
                try {
                    if ("activate".equals(this.mode)) {
                        this.offerings = ((ProductOrderService)((ClientContext)ProductPanel.this.getContext()).getWebService(ProductOrderService.class, 0)).productOfferingList(Integer.valueOf(((ClientContext)ProductPanel.this.getContext()).getModuleId()), ProductPanel.this.contractId.intValue(), tvAccountid, -1, new Date(), true, false);
                        this.offerings = this.offerings.stream().filter(a -> a.getProductSpec().getModuleId() == moduleId).toList();
                    }
                    this.productSpec.setData(this.offerings.stream().map(ProductOfferingItem::toProductOfferingItem).toList());
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        }

        private boolean checkIncompatible(ProductOffering newProduct, Product product, int accountId) throws Exception {
            if (newProduct == null) {
                return true;
            }
            List productsOnContract = ((ProductService)((ClientContext)ProductPanel.this.getContext()).getWebService(ProductService.class, 0)).productList(((ClientContext)ProductPanel.this.getContext()).getModuleId(), ProductPanel.this.contractId.intValue(), accountId, false, null, null, new Date(), new Date(), true, true);
            if (productsOnContract.stream().anyMatch(p -> p.getId() == product.getId())) {
                return true;
            }
            Set incompatible = newProduct.getProductSpec().getIncompatible();
            if (Utils.isEmptyCollection((Collection)incompatible)) {
                return true;
            }
            for (Product contractProduct : productsOnContract) {
                int productSpecId = contractProduct.getProductSpecId();
                if (!incompatible.contains(productSpecId) || contractProduct.getTimeTo() != null && !contractProduct.getTimeTo().after(product.getTimeFrom())) continue;
                return false;
            }
            return true;
        }

        private Date getDate(LocalDate localDate, LocalTime localTime) {
            Date date = null;
            if (localDate != null) {
                date = TimeUtils.convertLocalDateTimeToDate((LocalDateTime)LocalDateTime.of(localDate, localTime != null ? localTime : LocalTime.of(0, 0)));
            }
            return date;
        }

        private JPanel getBasePanel() {
            this.productSpec.addActionListener(e -> {
                ProductOffering selected = ((ProductOfferingItem)this.productSpec.getSelectedItem()).productOffering;
                if (selected != null) {
                    ProductOfferingActivationMode currentMode;
                    List list = selected.getActivationModeList();
                    this.activationMode.setData(list);
                    if (this.data != null && ((Product)this.data).getActivationModeId() > 0 && (currentMode = (ProductOfferingActivationMode)Utils.maskNull((List)list).stream().filter(a -> a.getProductSpecActivationMode().getId() == ((Product)this.data).getActivationModeId()).findFirst().orElse(null)) != null) {
                        this.activationMode.setSelectedItem((Object)currentMode);
                    }
                }
            });
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0410\u043a\u043a\u0430\u0443\u043d\u0442:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.tvAccount, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0440\u043e\u0434\u0443\u043a\u0442:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.productSpec, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.activationMode, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.getPeriodPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
            panel.add((Component)this.description, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 5), 0, 0));
            return panel;
        }

        private JPanel getCommentPanel() {
            this.comment.setMargin(new Insets(3, 3, 3, 3));
            this.comment.setWrapStyleWord(true);
            this.comment.setLineWrap(true);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JScrollPane(this.comment), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
            return panel;
        }

        private JPanel getPeriodPanel() {
            int gridx = 0;
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.dateFrom, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
            panel.add((Component)new JLabel(":"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.timeFrom, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.dateTo, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)new JLabel(":"), new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.add((Component)this.timeTo, new GridBagConstraints(gridx++, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        static class ProductOfferingItem
        implements GuiTitlable,
        Idable {
            public ProductOffering productOffering;
            public String title;

            ProductOfferingItem() {
            }

            static ProductOfferingItem toProductOfferingItem(ProductOffering productOffering) {
                ProductOfferingItem item = new ProductOfferingItem();
                item.productOffering = productOffering;
                item.title = productOffering.getGuiTitle();
                return item;
            }

            public String getGuiTitle() {
                return this.title;
            }

            public int getId() {
                return this.productOffering.getId();
            }
        }
    }

    static class ProductListData {
        List<Product> productModelData;
        List<Product> historyModelData;
        Map<Integer, TvAccount> tvAccountMap = new HashMap<Integer, TvAccount>();

        ProductListData() {
        }
    }
}

