/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sberbank.client;

import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import ru.bitel.bgbilling.client.common.AbstractTransactionPanel;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.BGAbstractTransaction;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.modules.sberbank.client.TransactionTableModel;
import ru.bitel.bgbilling.modules.sberbank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.sberbank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.sberbank.common.service.SberbankService;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.model.SearchResult;

public class TransactionPanel
extends AbstractTransactionPanel {
    public TransactionPanel() {
        this.initTypeComboBox();
        this.autopayment = new JToggleButton("\u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0438");
        this.statusComboBox.setModel(new DefaultComboBoxModel<TransactionStatus>(TransactionStatus.values()));
    }

    protected BGButton getCheckButton() {
        BGButton button = new BGButton("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c...");
        button.setToolTipText("\u0417\u0430\u043f\u0443\u0441\u0442\u0438\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0443 \u0432\u0441\u0435\u0445 \u043d\u0435 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044b\u0445 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439");
        button.addActionListener(event -> {
            try {
                ((SberbankService)((ClientContext)this.getContext()).getPort(SberbankService.class)).checkTransactions(this.getContractId());
                this.performAction("refresh");
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        });
        return button;
    }

    protected JMenuItem getTransactionDataMenuItem() {
        return new JMenuItem("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(e -> {
                    Object selectedTransaction = TransactionPanel.this.transactionModel.getSelectedRow();
                    if (selectedTransaction != null && selectedTransaction instanceof Transaction) {
                        Transaction transaction = (Transaction)selectedTransaction;
                        JTextArea textArea = new JTextArea(transaction.getParameters(), 20, 50);
                        textArea.setMargin(new Insets(5, 5, 5, 5));
                        textArea.setEditable(false);
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), new JScrollPane(textArea), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438", 1);
                    }
                });
            }
        };
    }

    protected JMenuItem getTransactionStatusMenuItem() {
        return new JMenuItem("\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c \u0441\u0442\u0430\u0442\u0443\u0441 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(e -> {
                    Object selectedTransaction = TransactionPanel.this.transactionModel.getSelectedRow();
                    if (selectedTransaction != null && selectedTransaction instanceof Transaction) {
                        Transaction transaction = (Transaction)selectedTransaction;
                        try {
                            ((SberbankService)((ClientContext)TransactionPanel.this.getContext()).getPort(SberbankService.class)).checkTransaction(transaction.getId());
                            TransactionPanel.this.performAction("refresh");
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                });
            }
        };
    }

    protected JMenuItem getReverseMenuItem() {
        return new JMenuItem("\u041e\u0442\u043c\u0435\u043d\u0430 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(e -> {
                    Object selectedPayment = TransactionPanel.this.transactionModel.getSelectedRow();
                    if (selectedPayment != null && selectedPayment instanceof Transaction) {
                        Transaction transaction = (Transaction)selectedPayment;
                        if (transaction.getStatus().equals(TransactionStatus.APPROVED.getCode())) {
                            if (TransactionPanel.this.checkDate(transaction.getTransactionDate())) {
                                JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0432 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0435...", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                            } else {
                                ClientUtils.showErrorMessageDialog((String)"\u041e\u0442\u043c\u0435\u043d\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0432 \u0434\u0435\u043d\u044c \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438");
                            }
                        } else {
                            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u041e\u0442\u043c\u0435\u043d\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0439 \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u043c \"\u041e\u0434\u043e\u0431\u0440\u0435\u043d\u043d\u0430\u044f\"", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0);
                        }
                    }
                });
            }
        };
    }

    private boolean checkDate(Date date) {
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar transactionDate = new GregorianCalendar();
        transactionDate.setTime(date);
        boolean result = now.get(1) == transactionDate.get(1);
        result &= now.get(2) == transactionDate.get(2);
        return result &= now.get(5) == transactionDate.get(5);
    }

    protected JMenuItem getRefundMenuItem() {
        return new JMenuItem("\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u0438"){
            {
                this.addActionListener(e -> {
                    Object selectedPayment = TransactionPanel.this.transactionModel.getSelectedRow();
                    if (selectedPayment != null && selectedPayment instanceof BGAbstractTransaction) {
                        JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0424\u0443\u043d\u043a\u0446\u0438\u044f \u0432 \u0440\u0430\u0437\u0440\u0430\u0431\u043e\u0442\u043a\u0435...", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 1);
                    }
                });
            }
        };
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            SearchParam searchParam = SearchParam.builder().setContractId(this.getContractId()).setContractTitle(this.contractTitleField.getText()).setStatus(((AbstractTransactionStatus)this.statusComboBox.getSelectedItem()).getCode()).setType(this.typeComboBox != null ? (String)this.typeComboBox.getSelectedItem() : null).setAutopayment(this.autopayment != null ? Boolean.valueOf(this.autopayment.isSelected()) : null).setPeriod(this.periodPanel.getPeriod()).setSort(this.getTable().getSort()).setPage(this.pagePanel.getPage()).build();
            SearchResult searchResult = ((SberbankService)((ClientContext)this.getContext()).getPort(SberbankService.class)).searchTransactionList(searchParam);
            ((TransactionTableModel)this.transactionModel).setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getPage().getRecordCount());
            this.summaField.setText(new DecimalFormat("###,###,##0.00").format(searchResult.getSum()));
        });
    }
}

