/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.card.server.bean.CardAction;
import ru.bitel.bgbilling.modules.card.server.bean.CardActionCardManager;
import ru.bitel.bgbilling.modules.card.server.bean.CardActionManager;
import ru.bitel.bgbilling.modules.card.server.bean.CardManager;
import ru.bitel.bgbilling.modules.card.server.bean.CardSeriesManager;
import ru.bitel.bgbilling.modules.card.server.bean.DealerDao;
import ru.bitel.common.Utils;

public class ActionCardDealerAdd
extends ActionBase {
    public void doAction() throws Exception {
        List<Object> cards;
        int mid = this.getIntParameter("mid", -1);
        int did = this.getIntParameter("did", -1);
        StringBuilder buf = new StringBuilder(this.getParameter("buf", ""));
        String seriesCount = this.getParameter("series_count");
        if (mid < 0 || did < 0) {
            throw new BGIllegalArgumentException();
        }
        if (Utils.isBlankString((String)buf.toString()) && Utils.isBlankString((String)seriesCount)) {
            throw new BGMessageException("\u041d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d\u044b \u043a\u0430\u0440\u0442\u044b \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0434\u0430\u0447\u0438!");
        }
        CardManager cardManager = new CardManager(this.con, mid);
        CardSeriesManager seriesManager = new CardSeriesManager(this.con, mid);
        CardActionManager actionManager = new CardActionManager(this.con, mid);
        CardActionCardManager actionCardManager = new CardActionCardManager(this.con, mid);
        if (Utils.notBlankString((String)seriesCount)) {
            buf.setLength(0);
            StringTokenizer st = new StringTokenizer(seriesCount, ";");
            while (st.hasMoreTokens()) {
                int count;
                String token = st.nextToken().trim();
                String[] series_count = token.split(":");
                if (series_count.length != 2) continue;
                int series = Utils.parseInt((String)series_count[0]);
                cards = seriesManager.getCardsFromSeries(series, count = Utils.parseInt((String)series_count[1]));
                if (cards.size() < count) {
                    throw new BGMessageException("\u0412 \u043e\u0434\u043d\u043e\u0439 \u0438\u0437 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0445 \u0441\u0435\u0440\u0438\u0439 \u043d\u0435\u0442 \u043d\u0443\u0436\u043d\u043e\u0433\u043e \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u043a\u0430\u0440\u0442!");
                }
                if (buf.length() > 0) {
                    buf.append(",");
                }
                buf.append(Utils.toString(cards));
            }
        }
        float summ = 0.0f;
        int count = 0;
        HashSet<Integer> seriesSet = new HashSet<Integer>();
        Dealer dealer = new DealerDao(this.con, mid).get(did);
        if (dealer == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u0438\u043b\u0435\u0440 " + did);
        }
        ArrayList<Long> cardToMoveId = new ArrayList<Long>();
        cards = cardManager.getCards(buf.toString());
        for (Card card : cards) {
            if (card.getStatus() == 0) {
                summ += card.getSumma();
                ++count;
                seriesSet.add(card.getSeriesId());
                cardToMoveId.add(card.getId());
                continue;
            }
            throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0432\u044b\u0434\u0430\u0442\u044c \u043a\u0430\u0440\u0442\u0443 " + card.getId());
        }
        GregorianCalendar now = new GregorianCalendar();
        cardManager.addCardsToDealer(did, now, Utils.toString(cardToMoveId));
        CardAction cardAction = new CardAction();
        cardAction.setType(1);
        cardAction.setTime(now);
        cardAction.setDealerId(did);
        cardAction.setCardCount(count);
        cardAction.setCardSumma(summ);
        cardAction.setCost(summ - summ * dealer.getCardPercent() / 100.0f);
        actionManager.updateAction(cardAction);
        actionCardManager.updateCards(cardAction.getId(), cardToMoveId);
        Iterator iterator = seriesSet.iterator();
        while (iterator.hasNext()) {
            int ser = (Integer)iterator.next();
            seriesManager.updateSeriesFree(ser);
        }
    }
}

