/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius.info;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.info.BinaryInfo;
import ru.bitel.bgbilling.kernel.network.tlv.Tlv;
import ru.bitel.common.Utils;

public class TlvInfo
extends RadiusAttributeInfo<Map<Integer, RadiusAttribute<?>>> {
    public TlvInfo(int vendor, int code, String name, Element attr, List<RadiusAttributeInfo<?>> children) {
        super(vendor, code, name, 9, attr, children);
    }

    @Override
    public RadiusAttribute<?> read(ByteBuffer bb, RadiusAttributeInfo.RadiusAttributeHeader header) {
        int[] tag = new int[1];
        int allDataLength = header.length;
        ByteBuffer data = this.sliceData(bb, allDataLength);
        ByteBuffer dataWithoutTag = this.tagUnwrap(data, header);
        if (this.continuation) {
            dataWithoutTag = this.readWithContinuation(dataWithoutTag, bb);
        }
        Object result = this.unwrapValue(dataWithoutTag);
        return new RadiusAttribute<Object>(this, tag[0], dataWithoutTag, result);
    }

    @Override
    public Map<Integer, RadiusAttribute<?>> unwrapValue(ByteBuffer bb) {
        HashMap result = new HashMap(8);
        RadiusAttributeInfo.RadiusAttributeHeader header = new RadiusAttributeInfo.RadiusAttributeHeader();
        while (bb.hasRemaining()) {
            header.vendor = -1;
            header.type = 0;
            header.length = 0;
            header.tag = 0;
            this.readTypeLength(bb, header, 0, true);
            RadiusAttributeInfo info = (RadiusAttributeInfo)this.getChild(header.type);
            if (info != null) {
                result.put(header.type, info.read(bb, header));
                continue;
            }
            String name = "UNKNOWN[" + header.vendor + "-" + header.type + "]";
            info = new BinaryInfo(header.vendor, header.type, name, 0, 1, 1, false, false, null);
            result.put(header.type, info.read(bb, header));
        }
        bb.rewind();
        return result;
    }

    @Override
    public ByteBuffer wrapValue(Map<Integer, RadiusAttribute<?>> value) {
        ByteBuffer result = ByteBuffer.allocate(4096);
        for (RadiusAttribute<?> ra : value.values()) {
            ra.write(result);
        }
        result.flip();
        ByteBuffer b = result.slice();
        System.err.println(Utils.bytesToString(Utils.byteBufferAsArray(b)));
        return result.slice();
    }

    @Override
    public String valueToString(Tlv<?, Map<Integer, RadiusAttribute<?>>> attribute) {
        StringBuilder sb = new StringBuilder();
        sb.append("{\n    ");
        for (Map.Entry<Integer, RadiusAttribute<?>> e : attribute.getValue().entrySet()) {
            sb.append(e.getValue().toString(true)).append("\n    ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("}");
        return sb.toString();
    }
}

