/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.common.bean;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.time.LocalDateTime;
import java.util.Date;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.xml.XmlAdapters;

public class ContractNote
extends IdTitle {
    private String comment;
    private int contractId;
    private LocalDateTime dateTime;
    private int userId;
    private boolean visible = false;

    public String getComment() {
        return this.comment;
    }

    @XmlAttribute
    public int getContractId() {
        return this.contractId;
    }

    public Date getDate() {
        return this.dateTime != null ? TimeUtils.convertLocalDateTimeToDate((LocalDateTime)this.dateTime) : null;
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(type=LocalDateTime.class, value=XmlAdapters.LocalDateTimeAdapter.class)
    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    @XmlAttribute
    public int getUserId() {
        return this.userId;
    }

    @XmlAttribute
    public boolean isVisible() {
        return this.visible;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setContractId(int contractId) {
        this.contractId = contractId;
    }

    public void setDateTime(LocalDateTime time) {
        this.dateTime = time;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ContractNote note = new ContractNote();

        private Builder() {
        }

        public Builder setId(int id) {
            this.note.id = id;
            return this;
        }

        public Builder setTitle(String title) {
            this.note.title = title;
            return this;
        }

        public Builder setComment(String comment) {
            this.note.comment = comment;
            return this;
        }

        public Builder setContractId(int contractId) {
            this.note.contractId = contractId;
            return this;
        }

        public Builder setDateTime(LocalDateTime time) {
            this.note.dateTime = time;
            return this;
        }

        public Builder setUserId(int userId) {
            this.note.userId = userId;
            return this;
        }

        public Builder setVisible(boolean visible) {
            this.note.visible = visible;
            return this;
        }

        public ContractNote build() {
            try {
                ContractNote contractNote = this.note;
                return contractNote;
            }
            finally {
                this.note = null;
            }
        }
    }
}

