/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common.table.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.table.tree.TreeNode;
import ru.bitel.bgbilling.client.common.table.tree.TreeTableModel;
import ru.bitel.bgbilling.client.common.table.tree.TreeTableModelAdapter;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;

    public JTreeTable(final TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(18);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TreePath path = JTreeTable.this.tree.getSelectionPath();
                    if (treeTableModel.isCellEditable(path.getLastPathComponent(), 0)) {
                        if (JTreeTable.this.tree.isExpanded(path)) {
                            JTreeTable.this.tree.collapsePath(path);
                        } else {
                            JTreeTable.this.tree.expandPath(path);
                        }
                        JTreeTable.this.tree.setSelectionPath(path);
                    }
                    e.consume();
                }
            }
        });
        this.setFillsViewportHeight(true);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
            this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    @Override
    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == TreeTableModel.class ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    @Override
    public void sizeColumnsToFit(int resizingColumn) {
        super.sizeColumnsToFit(resizingColumn);
        if (this.getEditingColumn() != -1 && this.getColumnClass(this.editingColumn) == TreeTableModel.class) {
            Rectangle cellRect = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        }
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean retValue = super.editCellAt(row, column, e);
        if (retValue && this.getColumnClass(column) == TreeTableModel.class) {
            this.repaint(this.getCellRect(row, column, false));
        }
        return retValue;
    }

    public final void addTreeWillExpandListener(TreeWillExpandListener l) {
        this.tree.addTreeWillExpandListener(l);
    }

    public final void addPopupMenu(JPopupMenu menu) {
        this.addPopupMenu(menu, false);
    }

    public final void addPopupMenu(final JPopupMenu menu, final boolean single) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.evaluatePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.evaluatePopup(e);
            }

            private void evaluatePopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    int row;
                    if (single && (row = JTreeTable.this.rowAtPoint(e.getPoint())) > 0) {
                        JTreeTable.this.getSelectionModel().setSelectionInterval(row, row);
                    }
                    menu.show(JTreeTable.this, e.getX(), e.getY());
                }
            }
        });
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;
        protected Border highlightBorder;
        protected TreeTableModel model;

        @Override
        public void scrollPathToVisible(TreePath path) {
            super.scrollPathToVisible(path);
            Rectangle bounds = this.getPathBounds(path);
            if (bounds != null) {
                JTreeTable.this.scrollRectToVisible(bounds);
            }
        }

        public TreeTableCellRenderer(TreeTableModel model) {
            super(model);
            this.model = model;
            this.setRootVisible(false);
            model.init(this);
            this.setCellRenderer(new DefaultTreeCellRenderer(){

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    Icon icon;
                    Component result = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                    if (value instanceof TreeNode && (icon = ((TreeNode)value).getIcon()) != null) {
                        this.setIcon(icon);
                    }
                    return result;
                }
            });
        }

        @Override
        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, g, 0, this.visibleRow * this.getRowHeight(), this.getWidth(), this.getRowHeight());
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color foreground;
            Color background;
            if (isSelected) {
                background = table.getSelectionBackground();
                foreground = table.getSelectionForeground();
            } else {
                background = table.getBackground();
                foreground = table.getForeground();
            }
            this.highlightBorder = null;
            if (JTreeTable.this.realEditingRow() == row && JTreeTable.this.getEditingColumn() == column) {
                background = UIManager.getColor("Table.focusCellBackground");
                foreground = UIManager.getColor("Table.focusCellForeground");
            } else if (hasFocus) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.visibleRow = row;
            this.setBackground(background);
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                if (isSelected) {
                    dtcr.setTextSelectionColor(foreground);
                    dtcr.setBackgroundSelectionColor(background);
                } else {
                    dtcr.setTextNonSelectionColor(foreground);
                    dtcr.setBackgroundNonSelectionColor(background);
                }
            }
            return this;
        }

        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object sValue;
            if (value != null && this.model != null && (sValue = this.model.getValueAt(value, 0)) != null) {
                return sValue.toString();
            }
            return "";
        }

        @Override
        public void clearToggledPaths() {
            super.clearToggledPaths();
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    ArrayList<TreePath> paths = new ArrayList<TreePath>();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            paths.add(selPath);
                        }
                    }
                    this.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends DefaultCellEditor {
        public TreeTableCellEditor() {
            super(new TreeTableTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            Component component = super.getTableCellEditorComponent(table, value, isSelected, r, c);
            JTree t = JTreeTable.this.getTree();
            boolean rv = t.isRootVisible();
            int offsetRow = rv ? r : r - 1;
            Rectangle bounds = t.getRowBounds(offsetRow);
            int offset = bounds.x;
            TreeCellRenderer tcr = t.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                Object node = t.getPathForRow(offsetRow).getLastPathComponent();
                Icon icon = t.getModel().isLeaf(node) ? ((DefaultTreeCellRenderer)tcr).getLeafIcon() : (JTreeTable.this.tree.isExpanded(offsetRow) ? ((DefaultTreeCellRenderer)tcr).getOpenIcon() : ((DefaultTreeCellRenderer)tcr).getClosedIcon());
                if (icon != null) {
                    offset += ((DefaultTreeCellRenderer)tcr).getIconTextGap() + icon.getIconWidth();
                }
            }
            ((TreeTableTextField)this.getComponent()).offset = offset;
            return component;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                if (SwingUtilities.isLeftMouseButton(me)) {
                    for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                        if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                        MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                        JTreeTable.this.tree.dispatchEvent(newME);
                        break;
                    }
                }
                return false;
            }
            return e == null;
        }
    }

    static class TreeTableTextField
    extends JTextField {
        public int offset;

        TreeTableTextField() {
        }

        @Override
        public void reshape(int x, int y, int w, int h) {
            int newX = Math.max(x, this.offset);
            super.setBounds(newX, y, w - (newX - x), h);
        }
    }
}

