/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.converters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.base.converters.AbstractBGConverter;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class ConverterCustomerBank
extends AbstractBGConverter {
    private static final String CONVERTER_DB_KEY = "customer.bank.converter.run";

    @Override
    public void runConverter(Connection con) {
        boolean needConvert = Utils.maskBlank((String)ServerUtils.getSetupValue(con, CONVERTER_DB_KEY), (String)"0").equals("0");
        if (needConvert) {
            String querySelect = "SELECT * FROM customer WHERE type='u'";
            String queryUpdate = "UPDATE customer SET data=? WHERE id=?";
            try (PreparedStatement psSelect = con.prepareStatement(querySelect);
                 PreparedStatement psUpdate = con.prepareStatement(queryUpdate);){
                try (ResultSet rs = psSelect.executeQuery();){
                    while (rs.next()) {
                        JSONObject bank;
                        int id = rs.getInt("id");
                        String data = rs.getString("data");
                        JSONObject json = new JSONObject(data);
                        JSONObject customer = json.optJSONObject("customer");
                        if (customer == null) {
                            customer = new JSONObject();
                            json.put("customer", (Object)customer);
                        }
                        if ((bank = customer.optJSONObject("bank")) == null) continue;
                        JSONArray banks = customer.optJSONArray("banks");
                        if (banks == null) {
                            banks = new JSONArray();
                            json.put("banks", (Object)banks);
                        }
                        boolean add = true;
                        for (int index = 0; index < banks.length(); ++index) {
                            JSONObject b = banks.getJSONObject(index);
                            if (!bank.optString("bik").equals(b.optString("bik")) || !bank.optString("account").equals(b.optString("accountR"))) continue;
                            add = false;
                            break;
                        }
                        if (add) {
                            JSONObject b = new JSONObject().put("bik", (Object)bank.optString("bik")).put("accountR", (Object)bank.optString("account")).put("accountC", (Object)bank.optString("accountK")).put("name", (Object)bank.optString("name")).put("uuid", (Object)UUID.randomUUID().toString());
                            banks.put((Object)b);
                        }
                        customer.remove("bank");
                        psUpdate.setString(1, json.toString());
                        psUpdate.setInt(2, id);
                        psUpdate.executeUpdate();
                    }
                }
                ServerUtils.setSetupValue(con, CONVERTER_DB_KEY, "1");
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }
}

