/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.common.client.BGOptionPane;
import ru.bitel.common.function.TryCall;
import ru.bitel.common.function.TryCallBoolean;

public class BGEditorDialog<T> {
    protected String title = "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440";
    protected BGOptionPane optionPane = null;
    protected JPanel panel = new JPanel(new GridBagLayout());
    protected T data;
    protected ClientContext clientContext;
    protected boolean doApply = false;
    private Dimension dialogSize = null;

    public BGEditorDialog(String title, T data) {
        this.title = title;
        this.data = data;
    }

    public BGEditorDialog(String title, T data, ClientContext clientContext) {
        this.title = title;
        this.data = data;
        this.clientContext = clientContext;
    }

    public T getData() {
        return this.data;
    }

    public Optional<T> optData() {
        return Optional.ofNullable(this.data);
    }

    public void open() {
        this.getDialog().setVisible(true);
    }

    public void setDialogSize(Dimension dimension) {
        this.dialogSize = dimension;
    }

    public JDialog getDialog() {
        this.doDialogPanel();
        this.optionPane = this.getBGOptionPane();
        JDialog dialog = this.optionPane.getDialog();
        dialog.setDefaultCloseOperation(2);
        ((JButton)this.optionPane.getOptions()[0]).addActionListener(e -> {
            try {
                if (this.doApply()) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog(ex);
            }
        });
        if (this.dialogSize != null) {
            dialog.setSize(this.dialogSize);
            dialog.setPreferredSize(this.dialogSize);
        }
        return dialog;
    }

    public void doDialogPanel() {
    }

    protected BGOptionPane getBGOptionPane() {
        this.panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        return new BGOptionPane(this.panel, this.title){

            @Override
            protected void doCancel() {
                BGEditorDialog.this.doCancel();
            }
        };
    }

    protected void addFieldV(String labelText, JComponent component) {
        this.addFieldV(labelText, component, this.panel);
    }

    protected void addFieldVB(String labelText, JComponent component) {
        this.addFieldVB(labelText, component, this.panel);
    }

    protected void addFieldV(String labelText, JComponent component, JPanel panel) {
        panel.add((Component)new JLabel(labelText), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        panel.add((Component)component, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 0, 0, 0), 0, 0));
    }

    protected void addFieldVB(String labelText, JComponent component, JPanel panel) {
        panel.add((Component)new JLabel(labelText), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        panel.add((Component)component, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
    }

    protected void addFieldH(String labelText, JComponent component) {
        this.addFieldH(labelText, component, 1.0, 17, 2, this.panel);
    }

    protected void addFieldH(String labelText, JComponent component, JPanel panel) {
        this.addFieldH(labelText, component, 1.0, 17, 2, panel);
    }

    protected void addFieldH(String labelText, JComponent component, double weightx, int anchor, int fill, JPanel panel) {
        panel.add((Component)new JLabel(labelText), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 3, 0), 0, 0));
        panel.add((Component)component, new GridBagConstraints(1, -1, 1, 1, weightx, 0.0, anchor, fill, new Insets(0, 5, 3, 0), 0, 0));
    }

    public boolean doApply() throws Exception {
        this.doApply = true;
        return true;
    }

    public void doCancel() {
    }

    public boolean isDoApply() {
        return this.doApply;
    }

    protected void tryCall(TryCall tryCall) {
        tryCall.call();
    }

    protected boolean tryCallBoolean(TryCallBoolean tryCall) {
        return tryCall.call();
    }
}

