/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariffEntry;
import ru.bitel.common.TimeUtils;

public class ContractTariffEntryDao {
    private final Connection con;

    public ContractTariffEntryDao(Connection con) {
        this.con = con;
    }

    public List<ContractTariffEntry> list(int contractId, Date date, int entityMid, int entityId) throws BGException {
        try {
            String query = "(SELECT contract_tariff.id, tariff_plan.tree_id, contract_tariff.date1, contract_tariff.date2, contract_tariff.emid, contract_tariff.eid, 1, contract_tariff.pos, tariff_plan.title, tariff_plan.id, contract_tariff.comment, contract_tariff.replaced_from, replaced_plan.id,tariff_plan.title_web,tariff_plan.comment FROM contract_tariff INNER JOIN tariff_plan ON contract_tariff.tpid=tariff_plan.id LEFT JOIN tariff_plan as replaced_plan ON contract_tariff.replaced_from>0 AND contract_tariff.replaced_from=replaced_plan.id WHERE cid=? AND (? OR isNull(date2) OR date2='0000-00-00' OR date2>=?) AND ((emid=0 AND eid=0) OR (emid=? AND eid=?))) UNION (SELECT id, tree_id, date1, date2, emid, eid, 0, pos, title, 0, '', 0, 0,title_web,'' FROM contract_tree_link WHERE cid=? AND (? OR date2 IS NULL OR date2>=?) AND ((emid=0 AND eid=0) OR (emid=? AND eid=?))) ORDER BY 3 ASC";
            java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate(date);
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, contractId);
            ps.setBoolean(2, date == null);
            ps.setDate(3, sqlDate);
            ps.setInt(4, entityMid);
            ps.setInt(5, entityId);
            ps.setInt(6, contractId);
            ps.setBoolean(7, date == null);
            ps.setDate(8, sqlDate);
            ps.setInt(9, entityMid);
            ps.setInt(10, entityId);
            ArrayList<ContractTariffEntry> result = new ArrayList<ContractTariffEntry>();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            return result;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    private ContractTariffEntry getFromRS(ResultSet rs) throws SQLException {
        ContractTariffEntry result = new ContractTariffEntry();
        result.setId(rs.getInt(1));
        result.setTreeId(rs.getInt(2));
        result.setDateFrom(TimeUtils.convertSqlDateToDate(rs.getDate(3)));
        result.setDateTo(TimeUtils.convertSqlDateToDate(rs.getDate(4)));
        result.setEntityMid(rs.getInt(5));
        result.setEntityId(rs.getInt(6));
        result.setPersonal(rs.getInt(7) == 0);
        result.setPosition(rs.getInt(8));
        result.setTitle(rs.getString(9));
        result.setTariffPlanId(rs.getInt(10));
        result.setComment(rs.getString(11));
        result.setReplacedFromContractTariffId(rs.getInt(12));
        result.setReplacedFromTariffId(rs.getInt(13));
        result.setWebTitle(rs.getString(14));
        result.setTariffPlanComment(rs.getString(15));
        return result;
    }
}

