/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.common.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class Vista
implements Pageable {
    protected int mNumPagesX;
    protected int mNumPagesY;
    private int mNumPages;
    private Printable mPainter;
    private PageFormat mFormat;

    protected Vista() {
    }

    protected void setPrintable(Printable painter) {
        this.mPainter = painter;
    }

    protected void setPageFormat(PageFormat pageFormat) {
        this.mFormat = pageFormat;
    }

    protected void setSize(float width, float height) {
        this.mNumPagesX = (int)((double)width / this.mFormat.getImageableWidth());
        this.mNumPagesY = (int)((double)height / this.mFormat.getImageableHeight());
        if ((double)width - (double)this.mNumPagesX * this.mFormat.getImageableWidth() > 0.001) {
            ++this.mNumPagesX;
        }
        if ((double)height - (double)this.mNumPagesY * this.mFormat.getImageableHeight() > 0.001) {
            ++this.mNumPagesY;
        }
        this.mNumPages = this.mNumPagesX * this.mNumPagesY;
    }

    @Override
    public int getNumberOfPages() {
        return this.mNumPages;
    }

    protected PageFormat getPageFormat() {
        return this.mFormat;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this.getPageFormat();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        double originX = (double)(pageIndex % this.mNumPagesX) * this.mFormat.getImageableWidth();
        double originY = (double)(pageIndex / this.mNumPagesX) * this.mFormat.getImageableHeight();
        Point2D.Double origin = new Point2D.Double(originX, originY);
        return new TranslatedPrintable(this.mPainter, origin);
    }

    public static final class TranslatedPrintable
    implements Printable {
        private Printable mPainter;
        private Point2D mOrigin;

        public TranslatedPrintable(Printable painter, Point2D origin) {
            this.mPainter = painter;
            this.mOrigin = origin;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(-this.mOrigin.getX(), -this.mOrigin.getY());
            this.mPainter.print(g2, pageFormat, 1);
            return 0;
        }
    }
}

