/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.tariff.range;

import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeManager;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeDao;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEntry;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeLoader;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffWorkerContext;
import ru.bitel.bgbilling.modules.inet.server.tariff.range.InetTrafficRangeDao;
import ru.bitel.common.sql.ConnectionSet;

public class TrafficRangeManager
extends RangeManager {
    public TrafficRangeManager(int moduleId, boolean realtime) throws BGException {
        super(moduleId, realtime);
        this.tablename = "inet_tariff_traffic_range_" + moduleId;
    }

    public long addRangedTraffic(TariffWorkerContext workerContext, InetConnectionRuntime connectionRuntime, int contractTariffOptionId, long treeNodeId, int mode, int type, Calendar time, long maxAmount, long amount, TrafficRangeLoader trafficRangeLoader, Date dateFrom, Date dateTo) throws BGException {
        TrafficRangeEntry rangedTrafficEntry = connectionRuntime.rangedTraffic;
        if (rangedTrafficEntry == null) {
            rangedTrafficEntry = connectionRuntime.rangedTraffic = this.getRangedTrafficEntry(connectionRuntime.contractId);
        }
        long key = TrafficRangeKey.getKey((int)mode, (int)type, (int)connectionRuntime.accountingPeriodId, (int)contractTariffOptionId, (Calendar)time);
        return super.addRangedTraffic(rangedTrafficEntry, workerContext, connectionRuntime.contractId, treeNodeId, key, maxAmount, amount, trafficRangeLoader);
    }

    public long addRangedTraffic(TariffWorkerContext workerContext, InetConnectionRuntime connectionRuntime, long treeNodeId, long rangeKey, long maxAmount, long amount, TrafficRangeLoader trafficRangeLoader) throws BGException {
        TrafficRangeEntry rangedTrafficEntry = connectionRuntime.rangedTraffic;
        if (rangedTrafficEntry == null) {
            rangedTrafficEntry = connectionRuntime.rangedTraffic = this.getRangedTrafficEntry(connectionRuntime.contractId);
        }
        return this.addRangedTraffic(rangedTrafficEntry, workerContext, connectionRuntime.contractId, treeNodeId, rangeKey, maxAmount, amount, trafficRangeLoader);
    }

    protected TrafficRangeDao getTrafficRangeDao(ConnectionSet connectionSet) throws BGException {
        return new InetTrafficRangeDao(connectionSet.getConnection(), this.moduleId);
    }
}

