<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" encoding="UTF-8"/>

<xsl:template match="/data">
######################<br/>
# Отчет по проблеме  #<br/>
######################<br/>
<br/>
Данные по проблеме:<br/>
---------------------<br/>
Код проблемы:	<xsl:value-of select="header/@id"/><br/>
Текущее состояние:	<xsl:value-of select="header/@status"/><br/>
Группа:			<xsl:value-of select="header/@group"/><br/>
Категория:		<xsl:value-of select="header/@category"/><br/>
Открыта: 		<xsl:value-of select="header/@open"/><br/>
Принята:		<xsl:value-of select="header/@accept"/><br/>
Закрыта:		<xsl:value-of select="header/@close"/><br/>
<br/>
Поступили звонки:<br/>
--------------------<br/>
<xsl:for-each select="calls/item">
	<xsl:value-of select="@contract_title"/> код <xsl:value-of select="@id"/><xsl:text>&#xa;</xsl:text><br/>
</xsl:for-each>
<br/>
Участвовавшие группы:<br/>
---------------------<br/>
<xsl:for-each select="groups/item">
	<xsl:value-of select="@title"/><xsl:text>&#xa;</xsl:text><br/>
</xsl:for-each>
<br/>
Описание проблемы:<br/>
---------------------<br/>
<xsl:for-each select="comment/row">
	<xsl:value-of select="@text"/><xsl:text>&#xa;</xsl:text><br/>
</xsl:for-each>
<br/>
Назначены исполнители:<br/>
---------------------<br/>
<xsl:for-each select="executors/item">
	<xsl:value-of select="@title"/><xsl:text>&#xa;</xsl:text><br/>
</xsl:for-each>
<br/>
Ход решения:<br/>
---------------------<br/>
<xsl:for-each select="resolution/row">
	<xsl:value-of select="@text"/><xsl:text>&#xa;</xsl:text><br/>
</xsl:for-each>

</xsl:template>
</xsl:stylesheet>