/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.wm.server.action.web;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.util.Base64;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.wm.common.bean.Transaction;
import ru.bitel.bgbilling.modules.wm.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.wm.server.bean.Constants;
import ru.bitel.bgbilling.modules.wm.server.bean.TransactionManager;
import ru.bitel.common.model.SearchResult;

@WebAction(title="WebMoney")
public class ActionDoTransaction
extends AbstractPaymentAction {
    private static final String LMI_PAYEE_PURSE = "LMI_PAYEE_PURSE";
    private static final String LMI_PAYMENT_NO = "LMI_PAYMENT_NO";
    private static final String LMI_PAYMENT_AMOUNT = "LMI_PAYMENT_AMOUNT";
    private static final String LMI_PAYMENT_DESC = "LMI_PAYMENT_DESC";
    private static final String LMI_PAYMENT_DESC_BASE64 = "LMI_PAYMENT_DESC_BASE64";
    private static final String LMI_RESULT_URL = "LMI_RESULT_URL";
    private static final String LMI_SUCCESS_METHOD = "LMI_SUCCESS_METHOD";
    private static final String LMI_SUCCESS_URL = "LMI_SUCCESS_URL";
    private static final String LMI_FAIL_METHOD = "LMI_FAIL_METHOD";
    private static final String LMI_FAIL_URL = "LMI_FAIL_URL";

    public ActionDoTransaction() {
        super("wm");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws BGException {
        this.setResultParam("gateUrl", this.moduleSetup.get("wm.gate.url", "https://merchant.webmoney.ru/lmi/payment.asp"));
        this.paymentForm(this.moduleName, Constants.class, null);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws BGException {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
            transactionManager.searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
            this.setResultParam("transactions", searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    public void success() throws BGException {
        this.execute();
    }

    public void fail() throws BGException {
        this.execute();
    }

    @WebOperation(title="\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430")
    public void getOrderId() throws BGException {
        if (!new ContractModuleManager(this.con).getContractModuleSet(this.contractId).contains(this.moduleId)) {
            throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430, \u043c\u043e\u0434\u0443\u043b\u044c \u043d\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440.");
        }
        BigDecimal sum = this.req.getBigDecimal("sum", BigDecimal.ZERO).setScale(2, RoundingMode.HALF_EVEN);
        BigDecimal sumMin = this.moduleSetup.getBigDecimal("wm.sum.min", new BigDecimal(100));
        BigDecimal sumMax = this.moduleSetup.getBigDecimal("wm.sum.max", new BigDecimal(5000));
        if (sum.compareTo(BigDecimal.ZERO) <= 0 || sum.compareTo(sumMin) < 0 || sum.compareTo(sumMax) > 0) {
            this.execute();
            throw new BGMessageException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d\u0430 \u0441\u0443\u043c\u043c\u0430!");
        }
        Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
        String description = this.moduleSetup.get("wm.payment.desc", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116 {CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contract.getTitle());
        byte[] descriptionUTF8 = new byte[]{};
        try {
            descriptionUTF8 = description.getBytes("UTF-8");
            description = URLEncoder.encode(description, this.moduleSetup.get("wm.payment.desc.enc", "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error(ex.getMessage());
        }
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setContractId(this.contractId)).setSum(sum)).setStatus(TransactionStatus.CREATED.getCode())).build();
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            transactionManager.update(transaction);
        }
        this.setResultParam(LMI_PAYEE_PURSE, this.moduleSetup.get("wm.payee.purse", ""));
        this.setResultParam(LMI_PAYMENT_AMOUNT, String.valueOf(sum));
        this.setResultParam(LMI_PAYMENT_NO, String.valueOf(transaction.getId()));
        this.setResultParam(LMI_PAYMENT_DESC, description);
        this.setResultParam(LMI_PAYMENT_DESC_BASE64, Base64.getEncoder().encodeToString(descriptionUTF8));
        this.setResultParam(LMI_RESULT_URL, this.moduleSetup.get("wm.result.url", ""));
        this.setResultParam(LMI_SUCCESS_URL, this.moduleSetup.get("wm.success.url", ""));
        this.setResultParam(LMI_SUCCESS_METHOD, this.moduleSetup.getInt("wm.success.method", 1));
        this.setResultParam(LMI_FAIL_URL, this.moduleSetup.get("wm.fail.url", ""));
        this.setResultParam(LMI_FAIL_METHOD, this.moduleSetup.getInt("wm.fail.method", 1));
        if (this.getLogger().isDebugEnabled()) {
            for (String key : this.getResult().keySet()) {
                this.getLogger().debug(key + ": " + this.getResultParam(key));
            }
        }
    }
}

