<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:svg="http://www.w3.org/2000/svg" 
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:st="bitel.billing.server.bill.bean.SummaToString"
	xmlns:counter="bitel.billing.server.util.exslt.Counter"	
	version="1.0">
	
	<xsl:output encoding="UTF-8" method='xml' indent='yes' />

	<xsl:variable name="postal_address" select="'603106 Н.Новгород, пл. Советская, дом 2'" />

	<xsl:template match="data">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">

		<fo:layout-master-set>
			<fo:simple-page-master margin-right="1cm" margin-left="2cm"
				margin-bottom="2cm" margin-top="0.5cm" page-width="21cm"
				page-height="29.7cm" master-name="first">
				<fo:region-body margin-top="1cm" margin-bottom="1.5cm" />
				<fo:region-before extent="1cm" />
				<fo:region-after extent="1.5cm" />
			</fo:simple-page-master>
		</fo:layout-master-set>

		<fo:page-sequence master-reference="first">	
			<fo:flow flow-name="xsl-region-body" font-size="10pt">
			
				<fo:block font-size="16pt" font-weight="bold" text-align="center">Детализация сессий</fo:block>
				<fo:block size="12pt" text-align="center">Аккаунт: <xsl:value-of select="@accountTitle"/> За период: <xsl:value-of select="@period"/></fo:block>
				
				<fo:table table-layout="fixed" space-before="5mm" border-width="0.7pt" border-style="solid">
					<fo:table-column column-width="40mm" />
					<fo:table-column column-width="40mm" />
					<fo:table-column column-width="40mm" />
					<fo:table-column column-width="30mm" />
					<fo:table-column column-width="30mm" />
					<fo:table-header>
						<fo:table-row border-width="0.7pt" border-style="solid" text-align="center">
						  	<fo:table-cell border-style="solid"><fo:block>Время</fo:block></fo:table-cell>
						    <fo:table-cell border-style="solid"><fo:block>С номера</fo:block></fo:table-cell>
						    <fo:table-cell border-style="solid"><fo:block>На номер</fo:block></fo:table-cell>
						    <fo:table-cell border-style="solid"><fo:block>Длительность</fo:block></fo:table-cell>
						    <fo:table-cell border-style="solid"><fo:block>Стоимость</fo:block></fo:table-cell>
						</fo:table-row>
					</fo:table-header>					
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell number-columns-spanned="5">
							      <fo:block text-align="center">Всего сессий <xsl:value-of select="@sessionCount"/>; общей длительностью <xsl:value-of select="@sessionTime"/>; на сумму: <xsl:value-of select="@sessionSum"/></fo:block>
							</fo:table-cell>
						</fo:table-row>
						<xsl:apply-templates select="session" />
					</fo:table-body>
				</fo:table>			
			</fo:flow>	
		</fo:page-sequence>		
		
		</fo:root>
	</xsl:template>
	
	<xsl:template match="session">
		<fo:table-row>
			<fo:table-cell><fo:block><xsl:value-of select="@dateTime"/></fo:block></fo:table-cell>
			<fo:table-cell><fo:block><xsl:value-of select="@called"/></fo:block></fo:table-cell>
			<fo:table-cell><fo:block><xsl:value-of select="@calling"/></fo:block></fo:table-cell>			
			<fo:table-cell><fo:block><xsl:value-of select="@sessionTime"/></fo:block></fo:table-cell>			
			<fo:table-cell><fo:block><xsl:value-of select="@sessionCost"/></fo:block></fo:table-cell>			
		</fo:table-row>		
	</xsl:template>

</xsl:stylesheet>