/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.jws.WebService;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventProcessorException;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.log.common.bean.ConnectionLogEntry;
import ru.bitel.bgbilling.kernel.log.server.bean.ConnectionLogEntryDao;
import ru.bitel.bgbilling.kernel.log.server.event.RequestLogGetEvent;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceRequestLogService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionLogDao;
import ru.bitel.common.TimeUtils;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceRequestLogService")
public class VoiceRequestLogServiceImpl
extends AbstractService
implements VoiceRequestLogService {
    public String voiceConnectionLog(int deviceId, long sessionId, Date connectionStartTime, boolean finished) throws BGException, BGMessageException {
        try (VoiceSessionLogDao sessionDao = finished ? new VoiceSessionLogDao(this.getConnectionSet().getConnection(), this.moduleId, connectionStartTime) : new VoiceSessionDao(this.getConnectionSet().getConnection(), this.moduleId);){
            VoiceSession session = sessionDao.get(sessionId);
            if (session == null) {
                String string = "\u0421\u0435\u0441\u0441\u0438\u044f:" + sessionId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430";
                return string;
            }
            ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(this.getConnectionSet(), this.moduleId);
            List entries = dataLogEntryDao.list(session.getSessionStart(), session.getSessionStop(), deviceId, 0, null, session.getId(), session.getIdentifier());
            if (entries.size() == 0) {
                String string = "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u043b\u043e\u0433\u0430.";
                return string;
            }
            int applicationId = ((ConnectionLogEntry)entries.get(0)).getApplicationId();
            RequestLogGetEvent event = new RequestLogGetEvent(this.moduleId, deviceId, applicationId, entries);
            event = (RequestLogGetEvent)EventProcessor.getInstance().request((Event)event, 10000L);
            if (event == null) {
                String string = "C\u0435\u0440\u0432\u0435\u0440 \u043b\u043e\u0433\u043e\u0432 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d";
                return string;
            }
            String string = this.getTextLog(event);
            return string;
        }
    }

    public String authErrorLog(int deviceId, Date errorTime, int logCoordinateRecordId) throws BGException, BGMessageException {
        ConnectionLogEntryDao dataLogEntryDao = new ConnectionLogEntryDao(this.getConnectionSet(), this.moduleId);
        ConnectionLogEntry entry = dataLogEntryDao.get(deviceId, errorTime, logCoordinateRecordId);
        if (entry == null) {
            return "\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u0430 \u043b\u043e\u0433\u0430.";
        }
        RequestLogGetEvent event = new RequestLogGetEvent(this.moduleId, deviceId, entry);
        event = (RequestLogGetEvent)EventProcessor.getInstance().request((Event)event, 10000L);
        if (event == null) {
            return "C\u0435\u0440\u0432\u0435\u0440 \u043b\u043e\u0433\u043e\u0432 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d";
        }
        dataLogEntryDao.recycle();
        return this.getTextLog(event);
    }

    protected String getTextLog(RequestLogGetEvent event) throws EventProcessorException {
        StringBuilder result = new StringBuilder(1000);
        if (event.getLogEntryResultList() != null) {
            for (RequestLogGetEvent.LogEntryResult entryResult : event.getLogEntryResultList()) {
                result.append("Time: ").append(TimeUtils.format((Date)new Date(entryResult.getMillis()), (String)"dd.MM.yyyy HH:mm:ss")).append("\n");
                result.append(entryResult != null ? entryResult.getData() : "null");
                result.append("\n");
            }
        }
        return result.toString();
    }
}

