/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime.geocode;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMapItem;
import ru.bitel.bgbilling.modules.voice.server.runtime.geocode.GeoNode;

public class ZoneMapCache {
    private static Logger logger = LogManager.getLogger();
    private static final ConcurrentHashMap<Integer, ZoneMapCache> cache = new ConcurrentHashMap();
    private final int moduleId;
    private Map<Integer, GeoNode<VoiceZoneMapItem>> zoneMaps = new HashMap<Integer, GeoNode<VoiceZoneMapItem>>();

    public static synchronized ZoneMapCache getInstance(Connection con, int moduleId) throws BGException {
        ZoneMapCache zoneMapCache = cache.get(moduleId);
        if (zoneMapCache == null) {
            zoneMapCache = new ZoneMapCache(moduleId);
            zoneMapCache.load(con, new Date());
            cache.put(moduleId, zoneMapCache);
        }
        return zoneMapCache;
    }

    private ZoneMapCache(int moduleId) {
        this.moduleId = moduleId;
    }

    public void load(Connection con, Date date) throws BGException {
        try {
            String zoneMapItemTableName = "voice_zone_map_item_" + this.moduleId;
            String geoCodeTableName = "voice_geographic_code_" + this.moduleId;
            String linkTableName = "voice_code_destination_" + this.moduleId;
            String query = " SELECT item.*, geocode.*, link.destinationId  FROM " + zoneMapItemTableName + " as item   LEFT JOIN " + geoCodeTableName + " as geocode ON geocode.id = item.codeId LEFT JOIN " + linkTableName + " as link ON geocode.id = link.codeId";
            try (PreparedStatement ps = con.prepareStatement(query);
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    int zoneMapId = rs.getInt("item.mapId");
                    GeoNode<Object> root = this.zoneMaps.get(zoneMapId);
                    if (root == null) {
                        root = new GeoNode();
                        this.zoneMaps.put(zoneMapId, root);
                    }
                    VoiceZoneMapItem item = new VoiceZoneMapItem();
                    item.setId(rs.getInt("item.id"));
                    item.setZoneId(rs.getInt("item.zoneId"));
                    item.setMapId(zoneMapId);
                    VoiceGeographicCode result = new VoiceGeographicCode();
                    int codeId = rs.getInt("geocode.id");
                    if (codeId <= 0) {
                        logger.error("code is null for zoneMapId=" + zoneMapId + " and item.codeId = " + rs.getInt("item.codeId"));
                        continue;
                    }
                    result.setId(codeId);
                    result.setCode(rs.getString("geocode.code"));
                    result.setDestinationId(rs.getInt("link.destinationId"));
                    root.addItem(item, result);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public VoiceZoneMapItem findZone(int mapId, String number) {
        GeoNode<VoiceZoneMapItem> node;
        GeoNode<VoiceZoneMapItem> root = this.zoneMaps.get(mapId);
        if (root != null && (node = root.findNode(number)) != null) {
            return node.getItem();
        }
        return null;
    }
}

