/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.runtime.geocode;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceGeographicCode;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceCostMapItemDao;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceCostMapUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.runtime.geocode.GeoNode;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class CostMapCache
implements EventListener<VoiceCostMapUpdateEvent> {
    private static Logger logger = LogManager.getLogger();
    private static final ConcurrentHashMap<Integer, CostMapCache> cache = new ConcurrentHashMap();
    private final int moduleId;
    private Map<Integer, GeoNode<VoiceCostMapItem>> costMaps = new ConcurrentHashMap<Integer, GeoNode<VoiceCostMapItem>>();
    private final Date date;
    private CostMapItemFinder itemFinder = null;

    public static synchronized CostMapCache getInstance(Connection con, int moduleId, Date date) throws BGException {
        CostMapCache costMapCache = cache.get(moduleId);
        if (costMapCache == null || !TimeUtils.dateEqual((Date)date, (Date)costMapCache.date)) {
            if (costMapCache != null) {
                costMapCache.close();
            }
            costMapCache = new CostMapCache(moduleId, date);
            costMapCache.load(con, null);
            cache.put(moduleId, costMapCache);
        }
        return costMapCache;
    }

    private CostMapCache(int moduleId, Date date) throws BGException {
        this.moduleId = moduleId;
        this.date = date;
        String itemFinderClassName = Setup.getSetup().get("cost.map.item.finder", null);
        if (!Utils.isEmptyString((String)itemFinderClassName)) {
            DynamicClassManager dynamicClassManager = DynamicClassManager.getInstance();
            this.itemFinder = (CostMapItemFinder)dynamicClassManager.newInstance(CostMapItemFinder.class, itemFinderClassName);
        }
        EventProcessor.getInstance().addListener((EventListener)this, VoiceCostMapUpdateEvent.class, moduleId, null);
    }

    public synchronized void load(Connection con, Integer costMapId) throws BGException {
        Map<Integer, GeoNode<VoiceCostMapItem>> costMaps = this.readCostMap(con, costMapId);
        if (costMapId != null) {
            if (costMaps.get(costMapId) != null) {
                this.costMaps.put(costMapId, costMaps.get(costMapId));
            } else {
                this.costMaps.remove(costMapId);
            }
        } else {
            this.costMaps = costMaps;
        }
    }

    public Map<Integer, GeoNode<VoiceCostMapItem>> readCostMap(Connection con, Integer costMapId) throws BGException {
        HashMap<Integer, GeoNode<VoiceCostMapItem>> costMapsLocal = null;
        try (VoiceCostMapItemDao dao = new VoiceCostMapItemDao(con, this.moduleId);){
            String cosMapItemTableName = "voice_cost_map_item_" + this.moduleId;
            String geoCodeTableName = "voice_geographic_code_" + this.moduleId;
            String linkTableName = "voice_code_destination_" + this.moduleId;
            String query = " SELECT item.*, geocode.*, link.destinationId  FROM " + cosMapItemTableName + " as item   LEFT JOIN " + geoCodeTableName + " as geocode ON geocode.id = item.codeId INNER JOIN " + linkTableName + " as link ON geocode.id = link.codeId AND  (link.dateFrom IS NULL OR link.dateFrom <= ?) AND (link.dateTo IS NULL OR link.dateTo >= ?)   WHERE  (item.dateFrom IS NULL OR item.dateFrom <= ?) AND (item.dateTo IS NULL OR item.dateTo >= ?)";
            if (costMapId != null) {
                query = query + " AND item.costMapId = " + costMapId;
            }
            costMapsLocal = new HashMap<Integer, GeoNode<VoiceCostMapItem>>();
            try (PreparedStatement ps = con.prepareStatement(query);){
                int idx = 1;
                ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.date));
                ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.date));
                ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.date));
                ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)this.date));
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    int costMapNewId = rs.getInt("item.costMapId");
                    GeoNode<VoiceCostMapItem> root = (GeoNode<VoiceCostMapItem>)costMapsLocal.get(costMapNewId);
                    if (root == null) {
                        root = new GeoNode<VoiceCostMapItem>();
                        costMapsLocal.put(costMapNewId, root);
                    }
                    VoiceCostMapItem item = new VoiceCostMapItem();
                    item.setId(rs.getInt("item.id"));
                    item.setItemCost(rs.getBigDecimal("item.cost"));
                    item.setCostMapId(rs.getInt("item.costMapId"));
                    VoiceGeographicCode result = new VoiceGeographicCode();
                    int codeId = rs.getInt("geocode.id");
                    if (codeId <= 0) {
                        logger.error("code is null for costMapId=" + costMapNewId + " and item.codeId = " + rs.getInt("item.codeId"));
                        continue;
                    }
                    result.setId(codeId);
                    result.setCode(rs.getString("geocode.code"));
                    result.setDestinationId(rs.getInt("link.destinationId"));
                    root.addItem(item, result);
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return costMapsLocal;
    }

    public VoiceGeographicCode findCode(int mapId, String number) {
        GeoNode<VoiceCostMapItem> root = this.costMaps.get(mapId);
        return root != null ? root.findCode(number) : null;
    }

    public VoiceCostMapItem findCost(int mapId, String number) throws BGException {
        GeoNode<VoiceCostMapItem> node;
        VoiceCostMapItem res;
        if (this.itemFinder != null && (res = this.itemFinder.find(mapId, number)) != null) {
            return res;
        }
        GeoNode<VoiceCostMapItem> root = this.costMaps.get(mapId);
        if (root != null && (node = root.findNode(number)) != null) {
            return node.getItem();
        }
        return null;
    }

    public void notify(VoiceCostMapUpdateEvent e, EventListenerContext ctx) throws BGException {
        this.load(ctx.getConnection(), e.getCostMapId());
    }

    private void close() throws BGException {
        EventProcessor.getInstance().removeListener((EventListener)this);
    }

    public static interface CostMapItemFinder {
        public VoiceCostMapItem find(int var1, String var2);
    }
}

