/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class VoiceCostMapItemDao
extends AbstractIdDao<VoiceCostMapItem> {
    static final String VOICE_COST_MAP_ITEM_TABLENAME = "voice_cost_map_item";

    public VoiceCostMapItemDao(Connection con, int moduleId) {
        super(con, moduleId, VOICE_COST_MAP_ITEM_TABLENAME);
    }

    protected VoiceCostMapItem getFromRS(ResultSet rs) throws SQLException, BGException {
        return this.getFromRS(rs, "");
    }

    private VoiceCostMapItem getFromRS(ResultSet rs, String prefix) throws SQLException {
        VoiceCostMapItem result = new VoiceCostMapItem();
        result.setId(rs.getInt(prefix + "id"));
        result.setCostMapId(rs.getInt(prefix + "costMapId"));
        result.setItemCost(rs.getBigDecimal(prefix + "cost"));
        result.setCodeId(rs.getInt(prefix + "codeId"));
        result.setDateFrom((Date)rs.getDate(prefix + "dateFrom"));
        result.setDateTo((Date)rs.getDate(prefix + "dateTo"));
        return result;
    }

    protected VoiceCostMapItem getImpl(int id) throws BGException, SQLException {
        return (VoiceCostMapItem)super.getImpl(id);
    }

    public void update(VoiceCostMapItem item) throws BGException {
        super.update((Object)item);
    }

    protected void updateImpl(VoiceCostMapItem item) throws BGException, SQLException {
        Object query = "";
        String fields = " costMapId=?, cost=?, codeId=?, dateFrom=?, dateTo=? ";
        query = item.getId() > 0 ? "UPDATE " + this.tableName + " SET " + fields + " WHERE id = ?" : "INSERT INTO " + this.tableName + " SET " + fields;
        try (PreparedStatement ps = this.con.prepareStatement((String)query, 1);){
            int idx = 1;
            ps.setInt(idx++, item.getCostMapId());
            ps.setBigDecimal(idx++, item.getItemCost());
            ps.setInt(idx++, item.getCodeId());
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)item.getDateFrom()));
            ps.setDate(idx++, TimeUtils.convertDateToSqlDate((Date)item.getDateTo()));
            if (item.getId() > 0) {
                ps.setInt(idx++, item.getId());
            }
            ps.executeUpdate();
            if (item.getId() <= 0) {
                item.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public List<VoiceCostMapItem> list(int costMapId, Date date) throws BGException {
        ArrayList<VoiceCostMapItem> result = new ArrayList<VoiceCostMapItem>();
        String geoCodeTableName = ServerUtils.getModuleTableName((String)"voice_geographic_code", (int)this.moduleId);
        String destTableName = ServerUtils.getModuleTableName((String)"voice_destination", (int)this.moduleId);
        String codeDestTableName = ServerUtils.getModuleTableName((String)"voice_code_destination", (int)this.moduleId);
        String query = "SELECT vcm.*,vgc.code, vd.title FROM " + this.tableName + " vcm LEFT JOIN " + geoCodeTableName + " vgc ON vgc.id=vcm.codeId LEFT JOIN " + codeDestTableName + " vcd ON vgc.id=vcd.codeId AND (vcd.dateFrom IS NULL OR vcd.dateFrom <= ?) AND (vcd.dateTo IS NULL OR vcd.dateTo >= ?) LEFT JOIN " + destTableName + " vd ON vcd.destinationId=vd.id WHERE costMapId=? AND (vcm.dateFrom IS NULL OR vcm.dateFrom <= ?) AND (vcm.dateTo IS NULL OR vcm.dateTo >= ? ) ORDER BY vgc.code";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setInt(index++, costMapId);
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    VoiceCostMapItem item = this.getFromRS(rs, "vcm.");
                    item.setCode(rs.getString("vgc.code"));
                    item.setDestinationTitle(rs.getString("vd.title"));
                    result.add(item);
                }
            }
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public List<VoiceCostMapItem> list(int codeId, int costMapId) throws BGException {
        ArrayList<VoiceCostMapItem> result = new ArrayList<VoiceCostMapItem>();
        String geoCodeTableName = ServerUtils.getModuleTableName((String)"voice_geographic_code", (int)this.moduleId);
        String query = "SELECT vcm.*,vgc.code FROM " + this.tableName + " vcm LEFT JOIN " + geoCodeTableName + " vgc ON vgc.id=vcm.codeId WHERE vcm.costMapId = ? ";
        if (codeId > 0) {
            query = query + " AND vcm.codeId=? ";
        }
        query = query + " ORDER BY vgc.code";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, costMapId);
            if (codeId > 0) {
                ps.setInt(index++, codeId);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    VoiceCostMapItem item = this.getFromRS(rs, "vcm.");
                    item.setCode(rs.getString("vgc.code"));
                    result.add(item);
                }
            }
        }
        catch (SQLException e) {
            this.processException(e);
        }
        return result;
    }

    public void deleteByMapId(int id) throws BGException {
        super.delete("costMapId=?", new Object[]{id});
    }

    public Map<Integer, List<VoiceCostMapItem>> codeMap(int codeId, int costMapId) throws BGException {
        HashMap<Integer, List<VoiceCostMapItem>> result = new HashMap<Integer, List<VoiceCostMapItem>>();
        for (VoiceCostMapItem item : this.list(codeId, costMapId)) {
            int key = item.getCodeId();
            ArrayList<VoiceCostMapItem> list = (ArrayList<VoiceCostMapItem>)result.get(key);
            if (list == null) {
                list = new ArrayList<VoiceCostMapItem>();
                result.put(key, list);
            }
            list.add(item);
        }
        for (Integer key : result.keySet()) {
            List list = (List)result.get(key);
            list = VoiceCommonUtils.getDateSortedNormalizeList((List)list);
            result.put(key, list);
        }
        return result;
    }

    public void updateHistory(List<VoiceCostMapItem> itemHistory) throws BGException {
        if (itemHistory != null && !itemHistory.isEmpty()) {
            try {
                VoiceCostMapItem first = itemHistory.get(0);
                String query = "DELETE FROM " + this.tableName + " WHERE codeId=" + first.getCodeId() + " AND costMapId=" + first.getCostMapId();
                try (Statement st = this.con.createStatement();){
                    st.execute(query);
                }
                query = "INSERT INTO " + this.tableName + "  SET id=? , costMapId=?, cost=?, codeId=?, dateFrom=?, dateTo=?  ";
                try (PreparedStatement ps = this.con.prepareStatement(query);){
                    for (VoiceCostMapItem item : itemHistory) {
                        int index = 1;
                        ps.setInt(index++, item.getId());
                        ps.setInt(index++, item.getCostMapId());
                        ps.setBigDecimal(index++, item.getItemCost());
                        ps.setInt(index++, item.getCodeId());
                        ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)item.getDateFrom()));
                        ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)item.getDateTo()));
                        ps.executeUpdate();
                    }
                }
            }
            catch (SQLException e) {
                this.processException(e);
            }
        }
    }
}

