/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.apps.voice.accounting.bean.SessionAccountAmount;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRange;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEntry;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSessionAccount;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionAccountDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionAccountLogDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceSessionLogDao;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntime;
import ru.bitel.bgbilling.modules.voice.server.tariff.range.VoiceTrafficRangeDao;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;

public class VoiceSessionRuntimeFlushingManager {
    protected final int moduleId;
    protected final Date date;
    protected PoolEventPublisher<ContractBalanceChangedEvent> balanceEP;

    public VoiceSessionRuntimeFlushingManager(int moduleId, Date date, PoolEventPublisher<ContractBalanceChangedEvent> balanceEP) {
        this.moduleId = moduleId;
        this.date = date;
        this.balanceEP = balanceEP;
    }

    public boolean insert(ConnectionSet connectionSet, VoiceSessionRuntime runtime) throws BGException {
        try {
            try (VoiceSessionLogDao sessionDao = this.getSessionDao(connectionSet);
                 VoiceSessionAccountLogDao voiceSessionAccountDao = this.getSessionAccountDao(connectionSet);){
                VoiceSessionDao.checkTables(connectionSet.getConnection(), this.moduleId, this.date);
                sessionDao.update(runtime.getSession());
                List<VoiceSessionAccount> accounts = this.getAccounts(runtime);
                voiceSessionAccountDao.updateAccount(accounts);
            }
            this.updateAccountAndBalance(connectionSet, runtime);
            this.updateRanges(runtime, connectionSet);
            runtime.getAccountDeltaMap().clear();
            return true;
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
    }

    protected void updateAccountAndBalance(ConnectionSet connectionSet, VoiceSessionRuntime runtime) throws Exception {
        try (BalanceDao balanceDao = new BalanceDao(connectionSet.getConnection());){
            Calendar cal = TimeUtils.convertDateToCalendar((Date)this.date);
            int yy = cal.get(1);
            int mm = cal.get(2) + 1;
            BigDecimal deltaSum = BigDecimal.ZERO;
            for (Map.Entry<Integer, SessionAccountAmount> entry : runtime.getAccountDeltaMap().entrySet()) {
                int serviceId = entry.getKey();
                BigDecimal delta = entry.getValue().getAccount().setScale(5, RoundingMode.HALF_EVEN);
                balanceDao.addContractAccount(runtime.getContractId(), yy, mm, serviceId, delta);
                deltaSum = deltaSum.add(entry.getValue().getAccount(), MathContext.DECIMAL64);
            }
            if (deltaSum.compareTo(BigDecimal.ZERO) > 0) {
                deltaSum = deltaSum.setScale(2, 6);
                ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(connectionSet, Integer.valueOf(runtime.getContractId()));
                balanceDao.addBalanceAccount(runtime.getContractId(), contractRuntime.getSuperContractId(), yy, mm, deltaSum);
                this.balanceEP.publish((Event)new ContractBalanceChangedEvent(runtime.getContractId(), 1, yy, mm, deltaSum));
            }
        }
    }

    protected VoiceSessionAccountLogDao getSessionAccountDao(ConnectionSet connectionSet) {
        return new VoiceSessionAccountDao(connectionSet.getConnection(), this.moduleId);
    }

    protected VoiceSessionLogDao getSessionDao(ConnectionSet connectionSet) {
        return new VoiceSessionDao(connectionSet.getConnection(), this.moduleId);
    }

    protected List<VoiceSessionAccount> getAccounts(VoiceSessionRuntime runtime) {
        return runtime.getAccountAmountMap().entrySet().stream().map(e -> new VoiceSessionAccount(runtime.getSession(), ((Integer)e.getKey()).intValue(), ((SessionAccountAmount)e.getValue()).getAccount(), ((SessionAccountAmount)e.getValue()).getAmount())).collect(Collectors.toList());
    }

    public final boolean update(ConnectionSet connectionSet, VoiceSessionRuntime runtime) throws BGException {
        return this.insert(connectionSet, runtime);
    }

    protected void updateRanges(VoiceSessionRuntime sessionRuntime, ConnectionSet connectionSet) throws BGException {
        TrafficRangeEntry trafficEntry = sessionRuntime.getRangedTraffic();
        if (trafficEntry == null) {
            return;
        }
        try (VoiceTrafficRangeDao rangeDao = new VoiceTrafficRangeDao(connectionSet.getConnection(), this.moduleId);){
            rangeDao.setCurrentMonth(new Date());
            for (Map.Entry entry : trafficEntry.entrySet()) {
                TrafficRangeKey rangeKey = (TrafficRangeKey)entry.getKey();
                TrafficRange value = (TrafficRange)entry.getValue();
                if (value.delta == 0L) continue;
                long[] amountRef = new long[1];
                Calendar startCal = TimeUtils.convertDateToCalendar((Date)sessionRuntime.getSession().getSessionStart());
                int day = startCal.get(5);
                rangeDao.add(sessionRuntime.getContractId(), rangeKey, day, value.delta, amountRef, value.amount, value.counter, value.maxAmount);
                value.delta = 0L;
            }
        }
        trafficEntry.delta = false;
    }

    public void finishSession(ConnectionSet connectionSet, List<VoiceSession> sessions) throws BGException {
        try {
            VoiceSessionLogDao.checkTables(connectionSet.getConnection(), this.moduleId, this.date);
            Date date = sessions.get(0).getSessionStart();
            String currSessionTable = ServerUtils.getModuleTableName((String)"voice_session", (int)this.moduleId);
            String logSessionTable = ServerUtils.getModuleMonthTableName((String)"voice_session_log", (Date)date, (int)this.moduleId);
            String currAccountTable = ServerUtils.getModuleTableName((String)"voice_session_account", (int)this.moduleId);
            String logAccountTable = ServerUtils.getModuleMonthTableName((String)"voice_session_account_log", (Date)date, (int)this.moduleId);
            String insertSessionQuery = " INSERT INTO " + logSessionTable + " SELECT * from " + currSessionTable + " WHERE id = ? ";
            String insertAccountQuery = " INSERT INTO " + logAccountTable + " SELECT * from " + currAccountTable + " WHERE sessionId = ? ";
            String deleteSessionQuery = " DELETE FROM " + currSessionTable + " WHERE id = ? ";
            String deleteAccountQuery = " DELETE FROM " + currAccountTable + " WHERE sessionId = ? ";
            try (PreparedStatement insertSessionPS = connectionSet.getConnection().prepareStatement(insertSessionQuery);
                 PreparedStatement insertAccountPS = connectionSet.getConnection().prepareStatement(insertAccountQuery);
                 PreparedStatement deleteSessionPS = connectionSet.getConnection().prepareStatement(deleteSessionQuery);
                 PreparedStatement deleteAccountPS = connectionSet.getConnection().prepareStatement(deleteAccountQuery);){
                for (VoiceSession session : sessions) {
                    insertSessionPS.setLong(1, session.getId());
                    insertSessionPS.executeUpdate();
                    insertAccountPS.setLong(1, session.getId());
                    insertAccountPS.executeUpdate();
                }
                for (int i = sessions.size() - 1; i >= 0; --i) {
                    VoiceSession session;
                    session = sessions.get(i);
                    deleteSessionPS.setLong(1, session.getId());
                    deleteSessionPS.executeUpdate();
                    deleteAccountPS.setLong(1, session.getId());
                    deleteAccountPS.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }
}

