/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.twpg.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.modules.twpg.common.bean.Transaction;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractIdDao<Transaction> {
    public TransactionManager(Connection con, int moduleId) {
        super(con, moduleId, "twpg_transaction");
    }

    public void searchTransaction(SearchResult<Transaction> searchResult, SearchParam searchParam) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List list = searchResult.getList();
            StringBuilder query = new StringBuilder(" FROM ").append(this.tableName).append(" AS pt ").append("LEFT JOIN contract c ON c.id=pt.contract_id WHERE true");
            if (period != null) {
                if (period.getDateFrom() != null) {
                    query.append(" AND pt.create_date>=?");
                }
                if (period.getDateTo() != null) {
                    query.append(" AND pt.create_date<=?");
                }
            }
            if (Utils.notBlankString((String)searchParam.getStatus())) {
                query.append(" AND pt.result=?");
            }
            if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                query.append(" AND c.title LIKE ?");
            }
            if (searchParam.getContractId() > 0) {
                query.append(" AND c.id=").append(searchParam.getContractId());
            }
            try {
                ResultSet rs = null;
                PreparedStatement ps = null;
                ps = this.con.prepareStatement("SELECT pt.*, c.title AS contract_title" + query.toString() + (page != null ? page.sqlLimit() : ""));
                int index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                    }
                }
                if (Utils.notBlankString((String)searchParam.getStatus())) {
                    ps.setString(index++, searchParam.getStatus());
                }
                if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                    ps.setString(index++, "%" + searchParam.getContractTitle() + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                rs.close();
                ps.close();
                ps = this.con.prepareStatement("SELECT SUM(pt.summa), COUNT(*) " + query.toString());
                index = 1;
                if (period != null) {
                    if (period.getDateFrom() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateFrom()));
                    }
                    if (period.getDateTo() != null) {
                        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)period.getDateTo()));
                    }
                }
                if (Utils.notBlankString((String)searchParam.getStatus())) {
                    ps.setString(index++, searchParam.getStatus());
                }
                if (Utils.notBlankString((String)searchParam.getContractTitle())) {
                    ps.setString(index++, "%" + searchParam.getContractTitle() + "%");
                }
                rs = ps.executeQuery();
                while (rs.next()) {
                    BigDecimal summa;
                    if (page != null) {
                        page.setRecordCount(rs.getInt(2));
                    }
                    if ((summa = rs.getBigDecimal(1)) == null) continue;
                    searchResult.setSum(summa);
                }
                rs.close();
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException((Throwable)e);
            }
        }
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException, BGException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(rs.getString("contract_title"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setAuthorizationCode(rs.getString("authorization_code")).setCard(rs.getString("card")).setStatus(rs.getString("result"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("summa"))).build();
    }

    protected void updateImpl(Transaction transaction) throws BGException {
        if (transaction != null) {
            try {
                String fields = " SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, authorization_code=?, card=?, result=?, params=?, summa=?";
                int id = transaction.getId();
                StringBuilder query = new StringBuilder(id > 0 ? "UPDATE " : "INSERT INTO ").append(this.tableName).append(" SET contract_id=?, payment_id=?, create_date=?, transaction_date=?, authorization_code=?, card=?, result=?, params=?, summa=?").append(id > 0 ? " WHERE id=?" : "");
                int index = 1;
                PreparedStatement ps = this.con.prepareStatement(query.toString(), 1);
                ps.setInt(index++, transaction.getContractId());
                ps.setInt(index++, transaction.getPaymentId());
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
                ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
                ps.setString(index++, transaction.getAuthorizationCode());
                ps.setString(index++, transaction.getCard());
                ps.setString(index++, transaction.getStatus());
                ps.setString(index++, transaction.getParameters());
                ps.setBigDecimal(index++, transaction.getSum());
                if (id > 0) {
                    ps.setInt(index++, id);
                }
                ps.executeUpdate();
                if (id < 1) {
                    transaction.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
                }
                ps.close();
            }
            catch (SQLException ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }
}

