/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.trayinfo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.trayinfo.common.TrayInfoType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class TrayInfoTypeManager {
    private Connection con;
    private int mid = -1;

    public TrayInfoTypeManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public TrayInfoType getTrayInfoTypeById(int id) throws BGException {
        TrayInfoType result = null;
        try {
            String query = "SELECT * FROM trayinfo_type_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = new TrayInfoType();
                TrayInfoTypeManager.loadTypeFromRS(rs, result);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public List<TrayInfoType> getTrayInfoTypesList(Date date) throws BGException {
        ArrayList<TrayInfoType> result = new ArrayList<TrayInfoType>();
        try {
            String query = "SELECT * FROM trayinfo_type_" + this.mid;
            if (date != null) {
                query = query + " WHERE ( date1 IS NULL OR date1<=? ) AND ( date2 IS NULL OR date2>=? )";
            }
            query = query + " ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            if (date != null) {
                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
                ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                TrayInfoType type = new TrayInfoType();
                result.add(type);
                TrayInfoTypeManager.loadTypeFromRS(rs, type);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return result;
    }

    public void deleteTrayInfoType(int id) throws BGException {
        try {
            String query = "DELETE FROM trayinfo_type_" + this.mid + " WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void updateTrayInfoType(TrayInfoType type) throws BGException {
        try {
            String query = null;
            PreparedStatement ps = null;
            if (type.getId() <= 0) {
                query = "INSERT INTO trayinfo_type_" + this.mid + " ( title, pt, cost, days, date1, date2 ) VALUES ( ?, ?, ?, ?, ?, ? )";
                ps = this.con.prepareStatement(query);
            } else {
                query = "UPDATE trayinfo_type_" + this.mid + " SET title=?, pt=?, cost=?, days=?, date1=?, date2=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(7, type.getId());
            }
            ps.setString(1, type.getTitle());
            ps.setInt(2, type.getChargeType());
            ps.setBigDecimal(3, type.getCost());
            ps.setFloat(4, type.getDays());
            ps.setDate(5, TimeUtils.convertDateToSqlDate((Date)type.getDate1()));
            ps.setDate(6, TimeUtils.convertDateToSqlDate((Date)type.getDate2()));
            ps.executeUpdate();
            if (type.getId() <= 0) {
                type.setId(ServerUtils.lastInsertId((Connection)this.con));
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private static void loadTypeFromRS(ResultSet rs, TrayInfoType type) throws SQLException {
        type.setId(rs.getInt("id"));
        type.setTitle(rs.getString("title"));
        type.setChargeType(rs.getInt("pt"));
        type.setCost(rs.getBigDecimal("cost"));
        type.setDate1((Date)rs.getDate("date1"));
        type.setDate2((Date)rs.getDate("date2"));
        type.setDays(rs.getInt("days"));
    }
}

