/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.common.bean.BGSbpQrUtils;
import ru.bitel.bgbilling.common.bean.BGTransactionType;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.Constants;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.tinkoff.server.event.TinkoffCheckEvent;
import ru.bitel.common.model.SearchResult;

@WebAction(title="Tinkoff")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("tinkoff");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws Exception {
        this.paymentForm(this.moduleName, Constants.class, AutopaymentManager.class);
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        try (TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);){
            SearchParam searchParam = SearchParam.builder().setContractId(this.contractId).setStatus(this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL)).build();
            SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"transactionDatetime:1"});
            transactionManager.searchTransaction(searchResult, searchParam);
            this.setResultParam("transactions", searchResult.getList());
        }
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u043e\u0432 + \u0438\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void check() throws Exception {
        EventProcessor.getInstance().publish((Event)new TinkoffCheckEvent(this.moduleId, this.contractId, false));
        this.execute();
    }

    public void success() throws BGException {
        this.execute();
    }

    public void fail() throws BGException {
        this.execute();
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        boolean sbp = this.moduleSetup.getBoolean("tinkoff.sbp.enable", false) && this.req.getBoolean("sbp", false);
        String paymentPhone = null;
        if (!sbp) {
            try (Connection con = this.setup.getDBConnectionFromPool();){
                paymentPhone = ContractUtils.savePaymentPhone((Connection)con, (int)this.moduleId, (int)this.contractId, (String)this.req.get("payment.phone"));
            }
            if (paymentPhone == null || paymentPhone.isBlank()) {
                // empty if block
            }
        }
        try (TransactionManager transactionManager = new TransactionManager(this.setup.getDBConnection(true), this.moduleId);){
            Contract contract = (Contract)this.context.getRequest().getSession().getAttribute("contract_current");
            transactionManager.registerOrder(this.contractId, contract.getTitle(), this.customerAddress, this.sum, this.getResult(), false, false, sbp ? BGTransactionType.QR_SBP : BGTransactionType.CARD, paymentPhone);
        }
        String qrUrl = (String)this.getResultParam("Data");
        if (sbp && qrUrl != null) {
            this.setResultParam("formUrl", qrUrl);
            this.setResultParam("qrImgData", BGSbpQrUtils.getSbpQR((String)qrUrl));
            String userAgent = this.context.getRequest().getHeader("User-Agent");
            this.setResultParam("android", BGSbpQrUtils.isAndroid((String)userAgent));
            this.setResultParam("apple", BGSbpQrUtils.isApple((String)userAgent));
            this.requestDispatcher("include", "payment_sbp");
        } else {
            this.doRedirect();
        }
    }

    @WebOperation(title="\u0410\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436")
    public void autopayment() throws Exception {
        super.autopayment();
        try (AutopaymentManager autopaymentManager = new AutopaymentManager(this.con, this.moduleId);){
            this.autopaymentImpl("tinkoff", autopaymentManager, Constants.class);
        }
    }

    protected void registerOrder(BigDecimal sum, String customerAddress) throws Exception {
        try (TransactionManager transactionManager = new TransactionManager(this.setup.getDBConnection(true), this.moduleId);){
            String contractTitle = ((Contract)this.context.getRequest().getSession().getAttribute("contract_current")).getTitle();
            String paymentPhone = ContractUtils.getPaymentPhone((Connection)this.con, (int)this.moduleId, (int)this.contractId);
            transactionManager.registerOrder(this.contractId, contractTitle, customerAddress, sum, this.getResult(), false, true, BGTransactionType.CARD, paymentPhone);
        }
    }

    protected void autopaymentRedirect(boolean redirect) throws Exception {
        if (redirect) {
            this.doRedirect();
        } else {
            this.execute();
        }
    }

    protected void doRedirect() throws BGException {
        Object paymentURL = this.getResultParam("PaymentURL");
        if (paymentURL != null) {
            try {
                this.setResultParam("contentType", ActionResultContentType.binary);
                this.context.getResponse().sendRedirect(String.valueOf(paymentURL));
                return;
            }
            catch (IOException ex) {
                this.execute();
                throw new BGMessageException(ex.getMessage());
            }
        }
        this.execute();
        throw new BGMessageException(this.getResultParam("Message") + " [errorCode=" + this.getResultParam("ErrorCode") + "]");
    }
}

