/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.subscription.server.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.util.AbstractPeriodItemSet;

public final class SubscriptionList
extends AbstractPeriodItemSet<SubscriptionItem> {
    private static final Logger logger = LogManager.getLogger();

    SubscriptionList(List<SubscriptionItem> entryList) {
        super(SubscriptionItem.class, entryList);
        if (logger.isDebugEnabled()) {
            logger.debug("Create: ");
            for (SubscriptionItem item : (SubscriptionItem[])this.entries) {
                logger.debug("Item: " + TimeUtils.format((Date)new Date(item.timeFrom), (String)"dd.MM.yyyy HH:mm:ss.S") + " - " + TimeUtils.format((Date)new Date(item.timeTo), (String)"dd.MM.yyyy HH:mm:ss.S"));
            }
        }
    }

    SubscriptionList(SubscriptionItem[] entries) {
        super(SubscriptionItem.class, (AbstractPeriodItemSet.PeriodItem[])entries);
        if (logger.isDebugEnabled()) {
            logger.debug("Create: ");
            for (SubscriptionItem item : entries) {
                logger.debug("Item: " + TimeUtils.format((Date)new Date(item.timeFrom), (String)"dd.MM.yyyy HH:mm:ss.S") + " - " + TimeUtils.format((Date)new Date(item.timeTo), (String)"dd.MM.yyyy HH:mm:ss.S"));
            }
        }
    }

    protected boolean containsMillis(SubscriptionItem item, long millis) {
        assert (item.timeFrom != 0L);
        return item.timeFrom <= millis && (item.timeTo == 0L || millis <= item.timeTo);
    }

    protected boolean isCoincide(SubscriptionItem item, SubscriptionItem other) {
        return other.subscriptionId.equals(item.subscriptionId) && other.timeFrom == item.timeFrom && other.id == item.id;
    }

    public long getTimeFrom(int subscriptionId) {
        int size = ((SubscriptionItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            SubscriptionItem item = ((SubscriptionItem[])this.entries)[i];
            if (subscriptionId != item.subscriptionId) continue;
            return item.timeFrom;
        }
        return 0L;
    }

    public Map<Integer, List<SubscriptionItem>> subscriptionListMap(long timeFrom, long timeTo) {
        if (((SubscriptionItem[])this.entries).length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<SubscriptionItem>> options = new HashMap<Integer, List<SubscriptionItem>>(4);
        long[] intersection = new long[2];
        int size = ((SubscriptionItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            SubscriptionItem item = ((SubscriptionItem[])this.entries)[i];
            long[] period = RangeUtils.intersectionAnd((long[])intersection, (long)item.timeFrom, (long)item.timeTo, (long)timeFrom, (long)timeTo);
            if (period == null) continue;
            ArrayList<SubscriptionItem> list = (ArrayList<SubscriptionItem>)options.get(item.id);
            if (list == null) {
                list = new ArrayList<SubscriptionItem>(4);
                options.put(item.id, list);
            }
            list.add(item);
        }
        if (options.size() > 0) {
            return options;
        }
        return Collections.emptyMap();
    }

    public SubscriptionList add(int optionId, int contractOptionId, long timeFrom, long timeTo) {
        return new SubscriptionList((SubscriptionItem[])super.add((AbstractPeriodItemSet.PeriodItem)new SubscriptionItem(optionId, contractOptionId, timeFrom, timeTo)));
    }

    public SubscriptionList update(int optionId, int contractOptionId, long timeFrom, long timeTo) {
        return new SubscriptionList((SubscriptionItem[])super.update((AbstractPeriodItemSet.PeriodItem)new SubscriptionItem(optionId, contractOptionId, timeFrom, timeTo)));
    }

    public static final class SubscriptionItem
    extends AbstractPeriodItemSet.PeriodItem {
        public final Integer subscriptionId;

        public SubscriptionItem(int typeId, int subscriptionId, Date timeFrom, Date timeTo) {
            this(typeId, subscriptionId, timeFrom != null ? timeFrom.getTime() : 0L, timeTo != null ? timeTo.getTime() : 0L);
        }

        public SubscriptionItem(int typeId, int subscriptionId, long timeFrom, long timeTo) {
            super(typeId, timeFrom, timeTo != 0L ? timeTo / 1000L * 1000L + 999L : timeTo);
            this.subscriptionId = subscriptionId;
        }
    }
}

